/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class GammaThresholdEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_THRESHOLD = "u_threshold";
    private static final String U_THRESHOLD_INV = "u_thresholdInv";
    private float gamma;

    public GammaThresholdEffect(Type type) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/gamma-threshold.frag"), (String)("#define THRESHOLD_TYPE " + type.name())));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_THRESHOLD, this.gamma);
        this.program.setUniformf(U_THRESHOLD_INV, 1.0f / (1.0f - this.gamma));
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        this.setUniform(U_THRESHOLD, gamma);
        this.setUniform(U_THRESHOLD_INV, 1.0f / (1.0f - gamma));
    }

    public float getGamma() {
        return this.gamma;
    }

    public static enum Type {
        RGBA,
        RGB,
        ALPHA_PREMULTIPLIED;

    }
}

