/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.CompositeVfxEffect;
import com.crashinvaders.vfx.effects.GaussianBlurEffect;
import com.crashinvaders.vfx.effects.VfxEffect;
import com.crashinvaders.vfx.effects.util.CombineEffect;
import com.crashinvaders.vfx.effects.util.CopyEffect;
import com.crashinvaders.vfx.effects.util.GammaThresholdEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class BloomEffect
extends CompositeVfxEffect
implements ChainVfxEffect {
    private final CopyEffect copy = (CopyEffect)this.register((VfxEffect)new CopyEffect());
    private final GaussianBlurEffect blur = (GaussianBlurEffect)this.register((VfxEffect)new GaussianBlurEffect());
    private final GammaThresholdEffect threshold = (GammaThresholdEffect)this.register((VfxEffect)new GammaThresholdEffect(GammaThresholdEffect.Type.RGBA));
    private final CombineEffect combine = (CombineEffect)this.register((VfxEffect)new CombineEffect());
    private boolean blending = false;
    private int sfactor;
    private int dfactor;

    public BloomEffect() {
        this(new Settings(10, 0.85f, 1.0f, 0.85f, 1.1f, 0.85f));
    }

    public BloomEffect(Settings settings) {
        this.applySettings(settings);
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        VfxFrameBuffer origSrc = context.getBufferPool().obtain();
        this.copy.render(context, buffers.getSrcBuffer(), origSrc);
        boolean blendingWasEnabled = VfxGLUtils.isGLEnabled((int)3042);
        Gdx.gl.glDisable(3042);
        this.threshold.render(context, buffers);
        buffers.swap();
        this.blur.render(context, buffers);
        buffers.swap();
        if (this.blending || blendingWasEnabled) {
            Gdx.gl.glEnable(3042);
        }
        if (this.blending) {
            Gdx.gl.glBlendFunc(this.sfactor, this.dfactor);
        }
        this.combine.render(context, origSrc, buffers.getSrcBuffer(), buffers.getDstBuffer());
        context.getBufferPool().free(origSrc);
    }

    public float getBaseIntensity() {
        return this.combine.getSource1Intensity();
    }

    public void setBaseIntensity(float intensity) {
        this.combine.setSource1Intensity(intensity);
    }

    public float getBaseSaturation() {
        return this.combine.getSource1Saturation();
    }

    public void setBaseSaturation(float saturation) {
        this.combine.setSource1Saturation(saturation);
    }

    public float getBloomIntensity() {
        return this.combine.getSource2Intensity();
    }

    public void setBloomIntensity(float intensity) {
        this.combine.setSource2Intensity(intensity);
    }

    public float getBloomSaturation() {
        return this.combine.getSource2Saturation();
    }

    public void setBloomSaturation(float saturation) {
        this.combine.setSource2Saturation(saturation);
    }

    public int getBlurPasses() {
        return this.blur.getPasses();
    }

    public void setBlurPasses(int passes) {
        this.blur.setPasses(passes);
    }

    public float getBlurAmount() {
        return this.blur.getAmount();
    }

    public void setBlurAmount(float amount) {
        this.blur.setAmount(amount);
    }

    public boolean isBlendingEnabled() {
        return this.blending;
    }

    public float getThreshold() {
        return this.threshold.getGamma();
    }

    public int getBlendingSourceFactor() {
        return this.sfactor;
    }

    public int getBlendingDestFactor() {
        return this.dfactor;
    }

    public void setThreshold(float gamma) {
        this.threshold.setGamma(gamma);
    }

    public void enableBlending(int sfactor, int dfactor) {
        this.blending = true;
        this.sfactor = sfactor;
        this.dfactor = dfactor;
    }

    public void disableBlending() {
        this.blending = false;
    }

    public GaussianBlurEffect.BlurType getBlurType() {
        return this.blur.getType();
    }

    public void setBlurType(GaussianBlurEffect.BlurType type) {
        this.blur.setType(type);
    }

    public void applySettings(Settings settings) {
        this.setThreshold(settings.bloomThreshold);
        this.setBaseIntensity(settings.baseIntensity);
        this.setBaseSaturation(settings.baseSaturation);
        this.setBloomIntensity(settings.bloomIntensity);
        this.setBloomSaturation(settings.bloomSaturation);
        this.setBlurPasses(settings.blurPasses);
        this.setBlurAmount(settings.blurAmount);
        this.setBlurType(settings.blurType);
    }

    public static class Settings {
        public final GaussianBlurEffect.BlurType blurType;
        public final int blurPasses;
        public final float blurAmount;
        public final float bloomThreshold;
        public final float bloomIntensity;
        public final float bloomSaturation;
        public final float baseIntensity;
        public final float baseSaturation;

        public Settings(int blurPasses, float bloomThreshold, float baseIntensity, float baseSaturation, float bloomIntensity, float bloomSaturation) {
            this(GaussianBlurEffect.BlurType.Gaussian5x5b, blurPasses, 0.0f, bloomThreshold, baseIntensity, baseSaturation, bloomIntensity, bloomSaturation);
        }

        public Settings(GaussianBlurEffect.BlurType blurType, int blurPasses, float blurAmount, float bloomThreshold, float baseIntensity, float baseSaturation, float bloomIntensity, float bloomSaturation) {
            this.blurType = blurType;
            this.blurPasses = blurPasses;
            this.blurAmount = blurAmount;
            this.bloomThreshold = bloomThreshold;
            this.baseIntensity = baseIntensity;
            this.baseSaturation = baseSaturation;
            this.bloomIntensity = bloomIntensity;
            this.bloomSaturation = bloomSaturation;
        }

        public Settings(Settings other) {
            this.blurType = other.blurType;
            this.blurPasses = other.blurPasses;
            this.blurAmount = other.blurAmount;
            this.bloomThreshold = other.bloomThreshold;
            this.baseIntensity = other.baseIntensity;
            this.baseSaturation = other.baseSaturation;
            this.bloomIntensity = other.bloomIntensity;
            this.bloomSaturation = other.bloomSaturation;
        }
    }
}

