/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class CrtEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final Vector2 tmpVec = new Vector2();
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_RESOLUTION = "u_resolution";
    private final Vector2 viewportSize = new Vector2();
    private SizeSource sizeSource = SizeSource.VIEWPORT;

    public CrtEffect() {
        this(LineStyle.HORIZONTAL_HARD, 1.3f, 0.5f);
    }

    public CrtEffect(LineStyle lineStyle, float brightnessMin, float brightnessMax) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/crt.frag"), (String)("#define SL_BRIGHTNESS_MIN " + brightnessMin + "\n#define SL_BRIGHTNESS_MAX " + brightnessMax + "\n#define LINE_TYPE " + lineStyle.ordinal())));
        this.rebind();
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.viewportSize.set((float)width, (float)height);
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        switch (this.sizeSource) {
            case VIEWPORT: {
                this.program.setUniformf(U_RESOLUTION, this.viewportSize);
                break;
            }
            case SCREEN: {
                this.program.setUniformf(U_RESOLUTION, tmpVec.set((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight()));
            }
        }
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public SizeSource getSizeSource() {
        return this.sizeSource;
    }

    public void setSizeSource(SizeSource sizeSource) {
        if (sizeSource == null) {
            throw new IllegalArgumentException("Size source cannot be null.");
        }
        if (this.sizeSource == sizeSource) {
            return;
        }
        this.sizeSource = sizeSource;
        this.rebind();
    }

    public static enum SizeSource {
        VIEWPORT,
        SCREEN;

    }

    public static enum LineStyle {
        CROSSLINE_HARD,
        VERTICAL_HARD,
        HORIZONTAL_HARD,
        VERTICAL_SMOOTH,
        HORIZONTAL_SMOOTH;

    }
}

