/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class FilmGrainEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_SEED = "u_seed";
    private static final String U_NOISE_AMOUNT = "u_noiseAmount";
    private float seed = 0.0f;
    private float noiseAmount = 0.18f;

    public FilmGrainEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/film-grain.frag")));
        this.rebind();
    }

    public void update(float delta) {
        super.update(delta);
        float newSeedValue = (this.seed + delta) % 1.0f;
        this.setSeed(newSeedValue);
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_SEED, this.seed);
        this.program.setUniformf(U_NOISE_AMOUNT, this.noiseAmount);
        this.program.begin();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public float getSeed() {
        return this.seed;
    }

    public void setSeed(float seed) {
        this.seed = seed;
        this.setUniform(U_SEED, seed);
    }

    public float getNoiseAmount() {
        return this.noiseAmount;
    }

    public void setNoiseAmount(float noiseAmount) {
        this.noiseAmount = noiseAmount;
        this.setUniform(U_NOISE_AMOUNT, noiseAmount);
    }
}

