/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class OldTvEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String Texture0 = "u_texture0";
    private static final String Resolution = "u_resolution";
    private static final String Time = "u_time";
    private final Vector2 resolution = new Vector2();
    private float time = 0.0f;

    public OldTvEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/old-tv.frag")));
        this.rebind();
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.resolution.set((float)width, (float)height);
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(Texture0, 0);
        this.program.setUniformf(Resolution, this.resolution);
        this.program.setUniformf(Time, this.time);
        this.program.end();
    }

    public void update(float delta) {
        super.update(delta);
        this.setTime(this.time + delta);
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
        this.setUniform(Time, time);
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }
}

