/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class RadialDistortionEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_DISTORTION = "distortion";
    private static final String U_ZOOM = "zoom";
    private float zoom = 1.0f;
    private float distortion = 0.3f;

    public RadialDistortionEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/radial-distortion.frag")));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_DISTORTION, this.distortion);
        this.program.setUniformf(U_ZOOM, this.zoom);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.setUniform(U_ZOOM, this.zoom);
    }

    public float getDistortion() {
        return this.distortion;
    }

    public void setDistortion(float distortion) {
        this.distortion = distortion;
        this.setUniform(U_DISTORTION, this.distortion);
    }
}

