/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class CombineEffect
extends ShaderVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_TEXTURE1 = "u_texture1";
    private static final String U_SOURCE0_INTENSITY = "u_src0Intensity";
    private static final String U_SOURCE0_SATURATION = "u_src0Saturation";
    private static final String U_SOURCE1_INTENSITY = "u_src1Intensity";
    private static final String U_SOURCE1_SATURATION = "u_src1Saturation";
    private float s1i = 1.0f;
    private float s1s = 1.0f;
    private float s2i = 1.0f;
    private float s2s = 1.0f;

    public CombineEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/combine.frag")));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformi(U_TEXTURE1, 1);
        this.program.setUniformf(U_SOURCE0_INTENSITY, this.s1i);
        this.program.setUniformf(U_SOURCE1_INTENSITY, this.s2i);
        this.program.setUniformf(U_SOURCE0_SATURATION, this.s1s);
        this.program.setUniformf(U_SOURCE1_SATURATION, this.s2s);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src0, VfxFrameBuffer src1, VfxFrameBuffer dst) {
        src0.getTexture().bind(0);
        src1.getTexture().bind(1);
        this.renderShader(context, dst);
    }

    public float getSource1Intensity() {
        return this.s1i;
    }

    public void setSource1Intensity(float intensity) {
        this.s1i = intensity;
        this.setUniform(U_SOURCE0_INTENSITY, intensity);
    }

    public float getSource2Intensity() {
        return this.s2i;
    }

    public void setSource2Intensity(float intensity) {
        this.s2i = intensity;
        this.setUniform(U_SOURCE1_INTENSITY, intensity);
    }

    public float getSource1Saturation() {
        return this.s1s;
    }

    public void setSource1Saturation(float saturation) {
        this.s1s = saturation;
        this.setUniform(U_SOURCE0_SATURATION, saturation);
    }

    public float getSource2Saturation() {
        return this.s2s;
    }

    public void setSource2Saturation(float saturation) {
        this.s2s = saturation;
        this.setUniform(U_SOURCE1_SATURATION, saturation);
    }
}

