/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class MixEffect
extends ShaderVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_TEXTURE1 = "u_texture1";
    private static final String U_MIX = "u_mix";
    private float mixFactor = 0.5f;

    public MixEffect(Method method) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/mix.frag"), (String)("#define METHOD " + method.name())));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformi(U_TEXTURE1, 1);
        this.program.setUniformf(U_MIX, this.mixFactor);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src0, VfxFrameBuffer src1, VfxFrameBuffer dst) {
        src0.getTexture().bind(0);
        src1.getTexture().bind(1);
        this.renderShader(context, dst);
    }

    public float getMixFactor() {
        return this.mixFactor;
    }

    public void setMixFactor(float mixFactor) {
        this.mixFactor = MathUtils.clamp((float)0.0f, (float)1.0f, (float)mixFactor);
        this.setUniform(U_MIX, mixFactor);
    }

    public static enum Method {
        MAX,
        MIX;

    }
}

