/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.VipsRectangle;
import com.crawljax.vips_selenium.VipsUtils;
import com.crawljax.vips_selenium.VisualStructure;
import com.crawljax.vips_selenium.XPathHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class VipsOutput {
    private static final Logger LOG = LoggerFactory.getLogger(VipsOutput.class);
    boolean fragOutput = true;
    private Document doc = null;
    private boolean _escapeOutput = true;
    private int _pDoC = 0;
    private int _order = 1;
    private File _filename = null;

    public VipsOutput() {
    }

    public VipsOutput(int pDoC, File fileName, boolean fragOutput) {
        this.setPDoC(pDoC);
        this._filename = fileName;
        this.fragOutput = fragOutput;
    }

    private String getSource(Node elementBox) {
        String content = "";
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(elementBox), new StreamResult(buffer));
            content = buffer.toString().replaceAll("\n", "");
        }
        catch (TransformerException e) {
            LOG.error("Error getting source for node {}", (Object)elementBox);
            LOG.debug(e.getMessage());
        }
        return content;
    }

    private void writeVisualBlocks(Element parentNode, VisualStructure visualStructure, int level) {
        Element layoutNode = this.doc.createElement("LayoutNode");
        layoutNode.setAttribute("FrameSourceIndex", String.valueOf(visualStructure.getFrameSourceIndex()));
        layoutNode.setAttribute("SourceIndex", XPathHelper.getXPathExpression(visualStructure.getNestedBlocks().get(0)));
        layoutNode.setAttribute("DoC", String.valueOf(visualStructure.getDoC()));
        layoutNode.setAttribute("ContainImg", String.valueOf(visualStructure.containImg()));
        layoutNode.setAttribute("IsImg", String.valueOf(visualStructure.isImg()));
        layoutNode.setAttribute("ContainTable", String.valueOf(visualStructure.containTable()));
        layoutNode.setAttribute("ContainP", String.valueOf(visualStructure.containP()));
        layoutNode.setAttribute("TextLen", String.valueOf(visualStructure.getTextLength()));
        layoutNode.setAttribute("LinkTextLen", String.valueOf(visualStructure.getLinkTextLength()));
        Node parentBox = VipsUtils.getParentBox(visualStructure.getNestedBlocks());
        layoutNode.setAttribute("DOMCldNum", String.valueOf(parentBox.getChildNodes().getLength()));
        layoutNode.setAttribute("FontSize", String.valueOf(visualStructure.getFontSize()));
        layoutNode.setAttribute("FontWeight", String.valueOf(visualStructure.getFontWeight()));
        layoutNode.setAttribute("BgColor", visualStructure.getBgColor());
        layoutNode.setAttribute("ObjectRectLeft", String.valueOf(visualStructure.getX()));
        layoutNode.setAttribute("ObjectRectTop", String.valueOf(visualStructure.getY()));
        layoutNode.setAttribute("ObjectRectWidth", String.valueOf(visualStructure.getWidth()));
        layoutNode.setAttribute("ObjectRectHeight", String.valueOf(visualStructure.getHeight()));
        layoutNode.setAttribute("ID", visualStructure.getId());
        layoutNode.setAttribute("order", String.valueOf(this._order));
        layoutNode.setAttribute("level", String.valueOf(level));
        ++this._order;
        VipsUtils.setVipsLevel(parentBox, level);
        if (this._pDoC >= visualStructure.getDoC()) {
            if (visualStructure.getChildrenVisualStructures().size() == 0 && visualStructure.getNestedBlocks().size() > 0) {
                Object src = "";
                Object content = "";
                for (Node block : visualStructure.getNestedBlocks()) {
                    Node elementBox = block;
                    if (elementBox == null) continue;
                    src = !elementBox.getNodeName().equalsIgnoreCase("Xdiv") && !elementBox.getNodeName().equalsIgnoreCase("Xspan") ? (String)src + this.getSource(elementBox) : (String)src + elementBox.getTextContent().trim();
                    content = (String)content + elementBox.getTextContent().trim() + " ";
                }
            }
            parentNode.appendChild(layoutNode);
            for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
                this.writeVisualBlocks(layoutNode, child, level + 1);
            }
        } else {
            if (visualStructure.getNestedBlocks().size() > 0) {
                Object src = "";
                Object content = "";
                for (Node block : visualStructure.getNestedBlocks()) {
                    Node elementBox = block;
                    if (elementBox == null) continue;
                    src = !elementBox.getNodeName().equals("Xdiv") && !elementBox.getNodeName().equals("Xspan") ? (String)src + this.getSource(elementBox) : (String)src + elementBox.getTextContent().trim();
                    content = (String)content + elementBox.getTextContent().trim() + " ";
                }
                layoutNode.setAttribute("SRC", (String)src);
                layoutNode.setAttribute("Content", (String)content);
            }
            parentNode.appendChild(layoutNode);
        }
    }

    public int drawVisualStructure(VisualStructure visualStructure, Graphics2D g2d, List<VipsRectangle> vipsRectangles, int id, int parentId, WebDriver driver) {
        LOG.debug(visualStructure.getNestedBlocks().toString());
        Rectangle rect2 = new Rectangle(visualStructure.getX(), visualStructure.getY(), visualStructure.getWidth(), visualStructure.getHeight());
        LOG.debug("VIPS" + rect2);
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(1.0f));
        Node vipsBlock = VipsUtils.getParentBox(visualStructure.getNestedBlocks());
        Rectangle finalRect = null;
        Rectangle boxRect = VipsUtils.getRectangle(vipsBlock, driver);
        if (boxRect == null) {
            boxRect = new Rectangle(rect2.x, rect2.y, rect2.height, rect2.width);
        }
        Rectangle rect1 = new Rectangle(boxRect.x, boxRect.y, boxRect.width, boxRect.height);
        g2d.setColor(Color.red);
        g2d.setStroke(new BasicStroke(1.0f));
        if (rect2.contains(rect1) || rect2.width * rect2.height <= 0) {
            LOG.debug("DOM rectangle is contained within vips");
            finalRect = rect1;
        }
        if (rect1.contains(rect2) || rect1.width * rect1.height <= 0) {
            LOG.debug("VIPS rectangle is contained within dom");
            finalRect = rect2;
        }
        if (!rect2.contains(rect1) && !rect1.contains(rect2) && rect1.width * rect1.height > 0 && rect2.width * rect2.height > 0) {
            Rectangle rect3;
            LOG.debug("Overflowing rectangles");
            finalRect = rect3 = VipsUtils.getIntersectionRectangle(rect1, rect2);
            LOG.debug("Intersection" + rect3);
            g2d.setColor(Color.blue);
            g2d.setStroke(new BasicStroke(1.0f));
        }
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(5.0f));
        g2d.draw(finalRect);
        VipsRectangle me = new VipsRectangle(visualStructure.getNestedBlocks(), id, parentId, XPathHelper.getXPathExpression(vipsBlock), finalRect);
        vipsRectangles.add(me);
        int childId = id + 1;
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            childId = this.drawVisualStructure(child, g2d, vipsRectangles, childId, id, driver);
            ++childId;
        }
        return childId;
    }

    public List<VipsRectangle> exportVisualStructureToImage(VisualStructure visualStructure, BufferedImage pageViewport, File target, boolean fragOutput, WebDriver driver) {
        LOG.debug(visualStructure.getNestedBlocks().toString());
        BufferedImage image = new BufferedImage(pageViewport.getWidth(), pageViewport.getHeight(), pageViewport.getType());
        Graphics2D g2d = image.createGraphics();
        g2d.drawImage((Image)pageViewport, 0, 0, null);
        g2d.setColor(Color.black);
        ArrayList<VipsRectangle> vipsRectangles = new ArrayList<VipsRectangle>();
        this.drawVisualStructure(visualStructure, g2d, vipsRectangles, 0, -1, driver);
        if (fragOutput) {
            VipsUtils.saveToImage(image, target);
        }
        return vipsRectangles;
    }

    public void writeXML(VisualStructure visualStructure, BufferedImage pageViewport, String url, String title) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            Element vipsElement = this.doc.createElement("VIPSPage");
            vipsElement.setAttribute("Url", url);
            vipsElement.setAttribute("PageTitle", title);
            vipsElement.setAttribute("WindowWidth", String.valueOf(pageViewport.getWidth()));
            vipsElement.setAttribute("WindowHeight", String.valueOf(pageViewport.getHeight()));
            vipsElement.setAttribute("neworder", "0");
            this.doc.appendChild(vipsElement);
            this.writeVisualBlocks(vipsElement, visualStructure, 0);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.doc);
            if (this._escapeOutput) {
                StreamResult result = new StreamResult(this._filename);
                transformer.transform(source, result);
            } else {
                StringWriter writer = new StringWriter();
                transformer.transform(source, new StreamResult(writer));
                String result = writer.toString();
                result = result.replaceAll("&gt;", ">");
                result = result.replaceAll("&lt;", "<");
                result = result.replaceAll("&quot;", "\"");
                if (this.fragOutput) {
                    FileWriter fstream = new FileWriter(this._filename + ".xml");
                    fstream.write(result);
                    fstream.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error: " + e.getMessage());
        }
    }

    public void setEscapeOutput(boolean value) {
        this._escapeOutput = value;
    }

    public void setPDoC(int pDoC) {
        if (pDoC <= 0 || pDoC > 11) {
            System.err.println("pDoC value must be between 1 and 11! Not " + pDoC + "!");
            return;
        }
        this._pDoC = pDoC;
    }

    public void setOutputFileName(File filename) {
        if (filename != null) {
            this._filename = filename;
        }
    }
}

