/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.assertthat.selenium_shutterbug.core.Shutterbug;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import com.crawljax.vips_selenium.DomUtils;
import com.crawljax.vips_selenium.VipsOutput;
import com.crawljax.vips_selenium.VipsRectangle;
import com.crawljax.vips_selenium.VipsSeleniumParser;
import com.crawljax.vips_selenium.VipsSeparatorGraphicsDetector;
import com.crawljax.vips_selenium.VipsUtils;
import com.crawljax.vips_selenium.VisualStructureConstructor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.imageio.ImageIO;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VipsSelenium {
    private static final Logger LOG = LoggerFactory.getLogger(VipsSelenium.class);
    public WebDriver driver = null;
    public Document dom = null;
    public BufferedImage viewport = null;
    long startTime = 0L;
    long endTime = 0L;
    private String url = null;
    private boolean graphicsOutput = false;
    private boolean outputToFolder = false;
    private boolean outputEscaping = true;
    private int pDoC = 11;
    private String filename = "test";
    private int sizeTresholdWidth = 850;
    private int sizeTresholdHeight = 900;
    private PrintStream originalOut = null;
    private int numberOfIterations = 2;
    private File outputFolder = new File("testOutput");
    private boolean fragOutput = true;
    private int pixelDensity = 1;

    public VipsSelenium(String url, WebDriver driver) {
        this.url = url;
        this.driver = driver;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.exportPageToImage();
        this.getDomTree();
        if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
        if (driver != null) {
            VipsUtils.populateStyle(this.dom, driver, false);
        }
    }

    public VipsSelenium(WebDriver driver, Document dom, BufferedImage screenshot, int numberOfIterations, File folder, String filename, boolean fragOutput, boolean is_USE_CDP) {
        this.driver = driver;
        this.dom = dom;
        this.viewport = screenshot;
        this.fragOutput = fragOutput;
        this.numberOfIterations = numberOfIterations;
        this.sizeTresholdHeight = this.sizeTresholdWidth = (numberOfIterations - 5) * 50 + 100;
        if (folder != null) {
            this.outputFolder = folder;
        } else if (!this.outputFolder.exists()) {
            this.outputFolder.mkdirs();
        }
        this.filename = filename;
        if (driver != null) {
            VipsUtils.populateStyle(dom, driver, is_USE_CDP);
        }
    }

    public void enableGraphicsOutput(boolean enable) {
        this.graphicsOutput = enable;
    }

    public void enableOutputToFolder(boolean enable) {
        this.outputToFolder = enable;
    }

    public void enableOutputEscaping(boolean enable) {
        this.outputEscaping = enable;
    }

    public void setPredefinedDoC(int value) {
        if (value <= 0 || value > 11) {
            System.err.println("pDoC value must be between 1 and 11! Not " + value + "!");
            return;
        }
        this.pDoC = value;
    }

    private void getDomTree() {
        try {
            this.dom = DomUtils.asDocument(this.driver.getPageSource());
            boolean offline = false;
            VipsUtils.cleanDom(this.dom, offline);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BufferedImage getScreenShotAsBufferedImage(int scrollTime) {
        try {
            BufferedImage img = Shutterbug.shootPage((WebDriver)this.driver, (ScrollStrategy)ScrollStrategy.BOTH_DIRECTIONS, (int)scrollTime, (boolean)true).getImage();
            BufferedImage resizedImage = new BufferedImage(img.getWidth() / this.pixelDensity, img.getHeight() / this.pixelDensity, 1);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(img, 0, 0, img.getWidth() / this.pixelDensity, img.getHeight() / this.pixelDensity, Color.WHITE, null);
            g.dispose();
            return resizedImage;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void exportPageToImage() {
        try {
            this.viewport = this.getScreenShotAsBufferedImage(1000);
            String filename = System.getProperty("user.dir") + "/page.png";
            ImageIO.write((RenderedImage)this.viewport, "png", new File(filename));
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String generateFolderName() {
        Object outputFolder = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
        outputFolder = (String)outputFolder + sdf.format(cal.getTime());
        outputFolder = (String)outputFolder + "_";
        try {
            outputFolder = (String)outputFolder + new URL(this.url).getHost().replaceAll("\\.", "_").replaceAll("/", "_");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return outputFolder;
    }

    private List<VipsRectangle> performSegmentation() {
        this.startTime = System.nanoTime();
        int pageWidth = this.viewport.getWidth();
        int pageHeight = this.viewport.getHeight();
        VipsSeleniumParser vipsParser = new VipsSeleniumParser(this);
        VisualStructureConstructor constructor = new VisualStructureConstructor(this.pDoC, this.viewport, this.driver);
        constructor.setGraphicsOutput(this.graphicsOutput);
        for (int iterationNumber = 1; iterationNumber < this.numberOfIterations + 1; ++iterationNumber) {
            VipsSeparatorGraphicsDetector detector = new VipsSeparatorGraphicsDetector(this.viewport, this.driver);
            vipsParser.setSizeTresholdHeight(this.sizeTresholdHeight);
            vipsParser.setSizeTresholdWidth(this.sizeTresholdWidth);
            vipsParser.parse();
            Node vipsBlocks = vipsParser.getVipsBlocks();
            if (iterationNumber == 1) {
                if (this.graphicsOutput) {
                    detector.setVipsBlock(vipsBlocks);
                    detector.fillPool();
                    detector.saveToImage("blocks" + iterationNumber);
                    detector.setCleanUpSeparators(0);
                    detector.detectHorizontalSeparators();
                    detector.detectVerticalSeparators();
                    detector.exportHorizontalSeparatorsToImage();
                    detector.exportVerticalSeparatorsToImage();
                    detector.exportAllToImage();
                }
                constructor.setVipsBlocks(vipsBlocks);
                constructor.setPageSize(pageWidth, pageHeight);
            } else {
                vipsBlocks = vipsParser.getVipsBlocks();
                constructor.updateVipsBlocks(vipsBlocks);
                if (this.graphicsOutput) {
                    detector.setVisualBlocks(constructor.getVisualBlocks());
                    detector.fillPool();
                    detector.saveToImage("blocks" + iterationNumber);
                }
            }
            constructor.constructVisualStructure();
            if (iterationNumber <= this.numberOfIterations - 5) {
                this.sizeTresholdHeight -= 50;
                this.sizeTresholdWidth -= 50;
            }
            if (iterationNumber == this.numberOfIterations - 4) {
                this.sizeTresholdHeight = 100;
                this.sizeTresholdWidth = 100;
            }
            if (iterationNumber == this.numberOfIterations - 3) {
                this.sizeTresholdHeight = 80;
                this.sizeTresholdWidth = 80;
            }
            if (iterationNumber == this.numberOfIterations - 2) {
                this.sizeTresholdHeight = 50;
                this.sizeTresholdWidth = 50;
            }
            if (iterationNumber != this.numberOfIterations - 1) continue;
            this.sizeTresholdHeight = 1;
            this.sizeTresholdWidth = 1;
        }
        constructor.normalizeSeparatorsSoftMax();
        constructor.normalizeSeparatorsMinMax();
        File xmlTarget = new File(this.outputFolder, "vipsOutput_" + this.filename + ".xml");
        File screenshotFile = new File(this.outputFolder, "frag_" + this.filename + ".png");
        VipsOutput vipsOutput = new VipsOutput(this.pDoC, xmlTarget, this.fragOutput);
        vipsOutput.setEscapeOutput(this.outputEscaping);
        if (this.graphicsOutput) {
            vipsOutput.writeXML(constructor.getVisualStructure(), this.viewport, this.url, this.driver.getTitle());
        }
        List<VipsRectangle> rectangles = vipsOutput.exportVisualStructureToImage(constructor.getVisualStructure(), this.viewport, screenshotFile, this.fragOutput, this.driver);
        if (this.fragOutput) {
            File jsonTarget = new File(this.outputFolder, "vipsOutput_" + this.filename + ".json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter fileWriter = new FileWriter(jsonTarget);
                gson.toJson(rectangles, (Appendable)fileWriter);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (JsonIOException e) {
                LOG.error("Error exporting to json {}", (Object)jsonTarget.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Error exporting to json {}", (Object)jsonTarget.getAbsolutePath());
            }
        }
        this.endTime = System.nanoTime();
        long diff = this.endTime - this.startTime;
        LOG.info("Execution time of VIPS: " + diff + " ns; " + (double)diff / 1000000.0 + " ms; " + (double)diff / 1.0E9 + " sec");
        return rectangles;
    }

    private void restoreOut() {
        if (this.originalOut != null) {
            System.setOut(this.originalOut);
        }
    }

    private void redirectOut() {
        this.originalOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }));
    }

    public List<VipsRectangle> startSegmentation() {
        try {
            this.startTime = System.nanoTime();
            String outputFolder = "";
            String oldWorkingDirectory = "";
            Object newWorkingDirectory = "";
            if (this.outputToFolder) {
                outputFolder = this.generateFolderName();
                if (!new File(outputFolder).mkdir()) {
                    System.err.println("Something goes wrong during directory creation!");
                } else {
                    oldWorkingDirectory = System.getProperty("user.dir");
                    newWorkingDirectory = (String)newWorkingDirectory + oldWorkingDirectory + "/" + outputFolder + "/";
                    System.setProperty("user.dir", (String)newWorkingDirectory);
                }
            }
            List<VipsRectangle> rectangles = this.performSegmentation();
            if (this.outputToFolder) {
                System.setProperty("user.dir", oldWorkingDirectory);
            }
            return rectangles;
        }
        catch (Exception e) {
            LOG.error("Error during fragmentation. Returning null...");
            LOG.debug(e.getMessage());
            return null;
        }
    }

    public void setOutputFileName(String filenameStr) {
        if (!filenameStr.equals("")) {
            this.filename = filenameStr;
        } else {
            LOG.info("Invalid filename!");
        }
    }

    public BufferedImage getViewport() {
        if (this.viewport != null) {
            return this.viewport;
        }
        this.exportPageToImage();
        return this.viewport;
    }

    public void cleanup() {
        this.driver.close();
    }
}

