/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.VipsSelenium;
import com.crawljax.vips_selenium.VipsUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VipsSeleniumParser {
    private static final Logger LOG = LoggerFactory.getLogger(VipsSeleniumParser.class);
    int _cnt = 0;
    private VipsSelenium vips;
    private Node _vipsBlocks = null;
    private Node _currentVipsBlock = null;
    private Node _tempVipsBlock = null;
    private Document dom = null;
    private int _sizeTresholdWidth = 0;
    private int _sizeTresholdHeight = 0;
    private BufferedImage _viewport = null;
    private int _visualBlocksCount = 0;
    private int _pageWidth = 0;
    private int _pageHeight = 0;

    public VipsSeleniumParser(VipsSelenium vips) {
        this.vips = vips;
        this._viewport = vips.getViewport();
        this.dom = vips.dom;
        this._vipsBlocks = null;
        this._sizeTresholdHeight = 80;
        this._sizeTresholdWidth = 80;
        this._pageWidth = this._viewport.getWidth();
        this._pageHeight = this._viewport.getHeight();
    }

    public VipsSeleniumParser(VipsSelenium vips, int sizeTresholdWidth, int sizeTresholdHeight) {
        this.vips = vips;
        this._viewport = vips.getViewport();
        this.dom = vips.dom;
        this._vipsBlocks = null;
        this._sizeTresholdHeight = sizeTresholdHeight;
        this._sizeTresholdWidth = sizeTresholdWidth;
    }

    public void parse() {
        if (this._viewport != null && this.dom != null) {
            this._visualBlocksCount = 0;
            this._vipsBlocks = this.dom.getDocumentElement().getElementsByTagName("body").item(0);
            this.divideVipsBlockTree(this._vipsBlocks);
            this.getVisualBlocksCount(this._vipsBlocks);
        } else {
            System.err.print("Page's viewPort is not defined");
        }
    }

    private void getVisualBlocksCount(Node vipsBlock) {
        if (VipsUtils.isVisualBlock(vipsBlock)) {
            ++this._visualBlocksCount;
        }
        ArrayList<Node> vipsStructureChildren = VipsUtils.getChildren(vipsBlock);
        for (int i = 0; i < vipsStructureChildren.size(); ++i) {
            Node vipsBlockChild = vipsStructureChildren.get(i);
            if (VipsUtils.isTextBox(vipsBlockChild)) continue;
            this.getVisualBlocksCount(vipsBlockChild);
        }
    }

    private void findVisualBlocks(Node vipsBlock, List<Node> list) {
        if (VipsUtils.isVisualBlock(vipsBlock)) {
            list.add(vipsBlock);
        }
        ArrayList<Node> vipsStructureChildren = VipsUtils.getChildren(vipsBlock);
        for (int i = 0; i < vipsStructureChildren.size(); ++i) {
            Node vipsStructureChild = vipsStructureChildren.get(i);
            this.findVisualBlocks(vipsStructureChild, list);
        }
    }

    public List<Node> getVisualBlocks() {
        ArrayList<Node> list = new ArrayList<Node>();
        this.findVisualBlocks(this._vipsBlocks, list);
        return list;
    }

    private void divideVipsBlockTree(Node vipsBlock) {
        this._currentVipsBlock = vipsBlock;
        Node elementBox = vipsBlock;
        VipsUtils.setIsVisualBlock(vipsBlock, false);
        VipsUtils.setIsDividable(vipsBlock, true);
        LOG.debug(vipsBlock + " : " + vipsBlock.getTextContent());
        if (this.applyVipsRules(elementBox) && VipsUtils.isDividable(vipsBlock) && !VipsUtils.isVisualBlock(vipsBlock)) {
            VipsUtils.setAlreadyDivided(this._currentVipsBlock);
            ArrayList<Node> vipsStructureChildren = VipsUtils.getChildren(vipsBlock);
            for (int i = 0; i < vipsStructureChildren.size(); ++i) {
                Node vipsBlockChild = vipsStructureChildren.get(i);
                if (VipsUtils.isTextBox(vipsBlockChild)) continue;
                this.divideVipsBlockTree(vipsBlockChild);
            }
        } else {
            if (VipsUtils.isDividable(vipsBlock)) {
                VipsUtils.setIsVisualBlock(vipsBlock, true);
                VipsUtils.setDoC(vipsBlock, 11);
            }
            if (!this.verifyValidity(elementBox)) {
                VipsUtils.setIsVisualBlock(vipsBlock, false);
            }
        }
    }

    private int getAllTextLength(Node node) {
        ArrayList<Node> childrenTextNodes = new ArrayList<Node>();
        this.findTextChildrenNodes(node, childrenTextNodes);
        int textLength = 0;
        for (Node child : childrenTextNodes) {
            String childText = child.getTextContent();
            if (childText.equalsIgnoreCase("") || childText.equalsIgnoreCase(" ") || childText.equalsIgnoreCase("\n")) continue;
            textLength += childText.length();
        }
        return textLength;
    }

    private void getAllChildren(Node node, List<Node> children) {
        children.add(node);
        if (VipsUtils.isTextBox(node)) {
            return;
        }
        ArrayList<Node> childNodes = VipsUtils.getChildren(node);
        for (int i = 0; i < childNodes.size(); ++i) {
            Node child = childNodes.get(i);
            this.getAllChildren(child, children);
        }
    }

    private boolean verifyValidity(Node node) {
        if (this.isTextNode(node)) {
            return !node.getNodeValue().trim().isEmpty();
        }
        Rectangle rect = VipsUtils.getRectangle(node, this.vips.driver);
        if (rect.getX() < 0.0 || rect.getY() < 0.0) {
            return false;
        }
        if (rect.getX() + rect.getWidth() > (double)this._pageWidth) {
            return false;
        }
        if (rect.getY() + rect.getHeight() > (double)this._pageHeight) {
            return false;
        }
        if (rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return false;
        }
        if (!VipsUtils.isDisplayed(node, this.vips.driver)) {
            return false;
        }
        if (this.getAllTextLength(node) == 0) {
            if (node.getNodeName().equalsIgnoreCase("img")) {
                return true;
            }
            if (node.getNodeName().equalsIgnoreCase("input")) {
                return true;
            }
            ArrayList<Node> children = new ArrayList<Node>();
            this.getAllChildren(node, children);
            for (Node child : children) {
                String childNodeName = child.getNodeName();
                if (!this.isVisible(child)) continue;
                if (childNodeName.equalsIgnoreCase("img")) {
                    return true;
                }
                if (!childNodeName.equalsIgnoreCase("input")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isVisible(Node node) {
        if (this.isTextNode(node)) {
            return !node.getNodeValue().trim().isEmpty();
        }
        Rectangle rect = VipsUtils.getRectangle(node, this.vips.driver);
        if (rect.getX() < 0.0 || rect.getY() < 0.0) {
            return false;
        }
        if (rect.getX() + rect.getWidth() > (double)this._pageWidth) {
            return false;
        }
        if (rect.getY() + rect.getHeight() > (double)this._pageHeight) {
            return false;
        }
        if (rect.getWidth() <= 0.0 || rect.getHeight() <= 0.0) {
            return false;
        }
        return VipsUtils.isDisplayed(node, this.vips.driver);
    }

    private boolean isValidNode(Node node) {
        Rectangle rect = VipsUtils.getRectangle(node, this.vips.driver);
        return rect.getHeight() > 0.0 && rect.getWidth() > 0.0;
    }

    private boolean isTextNode(Node node) {
        return node.getNodeName().equalsIgnoreCase("#text");
    }

    public boolean isInlineNode(Node node) {
        String nodeName;
        switch (nodeName = node.getNodeName().toLowerCase()) {
            case "#text": 
            case "text": 
            case "abbr": 
            case "acronym": 
            case "bdo": 
            case "big": 
            case "button": 
            case "cite": 
            case "code": 
            case "dfn": 
            case "em": 
            case "i": 
            case "img": 
            case "input": 
            case "kbd": 
            case "label": 
            case "map": 
            case "object": 
            case "output": 
            case "q": 
            case "samp": 
            case "small": 
            case "span": 
            case "strong": 
            case "sub": 
            case "sup": 
            case "textarea": 
            case "time": 
            case "tt": 
            case "var": 
            case "b": {
                return true;
            }
            case "select": 
            case "option": {
                return true;
            }
        }
        return false;
    }

    private boolean isVirtualTextNode1(Node node) {
        if (!this.isInlineNode(node)) {
            return false;
        }
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            if (this.isTextNode(childNode)) continue;
            return false;
        }
        return true;
    }

    private boolean isVirtualTextNode2(Node node) {
        if (!this.isInlineNode(node)) {
            return false;
        }
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            if (this.isTextNode(childNode) || this.isVirtualTextNode1(childNode)) continue;
            return false;
        }
        return true;
    }

    private boolean isVirtualTextNode(Node node) {
        if (this.isVirtualTextNode1(node)) {
            return true;
        }
        return this.isVirtualTextNode2(node);
    }

    private void checkValidChildrenNodes(Node node) {
        if (VipsUtils.isTextBox(node)) {
            if (!node.getTextContent().trim().isEmpty()) {
                ++this._cnt;
            }
            return;
        }
        if (this.isValidNode(node)) {
            ++this._cnt;
        }
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            this.checkValidChildrenNodes(childNode);
        }
    }

    private boolean hasValidChildrenNodes(Node node) {
        if (node.getNodeName().equalsIgnoreCase("img") || node.getNodeName().equalsIgnoreCase("input")) {
            Rectangle rect = VipsUtils.getRectangle(node, this.vips.driver);
            if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0) {
                VipsUtils.setIsVisualBlock(this._currentVipsBlock, true);
                VipsUtils.setDoC(this._currentVipsBlock, 8);
                return true;
            }
            return false;
        }
        if (VipsUtils.getChildren(node).size() == 0) {
            return false;
        }
        this._cnt = 0;
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            this.checkValidChildrenNodes(childNode);
        }
        return this._cnt > 0;
    }

    private int numberOfValidChildNodes(Node node) {
        this._cnt = 0;
        if (VipsUtils.getChildren(node).size() == 0) {
            return this._cnt;
        }
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            this.checkValidChildrenNodes(childNode);
        }
        return this._cnt;
    }

    private boolean applyVipsRules(Node node) {
        boolean retVal = false;
        retVal = this.isInlineNode(node) ? this.applyInlineTextNodeVipsRules(node) : (node.getNodeName().equalsIgnoreCase("table") ? this.applyTableNodeVipsRules(node) : (node.getNodeName().equalsIgnoreCase("tr") ? this.applyTrNodeVipsRules(node) : (node.getNodeName().equalsIgnoreCase("td") ? this.applyTdNodeVipsRules(node) : (node.getNodeName().equalsIgnoreCase("p") ? this.applyPNodeVipsRules(node) : this.applyOtherNodeVipsRules(node)))));
        return retVal;
    }

    private boolean applyOtherNodeVipsRules(Node node) {
        LOG.debug("OtherNode");
        if (this.ruleOne(node)) {
            LOG.debug("Rule1 Applied");
            return true;
        }
        if (this.ruleTwo(node)) {
            LOG.debug("Rule 2 applied");
            return true;
        }
        if (this.ruleThree(node)) {
            LOG.debug("Rule 3 applied");
            return true;
        }
        if (this.ruleFour(node)) {
            LOG.debug("Rule 4 applied");
            return true;
        }
        if (this.ruleSix(node)) {
            LOG.debug("Rule 6 applied");
            return true;
        }
        if (this.ruleEight(node)) {
            LOG.debug("Rule 8 applied");
            return true;
        }
        if (this.ruleNine(node)) {
            LOG.debug("Rule 9 applied");
            return true;
        }
        if (this.ruleEleven(node)) {
            LOG.debug("Rule 11 applied");
            return true;
        }
        return false;
    }

    private boolean applyPNodeVipsRules(Node node) {
        LOG.debug("P rules");
        if (this.ruleOne(node)) {
            LOG.debug("Rule1 Applied");
            return true;
        }
        if (this.ruleTwo(node)) {
            LOG.debug("Rule 2 applied");
            return true;
        }
        if (this.ruleThree(node)) {
            LOG.debug("Rule 3 applied");
            return true;
        }
        if (this.ruleFour(node)) {
            LOG.debug("Rule 4 applied");
            return true;
        }
        if (this.ruleFive(node)) {
            LOG.debug("Rule 5 applied");
            return true;
        }
        if (this.ruleSix(node)) {
            LOG.debug("Rule 6 applied");
            return true;
        }
        if (this.ruleSeven(node)) {
            LOG.debug("Rule 7 applied");
            return true;
        }
        if (this.ruleEight(node)) {
            LOG.debug("Rule 8 applied");
            return true;
        }
        if (this.ruleNine(node)) {
            LOG.debug("Rule 9 applied");
            return true;
        }
        if (this.ruleTen(node)) {
            LOG.debug("Rule 10 applied");
            return true;
        }
        if (this.ruleEleven(node)) {
            LOG.debug("Rule 11 applied");
            return true;
        }
        if (this.ruleTwelve(node)) {
            LOG.debug("Rule 12 applied");
            return true;
        }
        return false;
    }

    private boolean applyTdNodeVipsRules(Node node) {
        LOG.debug("TD Rules");
        if (this.ruleOne(node)) {
            LOG.debug("Rule1 Applied");
            return true;
        }
        if (this.ruleTwo(node)) {
            LOG.debug("Rule2 Applied");
            return true;
        }
        if (this.ruleThree(node)) {
            LOG.debug("Rule3 Applied");
            return true;
        }
        if (this.ruleFour(node)) {
            LOG.debug("Rule4 Applied");
            return true;
        }
        if (this.ruleEight(node)) {
            LOG.debug("Rule8 Applied");
            return true;
        }
        if (this.ruleNine(node)) {
            LOG.debug("Rule9 Applied");
            return true;
        }
        if (this.ruleTen(node)) {
            LOG.debug("Rule10 Applied");
            return true;
        }
        if (this.ruleTwelve(node)) {
            LOG.debug("Rule12 Applied");
            return true;
        }
        return false;
    }

    private boolean applyTrNodeVipsRules(Node node) {
        LOG.debug("TR Rules");
        if (this.ruleOne(node)) {
            LOG.debug("Rule1 Applied");
            return true;
        }
        if (this.ruleTwo(node)) {
            LOG.debug("Rule2 Applied");
            return true;
        }
        if (this.ruleThree(node)) {
            LOG.debug("Rule3 Applied");
            return true;
        }
        if (this.ruleSeven(node)) {
            LOG.debug("Rule7 Applied");
            return true;
        }
        if (this.ruleNine(node)) {
            LOG.debug("Rule9 Applied");
            return true;
        }
        if (this.ruleTwelve(node)) {
            LOG.debug("Rule12 Applied");
            return true;
        }
        return false;
    }

    private boolean applyTableNodeVipsRules(Node node) {
        LOG.debug("Table rules");
        if (this.ruleOne(node)) {
            LOG.debug("Rule1 Applied");
            return true;
        }
        if (this.ruleTwo(node)) {
            LOG.debug("Rule2 Applied");
            return true;
        }
        if (this.ruleThree(node)) {
            LOG.debug("Rule3 Applied");
            return true;
        }
        if (this.ruleSeven(node)) {
            LOG.debug("Rule7 Applied");
            return true;
        }
        if (this.ruleNine(node)) {
            LOG.debug("Rule9 Applied");
            return true;
        }
        if (this.ruleTwelve(node)) {
            LOG.debug("Rule12 Applied");
            return true;
        }
        return false;
    }

    private boolean applyInlineTextNodeVipsRules(Node node) {
        LOG.debug("inline node");
        if (this.ruleOne(node)) {
            LOG.debug("Rule1 Applied");
            return true;
        }
        if (this.ruleTwo(node)) {
            LOG.debug("Rule 2 applied");
            return true;
        }
        if (this.ruleThree(node)) {
            LOG.debug("Rule 3 applied");
            return true;
        }
        if (this.ruleFour(node)) {
            LOG.debug("Rule 4 applied");
            return true;
        }
        if (this.ruleFive(node)) {
            LOG.debug("Rule 5 applied");
            return true;
        }
        if (this.ruleSix(node)) {
            LOG.debug("Rule 6 applied");
            return true;
        }
        if (this.ruleEight(node)) {
            LOG.debug("Rule 8 applied");
            return true;
        }
        if (this.ruleNine(node)) {
            LOG.debug("Rule 9 applied");
            return true;
        }
        if (this.ruleEleven(node)) {
            LOG.debug("Rule 11 applied");
            return true;
        }
        return false;
    }

    private boolean ruleOne(Node node) {
        if (!this.isTextNode(node) && !this.hasValidChildrenNodes(node)) {
            VipsUtils.setIsDividable(this._currentVipsBlock, false);
            return true;
        }
        return false;
    }

    private boolean ruleTwo(Node node) {
        if (this.numberOfValidChildNodes(node) == 1) {
            ArrayList<Node> children = VipsUtils.getChildren(node);
            for (int i = 0; i < children.size(); ++i) {
                Node child = children.get(0);
                if (!this.isValidNode(child) || this.isTextNode(child)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleThree(Node node) {
        if (!node.getNodeName().equalsIgnoreCase("body")) {
            return false;
        }
        boolean result = true;
        int cnt = 0;
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (Node vipsBlock : children) {
            if (!vipsBlock.getNodeName().equalsIgnoreCase(node.getNodeName())) continue;
            result = true;
            this.isOnlyOneDomSubTree(node, vipsBlock, result);
            if (!result) continue;
            ++cnt;
        }
        return cnt == 1;
    }

    private void isOnlyOneDomSubTree(Node pattern, Node node, boolean result) {
        if (!pattern.getNodeName().equalsIgnoreCase(node.getNodeName())) {
            result = false;
        }
        if (VipsUtils.getChildren(pattern).size() != VipsUtils.getChildren(node).size()) {
            result = false;
        }
        if (!result) {
            return;
        }
        for (int i = 0; i < VipsUtils.getChildren(pattern).size(); ++i) {
            this.isOnlyOneDomSubTree(VipsUtils.getChildren(pattern).get(i), VipsUtils.getChildren(node).get(i), result);
        }
    }

    private boolean ruleFour(Node node) {
        ArrayList<Node> children = VipsUtils.getChildren(node);
        if (children.size() == 0) {
            return false;
        }
        for (int i = 0; i < children.size(); ++i) {
            Node child = children.get(i);
            if (this.isTextNode(child) || this.isVirtualTextNode(child)) continue;
            return false;
        }
        VipsUtils.setIsVisualBlock(this._currentVipsBlock, true);
        VipsUtils.setIsDividable(this._currentVipsBlock, false);
        if (children.size() == 1) {
            if (node.getFirstChild().getNodeName().equalsIgnoreCase("em")) {
                VipsUtils.setDoC(this._currentVipsBlock, 11);
            } else {
                VipsUtils.setDoC(this._currentVipsBlock, 10);
            }
            return true;
        }
        String fontWeight = "";
        boolean fontSize = false;
        for (int i = 0; i < children.size(); ++i) {
            Node node2 = children.get(i);
        }
        return true;
    }

    private boolean ruleFive(Node node) {
        if (VipsUtils.getChildren(node).size() == 0) {
            return false;
        }
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            if (this.isInlineNode(childNode)) continue;
            return true;
        }
        return false;
    }

    private boolean ruleSix(Node node) {
        if (VipsUtils.getChildren(node).size() == 0) {
            return false;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        this.getAllChildren(node, children);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = (Node)children.get(i);
            if (!childNode.getNodeName().equalsIgnoreCase("hr")) continue;
            return true;
        }
        return false;
    }

    private boolean ruleSeven(Node node) {
        if (VipsUtils.getChildren(node).size() == 0) {
            return false;
        }
        if (this.isTextNode(node)) {
            return false;
        }
        String nodeBgColor = VipsUtils.getBackgroundColor(this._currentVipsBlock, this.vips.driver);
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (int i = 0; i < children.size(); ++i) {
            Node childNode = children.get(i);
            String bgColor = VipsUtils.getBackgroundColor(childNode, this.vips.driver);
            if (bgColor.equalsIgnoreCase(nodeBgColor)) continue;
            VipsUtils.setIsDividable(childNode, false);
            VipsUtils.setIsVisualBlock(childNode, true);
            VipsUtils.setDoC(childNode, 7);
            return true;
        }
        return false;
    }

    private void findTextChildrenNodes(Node node, List<Node> results) {
        if (VipsUtils.isTextBox(node)) {
            results.add(node);
            return;
        }
        ArrayList<Node> childNodes = VipsUtils.getChildren(node);
        for (int i = 0; i < childNodes.size(); ++i) {
            Node childNode = childNodes.get(i);
            this.findTextChildrenNodes(childNode, results);
        }
    }

    private boolean ruleEight(Node node) {
        if (VipsUtils.getChildren(node).size() == 0) {
            return false;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        this.findTextChildrenNodes(node, children);
        int cnt = children.size();
        if (cnt == 0) {
            return false;
        }
        Rectangle rect = VipsUtils.getRectangle(node, this.vips.driver);
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            children.clear();
            this.getAllChildren(node, children);
            for (Node child : children) {
                Rectangle childRect = VipsUtils.getRectangle(child, this.vips.driver);
                if (childRect.getWidth() == 0.0 || childRect.getHeight() == 0.0) continue;
                return true;
            }
        }
        if (rect.getWidth() * rect.getHeight() > (double)(this._sizeTresholdHeight * this._sizeTresholdWidth)) {
            return false;
        }
        if (node.getNodeName().equalsIgnoreCase("ul")) {
            return true;
        }
        VipsUtils.setIsVisualBlock(this._currentVipsBlock, true);
        VipsUtils.setIsDividable(this._currentVipsBlock, false);
        if (node.getNodeName().equalsIgnoreCase("Xdiv")) {
            VipsUtils.setDoC(this._currentVipsBlock, 7);
        } else if (node.getNodeName().equalsIgnoreCase("code")) {
            VipsUtils.setDoC(this._currentVipsBlock, 7);
        } else if (node.getNodeName().equalsIgnoreCase("div")) {
            VipsUtils.setDoC(this._currentVipsBlock, 5);
        } else {
            VipsUtils.setDoC(this._currentVipsBlock, 8);
        }
        return true;
    }

    private boolean ruleNine(Node node) {
        if (VipsUtils.getChildren(node).size() == 0) {
            return false;
        }
        int maxSize = 0;
        ArrayList<Node> childNodes = VipsUtils.getChildren(node);
        for (int i = 0; i < childNodes.size(); ++i) {
            Node childNode = childNodes.get(i);
            if (childNode.getNodeName().equalsIgnoreCase("#text")) continue;
            Rectangle childRect = VipsUtils.getRectangle(childNode, this.vips.driver);
            int childSize = childRect.width * childRect.height;
            if (maxSize >= childSize) continue;
            maxSize = childSize;
        }
        if (maxSize > this._sizeTresholdWidth * this._sizeTresholdHeight) {
            return true;
        }
        VipsUtils.setIsVisualBlock(this._currentVipsBlock, true);
        VipsUtils.setIsDividable(this._currentVipsBlock, false);
        if (node.getNodeName().equalsIgnoreCase("Xdiv")) {
            VipsUtils.setDoC(this._currentVipsBlock, 7);
        }
        if (node.getNodeName().equalsIgnoreCase("a")) {
            VipsUtils.setDoC(this._currentVipsBlock, 11);
        } else {
            VipsUtils.setDoC(this._currentVipsBlock, 8);
        }
        return true;
    }

    private boolean ruleTen(Node node) {
        this._tempVipsBlock = null;
        this.findPreviousSiblingNodeVipsBlock(node.getPreviousSibling(), this._vipsBlocks);
        if (this._tempVipsBlock == null) {
            return false;
        }
        return VipsUtils.isAlreadyDivided(this._tempVipsBlock);
    }

    private boolean ruleEleven(Node node) {
        return !this.isInlineNode(node);
    }

    private boolean ruleTwelve(Node node) {
        VipsUtils.setIsDividable(this._currentVipsBlock, false);
        VipsUtils.setIsVisualBlock(this._currentVipsBlock, true);
        if (node.getNodeName().equalsIgnoreCase("Xdiv")) {
            VipsUtils.setDoC(this._currentVipsBlock, 7);
        } else if (node.getNodeName().equalsIgnoreCase("li")) {
            VipsUtils.setDoC(this._currentVipsBlock, 8);
        } else if (node.getNodeName().equalsIgnoreCase("span")) {
            VipsUtils.setDoC(this._currentVipsBlock, 8);
        } else if (node.getNodeName().equalsIgnoreCase("sup")) {
            VipsUtils.setDoC(this._currentVipsBlock, 8);
        } else if (node.getNodeName().equalsIgnoreCase("img")) {
            VipsUtils.setDoC(this._currentVipsBlock, 8);
        } else {
            VipsUtils.setDoC(this._currentVipsBlock, 333);
        }
        return true;
    }

    public int getSizeTresholdWidth() {
        return this._sizeTresholdWidth;
    }

    public void setSizeTresholdWidth(int sizeTresholdWidth) {
        this._sizeTresholdWidth = sizeTresholdWidth;
    }

    public int getSizeTresholdHeight() {
        return this._sizeTresholdHeight;
    }

    public void setSizeTresholdHeight(int sizeTresholdHeight) {
        this._sizeTresholdHeight = sizeTresholdHeight;
    }

    public Node getVipsBlocks() {
        return this._vipsBlocks;
    }

    private void findPreviousSiblingNodeVipsBlock(Node node, Node vipsBlock) {
        Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.vips.driver);
        Rectangle nodeRect = VipsUtils.getRectangle(node, this.vips.driver);
        if (rect.x == nodeRect.x && rect.y == nodeRect.y && rect.width == nodeRect.width && rect.height == nodeRect.height) {
            this._tempVipsBlock = vipsBlock;
            return;
        }
    }
}

