/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.Separator;
import com.crawljax.vips_selenium.VipsSeparatorDetector;
import com.crawljax.vips_selenium.VipsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.openqa.selenium.WebDriver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VipsSeparatorGraphicsDetector
extends JPanel
implements VipsSeparatorDetector {
    private static final long serialVersionUID = 5825509847374498L;
    Graphics2D _pool = null;
    BufferedImage originalImage = null;
    BufferedImage _image = null;
    Node _vipsBlocks = null;
    List<Node> _visualBlocks = null;
    private List<Separator> _horizontalSeparators = null;
    private List<Separator> _verticalSeparators = null;
    private WebDriver driver = null;
    private int _cleanSeparatorsTreshold = 0;

    public VipsSeparatorGraphicsDetector(BufferedImage screenshot, WebDriver driver) {
        this.originalImage = screenshot;
        this.driver = driver;
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
        this._visualBlocks = new ArrayList<Node>();
        this.createPool();
    }

    public void addVisualBlock(Node vipsBlock) {
        this._pool.setColor(Color.BLACK);
        Rectangle rect1 = VipsUtils.getRectangle(vipsBlock, this.driver);
        Rectangle rect = new Rectangle(rect1.x, rect1.y, rect1.width, rect1.height);
        this._pool.setStroke(new BasicStroke(5.0f));
        this._pool.draw(rect);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this._image, 0, 0, null);
    }

    private void fillPoolWithBlocks(List<Node> visualBlocks) {
        for (Node block : visualBlocks) {
            this.addVisualBlock(block);
        }
    }

    private void fillPoolWithBlocks(Node vipsBlock) {
        if (VipsUtils.isVisualBlock(vipsBlock)) {
            this.addVisualBlock(vipsBlock);
            this._visualBlocks.add(vipsBlock);
        }
        NodeList children = vipsBlock.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node vipsBlockChild = children.item(i);
            this.fillPoolWithBlocks(vipsBlockChild);
        }
    }

    @Override
    public void fillPool() {
        this.createPool();
        if (this._vipsBlocks != null) {
            this.fillPoolWithBlocks(this._vipsBlocks);
        } else {
            this.fillPoolWithBlocks(this._visualBlocks);
        }
    }

    private void createPool() {
        this._image = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), this.originalImage.getType());
        this._pool = this._image.createGraphics();
        this._pool.drawImage((Image)this.originalImage, 0, 0, null);
        this._pool.setColor(Color.black);
    }

    @Override
    public Node getVipsBlock() {
        return this._vipsBlocks;
    }

    @Override
    public void setVipsBlock(Node vipsBlock) {
        this._vipsBlocks = vipsBlock;
        this._visualBlocks.clear();
        this.fillPoolWithBlocks(vipsBlock);
        this.createPool();
    }

    @Override
    public List<Node> getVisualBlocks() {
        return this._visualBlocks;
    }

    @Override
    public void setVisualBlocks(List<Node> visualBlocks) {
        this._visualBlocks.clear();
        this._visualBlocks.addAll(visualBlocks);
    }

    private void findVerticalSeparators() {
        block0: for (Node vipsBlock : this._visualBlocks) {
            this.addVisualBlock(vipsBlock);
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int blockStart = rect.x;
            int blockEnd = blockStart + rect.width;
            for (Separator separator : this._verticalSeparators) {
                int nextSeparatorIndex;
                if (blockStart >= separator.endPoint) continue;
                if (blockStart < separator.startPoint && blockEnd >= separator.endPoint) {
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._verticalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart >= other.startPoint || blockEnd <= other.endPoint) continue;
                        this._verticalSeparators.remove(other);
                    }
                    for (Separator other : this._verticalSeparators) {
                        if (blockEnd <= other.startPoint || blockEnd >= other.endPoint) continue;
                        other.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    continue block0;
                }
                if (blockEnd < separator.startPoint) continue block0;
                if (blockStart < separator.startPoint && blockEnd >= separator.startPoint) {
                    separator.startPoint = blockEnd + 1;
                    continue block0;
                }
                if (blockStart >= separator.startPoint && blockEnd <= separator.endPoint) {
                    if (blockStart == separator.startPoint) {
                        separator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    if (blockEnd == separator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        continue block0;
                    }
                    this._verticalSeparators.add(this._verticalSeparators.indexOf(separator) + 1, new Separator(blockEnd + 1, separator.endPoint));
                    separator.endPoint = blockStart - 1;
                    continue block0;
                }
                if (blockStart > separator.startPoint && blockStart < separator.endPoint && (nextSeparatorIndex = this._verticalSeparators.indexOf(separator)) + 1 < this._verticalSeparators.size()) {
                    Separator nextSeparator = this._verticalSeparators.get(this._verticalSeparators.indexOf(separator) + 1);
                    if (blockEnd > nextSeparator.startPoint && blockEnd < nextSeparator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        nextSeparator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._verticalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart < other.startPoint && other.endPoint < blockEnd) {
                            this._verticalSeparators.remove(other);
                            continue;
                        }
                        if (blockEnd > other.startPoint && blockEnd < other.endPoint) {
                            other.startPoint = blockEnd + 1;
                            continue block0;
                        }
                        if (blockStart <= other.startPoint || blockStart >= other.endPoint) continue;
                        other.endPoint = blockStart - 1;
                    }
                    continue block0;
                }
                separator.endPoint = blockStart - 1;
                continue block0;
            }
        }
    }

    private void findHorizontalSeparators() {
        block0: for (Node vipsBlock : this._visualBlocks) {
            this.addVisualBlock(vipsBlock);
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int blockStart = rect.y;
            int blockEnd = blockStart + rect.height;
            for (Separator separator : this._horizontalSeparators) {
                int nextSeparatorIndex;
                if (blockStart >= separator.endPoint) continue;
                if (blockStart < separator.startPoint && blockEnd >= separator.endPoint) {
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._horizontalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart >= other.startPoint || blockEnd <= other.endPoint) continue;
                        this._horizontalSeparators.remove(other);
                    }
                    for (Separator other : this._horizontalSeparators) {
                        if (blockEnd <= other.startPoint || blockEnd >= other.endPoint) continue;
                        other.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    continue block0;
                }
                if (blockEnd < separator.startPoint) continue block0;
                if (blockStart <= separator.startPoint && blockEnd >= separator.startPoint) {
                    separator.startPoint = blockEnd + 1;
                    continue block0;
                }
                if (blockStart >= separator.startPoint && blockEnd < separator.endPoint) {
                    if (blockStart == separator.startPoint) {
                        separator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    if (blockEnd == separator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        continue block0;
                    }
                    this._horizontalSeparators.add(this._horizontalSeparators.indexOf(separator) + 1, new Separator(blockEnd + 1, separator.endPoint));
                    separator.endPoint = blockStart - 1;
                    continue block0;
                }
                if (blockStart > separator.startPoint && blockStart < separator.endPoint && (nextSeparatorIndex = this._horizontalSeparators.indexOf(separator)) + 1 < this._horizontalSeparators.size()) {
                    Separator nextSeparator = this._horizontalSeparators.get(this._horizontalSeparators.indexOf(separator) + 1);
                    if (blockEnd > nextSeparator.startPoint && blockEnd < nextSeparator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        nextSeparator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._horizontalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart < other.startPoint && other.endPoint < blockEnd) {
                            this._horizontalSeparators.remove(other);
                            continue;
                        }
                        if (blockEnd > other.startPoint && blockEnd < other.endPoint) {
                            other.startPoint = blockEnd + 1;
                            continue block0;
                        }
                        if (blockStart <= other.startPoint || blockStart >= other.endPoint) continue;
                        other.endPoint = blockStart - 1;
                    }
                    continue block0;
                }
                separator.endPoint = blockStart - 1;
                continue block0;
            }
        }
    }

    @Override
    public void detectHorizontalSeparators() {
        if (this._visualBlocks.size() == 0) {
            System.err.println("I don't have any visual blocks!");
            return;
        }
        this.createPool();
        this._horizontalSeparators.clear();
        this._horizontalSeparators.add(new Separator(0, this._image.getHeight()));
        this.findHorizontalSeparators();
        ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
        tempSeparators.addAll(this._horizontalSeparators);
        for (Separator separator : tempSeparators) {
            if (separator.startPoint == 0) {
                this._horizontalSeparators.remove(separator);
            }
            if (separator.endPoint != this._image.getHeight()) continue;
            this._horizontalSeparators.remove(separator);
        }
        if (this._cleanSeparatorsTreshold != 0) {
            this.cleanUpSeparators(this._horizontalSeparators);
        }
        this.computeHorizontalWeights();
        this.sortSeparatorsByWeight(this._horizontalSeparators);
    }

    @Override
    public void detectVerticalSeparators() {
        if (this._visualBlocks.size() == 0) {
            System.err.println("I don't have any visual blocks!");
            return;
        }
        this.createPool();
        this._verticalSeparators.clear();
        this._verticalSeparators.add(new Separator(0, this._image.getWidth()));
        this.findVerticalSeparators();
        ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
        tempSeparators.addAll(this._verticalSeparators);
        for (Separator separator : tempSeparators) {
            if (separator.startPoint == 0) {
                this._verticalSeparators.remove(separator);
            }
            if (separator.endPoint != this._image.getWidth()) continue;
            this._verticalSeparators.remove(separator);
        }
        if (this._cleanSeparatorsTreshold != 0) {
            this.cleanUpSeparators(this._verticalSeparators);
        }
        this.computeVerticalWeights();
        this.sortSeparatorsByWeight(this._verticalSeparators);
    }

    private void cleanUpSeparators(List<Separator> separators) {
        ArrayList<Separator> tempList = new ArrayList<Separator>();
        tempList.addAll(separators);
        for (Separator separator : tempList) {
            int width = separator.endPoint - separator.startPoint + 1;
            if (width >= this._cleanSeparatorsTreshold) continue;
            separators.remove(separator);
        }
    }

    private void sortSeparatorsByWeight(List<Separator> separators) {
        Collections.sort(separators);
    }

    private void computeVerticalWeights() {
        for (Separator separator : this._verticalSeparators) {
            this.ruleOne(separator);
            this.ruleTwo(separator, false);
            this.ruleThree(separator, false);
        }
    }

    private void computeHorizontalWeights() {
        for (Separator separator : this._horizontalSeparators) {
            this.ruleOne(separator);
            this.ruleTwo(separator, true);
            this.ruleThree(separator, true);
            this.ruleFour(separator);
            this.ruleFive(separator);
        }
    }

    private void ruleOne(Separator separator) {
        int width = separator.endPoint - separator.startPoint + 1;
        if (width > 55) {
            separator.weight += 12;
        }
        if (width > 45 && width <= 55) {
            separator.weight += 10;
        }
        if (width > 35 && width <= 45) {
            separator.weight += 8;
        }
        separator.weight = width > 25 && width <= 35 ? (separator.weight += 6) : (width > 15 && width <= 25 ? (separator.weight += 4) : (width > 8 && width <= 15 ? (separator.weight += 2) : ++separator.weight));
    }

    private void ruleTwo(Separator separator, boolean horizontal) {
        ArrayList<Node> overlappedElements = new ArrayList<Node>();
        if (horizontal) {
            this.findHorizontalOverlappedElements(separator, overlappedElements);
        } else {
            this.findVerticalOverlappedElements(separator, overlappedElements);
        }
        if (overlappedElements.size() == 0) {
            return;
        }
        for (Node vipsBlock : overlappedElements) {
            if (!vipsBlock.getNodeName().equalsIgnoreCase("hr")) continue;
            separator.weight += 2;
            break;
        }
    }

    private void findHorizontalOverlappedElements(Separator separator, List<Node> result) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int topEdge = rect.y;
            int bottomEdge = topEdge + rect.height;
            if (topEdge > separator.startPoint && topEdge < separator.endPoint && bottomEdge > separator.endPoint) {
                result.add(vipsBlock);
            }
            if (topEdge < separator.startPoint && bottomEdge > separator.startPoint && bottomEdge < separator.endPoint) {
                result.add(vipsBlock);
            }
            if (topEdge < separator.startPoint || bottomEdge > separator.endPoint) continue;
            result.add(vipsBlock);
        }
    }

    private void findVerticalOverlappedElements(Separator separator, List<Node> result) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int leftEdge = rect.x;
            int rightEdge = leftEdge + rect.width;
            if (leftEdge > separator.startPoint && leftEdge < separator.endPoint && rightEdge > separator.endPoint) {
                result.add(vipsBlock);
            }
            if (leftEdge < separator.startPoint && rightEdge > separator.startPoint && rightEdge < separator.endPoint) {
                result.add(vipsBlock);
            }
            if (leftEdge < separator.startPoint || rightEdge > separator.endPoint) continue;
            result.add(vipsBlock);
        }
    }

    private void ruleThree(Separator separator, boolean horizontal) {
        ArrayList<Node> topAdjacentElements = new ArrayList<Node>();
        ArrayList<Node> bottomAdjacentElements = new ArrayList<Node>();
        if (horizontal) {
            this.findHorizontalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        } else {
            this.findVerticalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        }
        if (topAdjacentElements.size() < 1 || bottomAdjacentElements.size() < 1) {
            return;
        }
        boolean weightIncreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                if (VipsUtils.getBgColor(top, this.driver).equalsIgnoreCase(VipsUtils.getBgColor(bottom, this.driver))) continue;
                separator.weight += 2;
                weightIncreased = true;
                break;
            }
            if (!weightIncreased) continue;
            break;
        }
    }

    private void findHorizontalAdjacentBlocks(Separator separator, List<Node> resultTop, List<Node> resultBottom) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int topEdge = rect.y;
            int bottomEdge = topEdge + rect.height;
            if (topEdge == separator.endPoint + 1 && bottomEdge > separator.endPoint + 1) {
                resultBottom.add(vipsBlock);
            }
            if (bottomEdge != separator.startPoint - 1 || topEdge >= separator.startPoint - 1) continue;
            resultTop.add(0, vipsBlock);
        }
    }

    private void findVerticalAdjacentBlocks(Separator separator, List<Node> resultLeft, List<Node> resultRight) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int leftEdge = rect.x + 1;
            int rightEdge = leftEdge + rect.width;
            if (leftEdge == separator.endPoint + 1 && rightEdge > separator.endPoint + 1) {
                resultRight.add(vipsBlock);
            }
            if (rightEdge != separator.startPoint - 1 || leftEdge >= separator.startPoint - 1) continue;
            resultLeft.add(0, vipsBlock);
        }
    }

    private void ruleFour(Separator separator) {
        ArrayList<Node> topAdjacentElements = new ArrayList<Node>();
        ArrayList<Node> bottomAdjacentElements = new ArrayList<Node>();
        this.findHorizontalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        if (topAdjacentElements.size() < 1 || bottomAdjacentElements.size() < 1) {
            return;
        }
        boolean weightIncreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                int diff = Math.abs(VipsUtils.getFontSize(top, this.driver) - VipsUtils.getFontSize(bottom, this.driver));
                if (diff != 0) {
                    separator.weight += 2;
                    weightIncreased = true;
                    break;
                }
                if (VipsUtils.getFontWeight(top, this.driver).equalsIgnoreCase(VipsUtils.getFontWeight(bottom, this.driver))) continue;
                separator.weight += 2;
            }
            if (!weightIncreased) continue;
            break;
        }
        weightIncreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                if (VipsUtils.getFontSize(top, this.driver) >= VipsUtils.getFontSize(bottom, this.driver)) continue;
                separator.weight += 2;
                weightIncreased = true;
                break;
            }
            if (!weightIncreased) continue;
            break;
        }
    }

    private void ruleFive(Separator separator) {
        ArrayList<Node> topAdjacentElements = new ArrayList<Node>();
        ArrayList<Node> bottomAdjacentElements = new ArrayList<Node>();
        this.findHorizontalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        if (topAdjacentElements.size() < 1 || bottomAdjacentElements.size() < 1) {
            return;
        }
        boolean weightDecreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                if (!VipsUtils.isTextBox(top) || !VipsUtils.isTextBox(bottom)) continue;
                separator.weight -= 2;
                weightDecreased = true;
                break;
            }
            if (!weightDecreased) continue;
            break;
        }
    }

    public void exportAllToImage() {
        this.createPool();
        this.fillPool();
        this.drawVerticalSeparators();
        this.drawHorizontalSeparators();
        this.saveToImage("all");
    }

    public void exportAllToImage(int suffix) {
        this.createPool();
        this.drawVerticalSeparators();
        this.drawHorizontalSeparators();
        this.fillPoolWithBlocks(this._visualBlocks);
        this.saveToImage("iteration" + suffix);
    }

    private void drawVerticalSeparators() {
        Color c = new Color(0.5f, 0.0f, 0.0f, 0.5f);
        this._pool.setColor(c);
        for (Separator separator : this._verticalSeparators) {
            Rectangle rect = separator.leftUp != null ? new Rectangle(separator.leftUp, new Dimension((int)(separator.rightDown.getX() - separator.leftUp.getX()), (int)(separator.rightDown.getY() - separator.leftUp.getY()))) : new Rectangle(separator.startPoint, 0, separator.endPoint - separator.startPoint, this._image.getHeight());
            this._pool.draw(rect);
            this._pool.fill(rect);
        }
    }

    public void exportVerticalSeparatorsToImage() {
        this.createPool();
        this.drawVerticalSeparators();
        this.saveToImage("verticalSeparators");
    }

    public void exportVerticalSeparatorsToImage(int suffix) {
        this.createPool();
        this.drawVerticalSeparators();
        this.saveToImage("verticalSeparators" + suffix);
    }

    private void drawHorizontalSeparators() {
        Color c = new Color(0.0f, 0.0f, 0.5f, 0.5f);
        this._pool.setColor(Color.gray);
        for (Separator separator : this._horizontalSeparators) {
            Rectangle rect = separator.leftUp != null ? new Rectangle(separator.leftUp, new Dimension((int)(separator.rightDown.getX() - separator.leftUp.getX()), (int)(separator.rightDown.getY() - separator.leftUp.getY()))) : new Rectangle(0, separator.startPoint, this._image.getWidth(), separator.endPoint - separator.startPoint);
            this._pool.draw(rect);
            this._pool.fill(rect);
        }
    }

    public void exportHorizontalSeparatorsToImage() {
        this.createPool();
        this.drawHorizontalSeparators();
        this.saveToImage("horizontalSeparators");
    }

    public void exportHorizontalSeparatorsToImage(int suffix) {
        this.createPool();
        this.drawHorizontalSeparators();
        this.saveToImage("horizontalSeparators" + suffix);
    }

    public void saveToImage(String filename) {
        filename = System.getProperty("user.dir") + "/" + (String)filename + ".png";
        try {
            ImageIO.write((RenderedImage)this._image, "png", new File((String)filename));
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveToImage(String filename, String folder) {
        if (folder.equals("")) {
            return;
        }
        filename = folder + "/" + (String)filename + ".png";
        try {
            ImageIO.write((RenderedImage)this._image, "png", new File((String)filename));
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public List<Separator> getHorizontalSeparators() {
        return this._horizontalSeparators;
    }

    @Override
    public void setHorizontalSeparators(List<Separator> separators) {
        this._horizontalSeparators.clear();
        this._horizontalSeparators.addAll(separators);
    }

    @Override
    public List<Separator> getVerticalSeparators() {
        return this._verticalSeparators;
    }

    @Override
    public void setVerticalSeparators(List<Separator> separators) {
        this._verticalSeparators.clear();
        this._verticalSeparators.addAll(separators);
    }

    @Override
    public void setCleanUpSeparators(int treshold) {
        this._cleanSeparatorsTreshold = treshold;
    }

    @Override
    public boolean isCleanUpEnabled() {
        return this._cleanSeparatorsTreshold == 0;
    }
}

