/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.Separator;
import com.crawljax.vips_selenium.VipsSeparatorDetector;
import com.crawljax.vips_selenium.VipsUtils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VipsSeparatorNonGraphicsDetector
implements VipsSeparatorDetector {
    Node _vipsBlocks = null;
    List<Node> _visualBlocks = null;
    private List<Separator> _horizontalSeparators = null;
    private List<Separator> _verticalSeparators = null;
    private int _width = 0;
    private int _height = 0;
    private int _cleanSeparatorsTreshold = 0;
    private WebDriver driver = null;

    public VipsSeparatorNonGraphicsDetector(int width, int height, WebDriver driver) {
        this._width = width;
        this._height = height;
        this.driver = driver;
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
        this._visualBlocks = new ArrayList<Node>();
    }

    private void fillPoolWithBlocks(Node vipsBlock) {
        if (VipsUtils.isVisualBlock(vipsBlock)) {
            this._visualBlocks.add(vipsBlock);
        }
        NodeList children = vipsBlock.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node vipsBlockChild = children.item(i);
            this.fillPoolWithBlocks(vipsBlockChild);
        }
    }

    @Override
    public void fillPool() {
        if (this._vipsBlocks != null) {
            this.fillPoolWithBlocks(this._vipsBlocks);
        }
    }

    @Override
    public Node getVipsBlock() {
        return this._vipsBlocks;
    }

    @Override
    public void setVipsBlock(Node vipsBlock) {
        this._vipsBlocks = vipsBlock;
        this._visualBlocks.clear();
        this.fillPoolWithBlocks(vipsBlock);
    }

    @Override
    public List<Node> getVisualBlocks() {
        return this._visualBlocks;
    }

    @Override
    public void setVisualBlocks(List<Node> visualBlocks) {
        this._visualBlocks.clear();
        this._visualBlocks.addAll(visualBlocks);
    }

    private void findVerticalSeparators() {
        block0: for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int blockStart = rect.x;
            int blockEnd = blockStart + rect.width;
            for (Separator separator : this._verticalSeparators) {
                int nextSeparatorIndex;
                if (blockStart >= separator.endPoint) continue;
                if (blockStart < separator.startPoint && blockEnd >= separator.endPoint) {
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._verticalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart >= other.startPoint || blockEnd <= other.endPoint) continue;
                        this._verticalSeparators.remove(other);
                    }
                    for (Separator other : this._verticalSeparators) {
                        if (blockEnd <= other.startPoint || blockEnd >= other.endPoint) continue;
                        other.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    continue block0;
                }
                if (blockEnd < separator.startPoint) continue block0;
                if (blockStart < separator.startPoint && blockEnd >= separator.startPoint) {
                    separator.startPoint = blockEnd + 1;
                    continue block0;
                }
                if (blockStart >= separator.startPoint && blockEnd <= separator.endPoint) {
                    if (blockStart == separator.startPoint) {
                        separator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    if (blockEnd == separator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        continue block0;
                    }
                    this._verticalSeparators.add(this._verticalSeparators.indexOf(separator) + 1, new Separator(blockEnd + 1, separator.endPoint));
                    separator.endPoint = blockStart - 1;
                    continue block0;
                }
                if (blockStart > separator.startPoint && blockStart < separator.endPoint && (nextSeparatorIndex = this._verticalSeparators.indexOf(separator)) + 1 < this._verticalSeparators.size()) {
                    Separator nextSeparator = this._verticalSeparators.get(this._verticalSeparators.indexOf(separator) + 1);
                    if (blockEnd > nextSeparator.startPoint && blockEnd < nextSeparator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        nextSeparator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._verticalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart < other.startPoint && other.endPoint < blockEnd) {
                            this._verticalSeparators.remove(other);
                            continue;
                        }
                        if (blockEnd > other.startPoint && blockEnd < other.endPoint) {
                            other.startPoint = blockEnd + 1;
                            continue block0;
                        }
                        if (blockStart <= other.startPoint || blockStart >= other.endPoint) continue;
                        other.endPoint = blockStart - 1;
                    }
                    continue block0;
                }
                separator.endPoint = blockStart - 1;
                continue block0;
            }
        }
    }

    private void findHorizontalSeparators() {
        block0: for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int blockStart = rect.y;
            int blockEnd = blockStart + rect.height;
            for (Separator separator : this._horizontalSeparators) {
                int nextSeparatorIndex;
                if (blockStart >= separator.endPoint) continue;
                if (blockStart < separator.startPoint && blockEnd >= separator.endPoint) {
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._horizontalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart >= other.startPoint || blockEnd <= other.endPoint) continue;
                        this._horizontalSeparators.remove(other);
                    }
                    for (Separator other : this._horizontalSeparators) {
                        if (blockEnd <= other.startPoint || blockEnd >= other.endPoint) continue;
                        other.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    continue block0;
                }
                if (blockEnd < separator.startPoint) continue block0;
                if (blockStart <= separator.startPoint && blockEnd >= separator.startPoint) {
                    separator.startPoint = blockEnd + 1;
                    continue block0;
                }
                if (blockStart >= separator.startPoint && blockEnd < separator.endPoint) {
                    if (blockStart == separator.startPoint) {
                        separator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    if (blockEnd == separator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        continue block0;
                    }
                    this._horizontalSeparators.add(this._horizontalSeparators.indexOf(separator) + 1, new Separator(blockEnd + 1, separator.endPoint));
                    separator.endPoint = blockStart - 1;
                    continue block0;
                }
                if (blockStart > separator.startPoint && blockStart < separator.endPoint && (nextSeparatorIndex = this._horizontalSeparators.indexOf(separator)) + 1 < this._horizontalSeparators.size()) {
                    Separator nextSeparator = this._horizontalSeparators.get(this._horizontalSeparators.indexOf(separator) + 1);
                    if (blockEnd > nextSeparator.startPoint && blockEnd < nextSeparator.endPoint) {
                        separator.endPoint = blockStart - 1;
                        nextSeparator.startPoint = blockEnd + 1;
                        continue block0;
                    }
                    ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
                    tempSeparators.addAll(this._horizontalSeparators);
                    for (Separator other : tempSeparators) {
                        if (blockStart < other.startPoint && other.endPoint < blockEnd) {
                            this._horizontalSeparators.remove(other);
                            continue;
                        }
                        if (blockEnd > other.startPoint && blockEnd < other.endPoint) {
                            other.startPoint = blockEnd + 1;
                            continue block0;
                        }
                        if (blockStart <= other.startPoint || blockStart >= other.endPoint) continue;
                        other.endPoint = blockStart - 1;
                    }
                    continue block0;
                }
                separator.endPoint = blockStart - 1;
                continue block0;
            }
        }
    }

    @Override
    public void detectHorizontalSeparators() {
        if (this._visualBlocks.size() == 0) {
            System.err.println("I don't have any visual blocks!");
            return;
        }
        this._horizontalSeparators.clear();
        this._horizontalSeparators.add(new Separator(0, this._height));
        this.findHorizontalSeparators();
        ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
        tempSeparators.addAll(this._horizontalSeparators);
        for (Separator separator : tempSeparators) {
            if (separator.startPoint == 0) {
                this._horizontalSeparators.remove(separator);
            }
            if (separator.endPoint != this._height) continue;
            this._horizontalSeparators.remove(separator);
        }
        if (this._cleanSeparatorsTreshold != 0) {
            this.cleanUpSeparators(this._horizontalSeparators);
        }
        this.computeHorizontalWeights();
        this.sortSeparatorsByWeight(this._horizontalSeparators);
    }

    @Override
    public void detectVerticalSeparators() {
        if (this._visualBlocks.size() == 0) {
            System.err.println("I don't have any visual blocks!");
            return;
        }
        this._verticalSeparators.clear();
        this._verticalSeparators.add(new Separator(0, this._width));
        this.findVerticalSeparators();
        ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
        tempSeparators.addAll(this._verticalSeparators);
        for (Separator separator : tempSeparators) {
            if (separator.startPoint == 0) {
                this._verticalSeparators.remove(separator);
            }
            if (separator.endPoint != this._width) continue;
            this._verticalSeparators.remove(separator);
        }
        if (this._cleanSeparatorsTreshold != 0) {
            this.cleanUpSeparators(this._verticalSeparators);
        }
        this.computeVerticalWeights();
        this.sortSeparatorsByWeight(this._verticalSeparators);
    }

    private void cleanUpSeparators(List<Separator> separators) {
        ArrayList<Separator> tempList = new ArrayList<Separator>();
        tempList.addAll(separators);
        for (Separator separator : tempList) {
            int width = separator.endPoint - separator.startPoint + 1;
            if (width >= this._cleanSeparatorsTreshold) continue;
            separators.remove(separator);
        }
    }

    private void sortSeparatorsByWeight(List<Separator> separators) {
        Collections.sort(separators);
    }

    private void computeVerticalWeights() {
        for (Separator separator : this._verticalSeparators) {
            this.ruleOne(separator);
            this.ruleTwo(separator, false);
            this.ruleThree(separator, false);
        }
    }

    private void computeHorizontalWeights() {
        for (Separator separator : this._horizontalSeparators) {
            this.ruleOne(separator);
            this.ruleTwo(separator, true);
            this.ruleThree(separator, true);
            this.ruleFour(separator);
            this.ruleFive(separator);
        }
    }

    private void ruleOne(Separator separator) {
        int width = separator.endPoint - separator.startPoint + 1;
        if (width > 55) {
            separator.weight += 12;
        }
        if (width > 45 && width <= 55) {
            separator.weight += 10;
        }
        if (width > 35 && width <= 45) {
            separator.weight += 8;
        }
        separator.weight = width > 25 && width <= 35 ? (separator.weight += 6) : (width > 15 && width <= 25 ? (separator.weight += 4) : (width > 8 && width <= 15 ? (separator.weight += 2) : ++separator.weight));
    }

    private void ruleTwo(Separator separator, boolean horizontal) {
        ArrayList<Node> overlappedElements = new ArrayList<Node>();
        if (horizontal) {
            this.findHorizontalOverlappedElements(separator, overlappedElements);
        } else {
            this.findVerticalOverlappedElements(separator, overlappedElements);
        }
        if (overlappedElements.size() == 0) {
            return;
        }
        for (Node vipsBlock : overlappedElements) {
            if (!vipsBlock.getNodeName().equalsIgnoreCase("hr")) continue;
            separator.weight += 2;
            break;
        }
    }

    private void findHorizontalOverlappedElements(Separator separator, List<Node> result) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int topEdge = rect.y;
            int bottomEdge = topEdge + rect.height;
            if (topEdge > separator.startPoint && topEdge < separator.endPoint && bottomEdge > separator.endPoint) {
                result.add(vipsBlock);
            }
            if (topEdge < separator.startPoint && bottomEdge > separator.startPoint && bottomEdge < separator.endPoint) {
                result.add(vipsBlock);
            }
            if (topEdge < separator.startPoint || bottomEdge > separator.endPoint) continue;
            result.add(vipsBlock);
        }
    }

    private void findVerticalOverlappedElements(Separator separator, List<Node> result) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int leftEdge = rect.x;
            int rightEdge = leftEdge + rect.width;
            if (leftEdge > separator.startPoint && leftEdge < separator.endPoint && rightEdge > separator.endPoint) {
                result.add(vipsBlock);
            }
            if (leftEdge < separator.startPoint && rightEdge > separator.startPoint && rightEdge < separator.endPoint) {
                result.add(vipsBlock);
            }
            if (leftEdge < separator.startPoint || rightEdge > separator.endPoint) continue;
            result.add(vipsBlock);
        }
    }

    private void ruleThree(Separator separator, boolean horizontal) {
        ArrayList<Node> topAdjacentElements = new ArrayList<Node>();
        ArrayList<Node> bottomAdjacentElements = new ArrayList<Node>();
        if (horizontal) {
            this.findHorizontalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        } else {
            this.findVerticalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        }
        if (topAdjacentElements.size() < 1 || bottomAdjacentElements.size() < 1) {
            return;
        }
        boolean weightIncreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                if (VipsUtils.getBgColor(top, this.driver).equalsIgnoreCase(VipsUtils.getBgColor(bottom, this.driver))) continue;
                separator.weight += 2;
                weightIncreased = true;
                break;
            }
            if (!weightIncreased) continue;
            break;
        }
    }

    private void findHorizontalAdjacentBlocks(Separator separator, List<Node> resultTop, List<Node> resultBottom) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int topEdge = rect.y;
            int bottomEdge = topEdge + rect.height;
            if (topEdge == separator.endPoint + 1 && bottomEdge > separator.endPoint + 1) {
                resultBottom.add(vipsBlock);
            }
            if (bottomEdge != separator.startPoint - 1 || topEdge >= separator.startPoint - 1) continue;
            resultTop.add(0, vipsBlock);
        }
    }

    private void findVerticalAdjacentBlocks(Separator separator, List<Node> resultLeft, List<Node> resultRight) {
        for (Node vipsBlock : this._visualBlocks) {
            Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
            int leftEdge = rect.x + 1;
            int rightEdge = leftEdge + rect.width;
            if (leftEdge == separator.endPoint + 1 && rightEdge > separator.endPoint + 1) {
                resultRight.add(vipsBlock);
            }
            if (rightEdge != separator.startPoint - 1 || leftEdge >= separator.startPoint - 1) continue;
            resultLeft.add(0, vipsBlock);
        }
    }

    private void ruleFour(Separator separator) {
        ArrayList<Node> topAdjacentElements = new ArrayList<Node>();
        ArrayList<Node> bottomAdjacentElements = new ArrayList<Node>();
        this.findHorizontalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        if (topAdjacentElements.size() < 1 || bottomAdjacentElements.size() < 1) {
            return;
        }
        boolean weightIncreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                int diff = Math.abs(VipsUtils.getFontSize(top, this.driver) - VipsUtils.getFontSize(bottom, this.driver));
                if (diff != 0) {
                    separator.weight += 2;
                    weightIncreased = true;
                    break;
                }
                if (VipsUtils.getFontWeight(top, this.driver).equalsIgnoreCase(VipsUtils.getFontWeight(bottom, this.driver))) continue;
                separator.weight += 2;
            }
            if (!weightIncreased) continue;
            break;
        }
        weightIncreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                if (VipsUtils.getFontSize(top, this.driver) >= VipsUtils.getFontSize(bottom, this.driver)) continue;
                separator.weight += 2;
                weightIncreased = true;
                break;
            }
            if (!weightIncreased) continue;
            break;
        }
    }

    private void ruleFive(Separator separator) {
        ArrayList<Node> topAdjacentElements = new ArrayList<Node>();
        ArrayList<Node> bottomAdjacentElements = new ArrayList<Node>();
        this.findHorizontalAdjacentBlocks(separator, topAdjacentElements, bottomAdjacentElements);
        if (topAdjacentElements.size() < 1 || bottomAdjacentElements.size() < 1) {
            return;
        }
        boolean weightDecreased = false;
        for (Node top : topAdjacentElements) {
            for (Node bottom : bottomAdjacentElements) {
                if (!VipsUtils.isTextBox(top) || !VipsUtils.isTextBox(bottom)) continue;
                separator.weight -= 2;
                weightDecreased = true;
                break;
            }
            if (!weightDecreased) continue;
            break;
        }
    }

    @Override
    public List<Separator> getHorizontalSeparators() {
        return this._horizontalSeparators;
    }

    @Override
    public void setHorizontalSeparators(List<Separator> separators) {
        this._horizontalSeparators.clear();
        this._horizontalSeparators.addAll(separators);
    }

    @Override
    public List<Separator> getVerticalSeparators() {
        return this._verticalSeparators;
    }

    @Override
    public void setVerticalSeparators(List<Separator> separators) {
        this._verticalSeparators.clear();
        this._verticalSeparators.addAll(separators);
    }

    @Override
    public void setCleanUpSeparators(int treshold) {
        this._cleanSeparatorsTreshold = treshold;
    }

    @Override
    public boolean isCleanUpEnabled() {
        return this._cleanSeparatorsTreshold == 0;
    }
}

