/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.DomUtils;
import com.crawljax.vips_selenium.Scripts;
import com.crawljax.vips_selenium.VipsBrowserAttributes;
import com.crawljax.vips_selenium.VipsRectangle;
import com.crawljax.vips_selenium.XPathHelper;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VipsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VipsUtils.class);
    private static final String RECTANGLE = "rectangle";
    private static final String ISVISUALBLOCK = "isvisualblock";
    private static final String ISDISPLAYED = "isdisplayed";
    private static final String ALREADYDIVIDED = "alreadydivided";
    private static final String PCOUNT = "pcount";
    private static final String CONTAINSTABLE = "containstable";
    private static final String VIPSLEVEL = "vipslevel";
    private static final String DOC = "doc";
    private static final String ISDIVIDABLE = "isdividable";
    private static final String IMAGECOUNT = "imagecount";
    private static final String LINKTEXTLENGTH = "linktextlength";
    private static final String BGCOLOR = "bgcolor";
    private static final String FONTWEIGHT = "fontweight";
    private static final String FONTSIZE = "fontsize";
    private static final String BACKGROUNDCOLOR = "background-color";
    private static final String FRAGPARENT = "fragparent";
    private static final String DYNAMIC_FRAGMENT = "dynamicfragment";
    private static final String POPULATED = "populated";
    private static final String DIRACCESS = "diraccess";
    private static final String INDIRACCESS = "indiraccess";
    private static final String JSOBSERVER = "jsobserver";
    private static final String ANYACCESS = "anyaccess";
    private static final String EVLIST = "evlist";
    private static final String EVLISTVAL = "evlistval";
    public static boolean USE_CDP = false;
    static String COMPUTEDSTYLESHEET_ALL = "return Array.from(%s).map(element => {return {xpath: element, attributes: getVipsAttributes(element)}});";
    static String CDP_COMPUTEDSTYLESHEET_ALL = "Array.from(%s).map(element => {return {xpath: element, attributes: getVipsAttributes(element)}});";
    static String CONTENT_RECTANGLE_JAVASCRIPT_FUNCTION = "function getInt(str, digits){\n\tvar value = parseInt(str, digits);\n\tif(Number.isNaN(value)){\n\t\treturn 0;\n\t}\n\treturn value;\n}\n\nfunction computeContentRect(a){\nvar map1 = a.computedStyleMap();\n\nvar padding_left = getInt(map1.get('padding-left'), 10);\nvar padding_right = getInt(map1.get('padding-right'), 10);\nvar border_left_width = getInt(map1.get('border-left-width'), 10);\nvar border_right_width = getInt(map1.get('border-right-width'), 10);\n\nvar padding_top = getInt(map1.get('padding-top'), 10);\nvar padding_bottom = getInt(map1.get('padding-bottom'), 10) ;\nvar border_top_width = getInt(map1.get('border-top-width'), 10);\nvar border_bottom_width = getInt(map1.get('border-bottom-width'), 10) ;\n\nvar font_size = getInt(map1.get('font-size'), 10);\n\n\nvar width = a.getBoundingClientRect().width -  (padding_left + padding_right + border_left_width + border_right_width );\nvar height = a.getBoundingClientRect().height - (padding_top + padding_bottom  + border_top_width + border_bottom_width);\nvar x = scrollX + a.getBoundingClientRect().x + (padding_left +  border_left_width);\nvar y = scrollY + a.getBoundingClientRect().y + (padding_top + border_top_width);\nvar returnString = Math.round(x) +  \" : \" + Math.round(y) + \" : \" + Math.round(width) + \" : \" + Math.round(height) + ':' + Math.round(font_size);\nconsole.log(returnString);\nreturn returnString;\n}";
    static String CONTENT_RECTANGLE_RETURN = "return computeContentRect(arguments[0]);";
    private static boolean useScript = true;

    public static String[] getVipsAttributes() {
        String[] returnArray = new String[]{RECTANGLE, ISDISPLAYED, ISDIVIDABLE, ISVISUALBLOCK, ALREADYDIVIDED, PCOUNT, CONTAINSTABLE, VIPSLEVEL, DOC, IMAGECOUNT, LINKTEXTLENGTH, BGCOLOR, FONTSIZE, FONTWEIGHT, BACKGROUNDCOLOR, FRAGPARENT, POPULATED, DYNAMIC_FRAGMENT, DIRACCESS, INDIRACCESS};
        return returnArray;
    }

    public static void cleanDom(Document dom, boolean offline) {
        Element root = dom.getDocumentElement();
        VipsUtils.cleanNode(root, offline);
        root.normalize();
    }

    private static void removeOfflineAttributes(Node node) {
        if (!node.hasAttributes()) {
            return;
        }
        if (node.getAttributes().getNamedItem(FRAGPARENT) != null) {
            node.getAttributes().removeNamedItem(FRAGPARENT);
        }
    }

    private static void cleanNode(Node root, boolean offline) {
        if (offline && root.hasAttributes()) {
            VipsUtils.removeOfflineAttributes(root);
        }
        NodeList childNodes = root.getChildNodes();
        ArrayList<Node> toRemove = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getAttributes() == null) {
                if (childNode.getNodeName().equalsIgnoreCase("#text") && !childNode.getTextContent().trim().isEmpty()) continue;
                toRemove.add(childNode);
                continue;
            }
            VipsUtils.cleanNode(childNode, offline);
        }
        for (Node toRemoveNode : toRemove) {
            toRemoveNode.getParentNode().removeChild(toRemoveNode);
        }
    }

    public static ArrayList<Node> getChildren(Node vipsBlock) {
        if (vipsBlock == null || vipsBlock.getNodeName().equalsIgnoreCase("#text") || vipsBlock.getChildNodes() == null) {
            return new ArrayList<Node>();
        }
        NodeList childNodes = vipsBlock.getChildNodes();
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child == null || child.getNodeName().equalsIgnoreCase("#text") && child.getTextContent().trim().isEmpty()) continue;
            children.add(child);
        }
        return children;
    }

    public static void setDoC(Node vipsBlock, int i) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(DOC);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(DOC).setNodeValue(Integer.toString(i));
    }

    public static int getDoC(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getDoC(vipsBlock.getParentNode());
        }
        if (vipsBlock.getAttributes().getNamedItem(DOC) == null) {
            return 11;
        }
        String value = vipsBlock.getAttributes().getNamedItem(DOC).getNodeValue();
        return Integer.parseInt(value);
    }

    public static void setIsVisualBlock(Node vipsBlock, boolean b) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(ISVISUALBLOCK);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(ISVISUALBLOCK).setNodeValue(b ? "true" : "false");
        VipsUtils.checkProperties(vipsBlock);
    }

    public static void checkProperties(Node vipsBlock) {
        VipsUtils.checkIsImg(vipsBlock);
        VipsUtils.checkContainImg(vipsBlock);
        VipsUtils.checkContainTable(vipsBlock);
        VipsUtils.checkContainP(vipsBlock);
        VipsUtils.countLinkTextLength(vipsBlock);
        VipsUtils.setSourceIndex(vipsBlock);
    }

    public static void setSourceIndex(Node vipsBlock) {
    }

    public static void countLinkTextLength(Node vipsBlock) {
        int ltl = 0;
        if (vipsBlock.getNodeName().equalsIgnoreCase("a")) {
            ltl += vipsBlock.getTextContent().trim().length();
        }
        NodeList childNodes = vipsBlock.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childVipsBlock = childNodes.item(i);
            if (!childVipsBlock.getNodeName().equalsIgnoreCase("a")) continue;
            ltl += childVipsBlock.getTextContent().trim().length();
        }
        VipsUtils.setLinkTextLength(vipsBlock, ltl);
    }

    public static void checkContainP(Node vipsBlock) {
        int containP = 0;
        if (vipsBlock.getNodeName().equalsIgnoreCase("p")) {
            ++containP;
        }
        NodeList childNodes = vipsBlock.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childVipsBlock = childNodes.item(i);
            if (!childVipsBlock.getNodeName().equalsIgnoreCase("p")) continue;
            ++containP;
        }
        VipsUtils.setPCount(vipsBlock, containP);
    }

    public static void checkContainTable(Node vipsBlock) {
        boolean containTable = false;
        if (vipsBlock.getNodeName().equalsIgnoreCase("table")) {
            containTable = true;
        }
        NodeList childNodes = vipsBlock.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childVipsBlock = childNodes.item(i);
            if (!childVipsBlock.getNodeName().equalsIgnoreCase("table")) continue;
            containTable = true;
        }
        if (containTable) {
            VipsUtils.setContainsTable(vipsBlock);
        }
    }

    public static void checkContainImg(Node vipsBlock) {
        int containImg = 0;
        if (vipsBlock.getNodeName().equalsIgnoreCase("img")) {
            ++containImg;
        }
        NodeList childNodes = vipsBlock.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childVipsBlock = childNodes.item(i);
            if (!VipsUtils.checkIsImg(childVipsBlock)) continue;
            ++containImg;
        }
        VipsUtils.setImageCount(vipsBlock, containImg);
    }

    public static boolean checkIsImg(Node vipsBlock) {
        return vipsBlock.getNodeName().equalsIgnoreCase("img");
    }

    public static void setAlreadyDivided(Node vipsBlock) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(ALREADYDIVIDED);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
    }

    public static boolean isAlreadyDivided(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.isAlreadyDivided(vipsBlock.getParentNode());
        }
        return vipsBlock.getAttributes().getNamedItem(ALREADYDIVIDED) != null;
    }

    public static void setContainsTable(Node vipsBlock) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(CONTAINSTABLE);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
    }

    public static boolean containsTable(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.containsTable(vipsBlock.getParentNode());
        }
        return vipsBlock.getAttributes().getNamedItem(CONTAINSTABLE) != null;
    }

    public static void setRectangle(Node vipsBlock, java.awt.Rectangle rect) {
        Gson gson = new Gson();
        String rectString = gson.toJson((Object)rect);
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(RECTANGLE);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(RECTANGLE).setNodeValue(rectString);
    }

    public static boolean isDisplayed(Node vipsBlock, WebDriver driver) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.isDisplayed(vipsBlock.getParentNode(), driver);
        }
        if (vipsBlock.getAttributes().getNamedItem(ISDISPLAYED) != null) {
            String str = vipsBlock.getAttributes().getNamedItem(ISDISPLAYED).getNodeValue();
            return str.equalsIgnoreCase("true");
        }
        if (driver == null) {
            VipsUtils.setDisplayedUsingRectangle(vipsBlock);
            LOG.debug("Cannot find isDisplayed for {}. Using rectangle", (Object)vipsBlock.getNodeName());
            return VipsUtils.isDisplayed(vipsBlock, driver);
        }
        boolean isDisplayed = false;
        try {
            String xpath = XPathHelper.getXPathExpression(vipsBlock);
            WebElement element = driver.findElement(By.xpath((String)xpath));
            isDisplayed = element.isDisplayed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        VipsUtils.setIsDisplayed(vipsBlock, isDisplayed ? "true" : "false");
        return isDisplayed;
    }

    private static void setDisplayedUsingRectangle(Node vipsBlock) {
        java.awt.Rectangle rectangle = VipsUtils.getRectangle(vipsBlock, null);
        boolean isDisplayed = rectangle != null && rectangle.height > 0 && rectangle.width > 0;
        VipsUtils.setIsDisplayed(vipsBlock, isDisplayed ? "true" : "false");
    }

    public static void setIsDisplayed(Node vipsBlock, String value) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(ISDISPLAYED);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(ISDISPLAYED).setNodeValue(value);
    }

    public static void setIsDividable(Node vipsBlock, boolean b) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(ISDIVIDABLE);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(ISDIVIDABLE).setNodeValue(b ? "true" : "false");
    }

    static boolean isDividable(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.isDividable(vipsBlock.getParentNode());
        }
        if (vipsBlock.getAttributes().getNamedItem(ISDIVIDABLE) != null) {
            String value = vipsBlock.getAttributes().getNamedItem(ISDIVIDABLE).getNodeValue();
            return value.trim().equalsIgnoreCase("true");
        }
        return vipsBlock.getAttributes().getNamedItem(ISDIVIDABLE) != null;
    }

    public static boolean isTextBox(Node vipsBlockChild) {
        return vipsBlockChild.getNodeName().equalsIgnoreCase("#text");
    }

    public static boolean isVisualBlock(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.isVisualBlock(vipsBlock.getParentNode());
        }
        if (vipsBlock.getAttributes().getNamedItem(ISVISUALBLOCK) != null) {
            String value = vipsBlock.getAttributes().getNamedItem(ISVISUALBLOCK).getNodeValue();
            return value.trim().equalsIgnoreCase("true");
        }
        return vipsBlock.getAttributes().getNamedItem(ISVISUALBLOCK) != null;
    }

    public static java.awt.Rectangle peelRectangleLayer(java.awt.Rectangle rect, String toRemove) {
        String[] settings = toRemove.split(" ");
        int top = VipsUtils.getNumerals(settings[0]);
        int right = VipsUtils.getNumerals(settings[0]);
        int bottom = VipsUtils.getNumerals(settings[0]);
        int left = VipsUtils.getNumerals(settings[0]);
        if (settings.length == 2) {
            right = VipsUtils.getNumerals(settings[1]);
            left = VipsUtils.getNumerals(settings[1]);
        }
        if (settings.length == 3) {
            right = VipsUtils.getNumerals(settings[1]);
            bottom = VipsUtils.getNumerals(settings[2]);
            left = VipsUtils.getNumerals(settings[1]);
        }
        if (settings.length == 4) {
            right = VipsUtils.getNumerals(settings[1]);
            bottom = VipsUtils.getNumerals(settings[2]);
            left = VipsUtils.getNumerals(settings[3]);
        }
        java.awt.Rectangle returnRect = new java.awt.Rectangle(rect.x + left, rect.y + top, rect.width - (left + right), rect.height - (top + bottom));
        return returnRect;
    }

    private static int getNumerals(String string) {
        return Integer.parseInt(string.replaceAll("[^0-9]", ""));
    }

    public static java.awt.Rectangle getContentRectangle(Node node, WebDriver driver) {
        String xpath = XPathHelper.getXPathExpression(node);
        WebElement vipsBlock = driver.findElement(By.xpath((String)xpath));
        String javascriptReturn = ((JavascriptExecutor)driver).executeScript(CONTENT_RECTANGLE_JAVASCRIPT_FUNCTION + CONTENT_RECTANGLE_RETURN, new Object[]{vipsBlock}).toString();
        LOG.debug(javascriptReturn);
        String[] split = javascriptReturn.split(":");
        if (split.length == 5) {
            java.awt.Rectangle rect = new java.awt.Rectangle(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim()), Integer.parseInt(split[3].trim()));
            int fontSize = Integer.parseInt(split[4].trim());
            VipsUtils.setFontSize(node, fontSize);
            return rect;
        }
        Rectangle outer_return = vipsBlock.getRect();
        java.awt.Rectangle outer = new java.awt.Rectangle(outer_return.x, outer_return.y, outer_return.width, outer_return.height);
        LOG.debug("Outer : " + outer);
        String toRemove = vipsBlock.getCssValue("margin");
        outer = VipsUtils.peelRectangleLayer(outer, toRemove);
        LOG.debug("peeling margin : " + outer);
        toRemove = vipsBlock.getCssValue("border-width");
        outer = VipsUtils.peelRectangleLayer(outer, toRemove);
        LOG.debug("peeling border : " + outer);
        toRemove = vipsBlock.getCssValue("padding");
        outer = VipsUtils.peelRectangleLayer(outer, toRemove);
        LOG.debug("peeling padding : " + outer);
        return outer;
    }

    public static java.awt.Rectangle getRectangle(Node vipsBlock, WebDriver driver) {
        if (vipsBlock == null) {
            return null;
        }
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getRectangle(vipsBlock.getParentNode(), driver);
        }
        if (vipsBlock.getAttributes().getNamedItem(RECTANGLE) != null) {
            Gson gson = new Gson();
            String rectString = vipsBlock.getAttributes().getNamedItem(RECTANGLE).getNodeValue();
            java.awt.Rectangle rect = (java.awt.Rectangle)gson.fromJson(rectString, java.awt.Rectangle.class);
            return rect;
        }
        if (vipsBlock.getNodeName().equalsIgnoreCase("text")) {
            java.awt.Rectangle rect = VipsUtils.getRectangle(vipsBlock.getParentNode(), driver);
            ArrayList siblingRects = new ArrayList();
            ArrayList<Node> siblings = VipsUtils.getChildren(vipsBlock.getParentNode());
            int index = siblings.indexOf(vipsBlock);
            java.awt.Rectangle beforeRect = null;
            java.awt.Rectangle afterRect = null;
            if (index > 0 && !((Node)siblings.get(index - 1)).getNodeName().equalsIgnoreCase("text")) {
                beforeRect = VipsUtils.getRectangle((Node)siblings.get(index - 1), driver);
            }
            if (index < siblings.size() - 1 && !((Node)siblings.get(index + 1)).getNodeName().equalsIgnoreCase("text")) {
                afterRect = VipsUtils.getRectangle((Node)siblings.get(index + 1), driver);
            }
            java.awt.Rectangle returnRect = VipsUtils.getInBetweenRectangle(beforeRect, afterRect, rect);
            return returnRect;
        }
        String xpath = XPathHelper.getXPathExpression(vipsBlock);
        try {
            LOG.debug(vipsBlock.getNodeName());
            java.awt.Rectangle rect = VipsUtils.getContentRectangle(vipsBlock, driver);
            VipsUtils.setRectangle(vipsBlock, rect);
            return rect;
        }
        catch (Exception ex) {
            java.awt.Rectangle rect = new java.awt.Rectangle(-1, -1, -1, -1);
            VipsUtils.setRectangle(vipsBlock, rect);
            LOG.debug("Problem getting rectangle for element with xpath : " + xpath);
            return rect;
        }
    }

    private static java.awt.Rectangle getInBetweenRectangle(java.awt.Rectangle beforeRect, java.awt.Rectangle afterRect, java.awt.Rectangle rect) {
        if (beforeRect == null || afterRect == null) {
            return rect;
        }
        java.awt.Rectangle returnRect = new java.awt.Rectangle(-1, -1, -1, -1);
        if (beforeRect.x + beforeRect.width < afterRect.x) {
            returnRect.setLocation(beforeRect.x + beforeRect.width, beforeRect.y);
            returnRect.setSize(afterRect.x - returnRect.x, beforeRect.height);
        }
        if (beforeRect.y + beforeRect.height < afterRect.y) {
            returnRect.setLocation(beforeRect.x, beforeRect.y + beforeRect.height);
            returnRect.setSize(beforeRect.width, afterRect.y - returnRect.y);
        }
        return returnRect;
    }

    private static void setCssProperty(Node vipsBlock, String property, String propertyValue) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(property);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(property).setNodeValue(propertyValue);
    }

    public static void setFontSize(Node vipsBlock, int fontSize) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(FONTSIZE);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(FONTSIZE).setNodeValue(Integer.toString(fontSize));
    }

    public static int getFontSize(Node vipsBlock, WebDriver driver) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text") || vipsBlock.getNodeName().equalsIgnoreCase("text")) {
            return VipsUtils.getFontSize(vipsBlock.getParentNode(), driver);
        }
        if (vipsBlock.getAttributes().getNamedItem(FONTSIZE) != null) {
            String propertyValue = vipsBlock.getAttributes().getNamedItem(FONTSIZE).getNodeValue();
            return Integer.parseInt(propertyValue);
        }
        String xpath = XPathHelper.getXPathExpression(vipsBlock);
        WebElement element = driver.findElement(By.xpath((String)xpath));
        String propertyValue = element.getCssValue("fontSize");
        propertyValue = propertyValue.replaceAll("\\D+", "");
        int fontSize = Integer.parseInt(propertyValue);
        VipsUtils.setFontSize(vipsBlock, fontSize);
        return fontSize;
    }

    private static String getCssProperty(Node vipsBlock, String property, WebDriver driver) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text") || vipsBlock.getNodeName().equalsIgnoreCase("text")) {
            return VipsUtils.getCssProperty(vipsBlock.getParentNode(), property, driver);
        }
        if (vipsBlock.getAttributes().getNamedItem(property.toLowerCase()) != null) {
            String propertyValue = vipsBlock.getAttributes().getNamedItem(property.toLowerCase()).getNodeValue();
            return propertyValue;
        }
        if (driver == null) {
            return "";
        }
        String xpath = XPathHelper.getXPathExpression(vipsBlock);
        WebElement element = driver.findElement(By.xpath((String)xpath));
        String propertyValue = element.getCssValue(property);
        VipsUtils.setCssProperty(vipsBlock, property.toLowerCase(), propertyValue);
        return propertyValue;
    }

    public static void setImageCount(Node vipsBlock, int containImg) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(IMAGECOUNT);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(IMAGECOUNT).setNodeValue(Integer.toString(containImg));
    }

    public static int getImageCount(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getImageCount(vipsBlock.getParentNode());
        }
        String value = vipsBlock.getAttributes().getNamedItem(IMAGECOUNT).getNodeValue();
        return Integer.parseInt(value);
    }

    public static void setPCount(Node vipsBlock, int containP) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(PCOUNT);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(PCOUNT).setNodeValue(Integer.toString(containP));
    }

    public static int getPCount(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getPCount(vipsBlock.getParentNode());
        }
        String value = vipsBlock.getAttributes().getNamedItem(PCOUNT).getNodeValue();
        return Integer.parseInt(value);
    }

    public static int getTextLength(Node vipsBlock) {
        String text = vipsBlock.getTextContent().trim();
        return text.length();
    }

    public static void setLinkTextLength(Node vipsBlock, int linkTextLength) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(LINKTEXTLENGTH);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(LINKTEXTLENGTH).setNodeValue(Integer.toString(linkTextLength));
    }

    public static int getLinkTextLength(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getLinkTextLength(vipsBlock.getParentNode());
        }
        String value = vipsBlock.getAttributes().getNamedItem(LINKTEXTLENGTH).getNodeValue();
        return Integer.parseInt(value);
    }

    public static void setVipsLevel(Node vipsBlock, int level) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(VIPSLEVEL);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(VIPSLEVEL).setNodeValue(Integer.toString(level));
    }

    public static int getVipsLevel(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getVipsLevel(vipsBlock.getParentNode());
        }
        if (VipsUtils.isVipsBlock(vipsBlock)) {
            String value = vipsBlock.getAttributes().getNamedItem(VIPSLEVEL).getNodeValue();
            return Integer.parseInt(value);
        }
        return -1;
    }

    private static boolean isVipsBlock(Node vipsBlock) {
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.isVipsBlock(vipsBlock.getParentNode());
        }
        return vipsBlock.getAttributes().getNamedItem(VIPSLEVEL) != null;
    }

    public static Node getParentBox(List<Node> nestedBlocks) {
        if (nestedBlocks == null) {
            return null;
        }
        if (nestedBlocks.isEmpty()) {
            return null;
        }
        for (Node tempBlock = nestedBlocks.get(0); tempBlock != tempBlock.getOwnerDocument().getDocumentElement(); tempBlock = tempBlock.getParentNode()) {
            LOG.debug("Trying : " + XPathHelper.getSkeletonXpath(tempBlock));
            boolean allContains = true;
            for (Node block : nestedBlocks) {
                if ((tempBlock.compareDocumentPosition(block) & 0x10) != 0 || block.isSameNode(tempBlock)) continue;
                LOG.debug(XPathHelper.getSkeletonXpath(block));
                allContains = false;
                break;
            }
            if (!allContains) continue;
            return tempBlock;
        }
        return null;
    }

    public static java.awt.Rectangle getIntersectionRectangle(java.awt.Rectangle r1, java.awt.Rectangle r2) {
        if (!VipsUtils.isValidRectangle(r1) || !VipsUtils.isValidRectangle(r2)) {
            return new java.awt.Rectangle(0, 0, 0, 0);
        }
        java.awt.Rectangle intersectionRect = null;
        int leftX = (int)Math.max(r1.getX(), r2.getX());
        int rightX = (int)Math.min(r1.getX() + r1.getWidth(), r2.getX() + r2.getWidth());
        int topY = (int)Math.max(r1.getY(), r2.getY());
        int bottomY = (int)Math.min(r1.getY() + r1.getHeight(), r2.getY() + r2.getHeight());
        intersectionRect = leftX < rightX && topY < bottomY ? new java.awt.Rectangle(leftX, topY, rightX - leftX, bottomY - topY) : new java.awt.Rectangle(0, 0, 0, 0);
        return intersectionRect;
    }

    public static java.awt.Rectangle getUnionRectangle(java.awt.Rectangle r1, java.awt.Rectangle r2) {
        if (!VipsUtils.isValidRectangle(r1) || !VipsUtils.isValidRectangle(r2)) {
            return new java.awt.Rectangle(0, 0, 0, 0);
        }
        java.awt.Rectangle unionRect = null;
        int leftX = (int)Math.min(r1.getX(), r2.getX());
        int rightX = (int)Math.max(r1.getX() + r1.getWidth(), r2.getX() + r2.getWidth());
        int topY = (int)Math.min(r1.getY(), r2.getY());
        int bottomY = (int)Math.max(r1.getY() + r1.getHeight(), r2.getY() + r2.getHeight());
        unionRect = leftX < rightX && topY < bottomY ? new java.awt.Rectangle(leftX, topY, rightX - leftX, bottomY - topY) : new java.awt.Rectangle(0, 0, 0, 0);
        return unionRect;
    }

    public static boolean isValidRectangle(java.awt.Rectangle rect) {
        return rect.x >= 0 && rect.y >= 0 && rect.width > 0 && rect.height > 0;
    }

    public static void exportFragment(BufferedImage pageViewPort, File target, java.awt.Rectangle rect) {
        try {
            BufferedImage subImage = pageViewPort.getSubimage(rect.x, rect.y, rect.width, rect.height);
            VipsUtils.saveToImage(subImage, target);
        }
        catch (Exception ex) {
            LOG.error("Error exporting rectangle to image " + rect);
            LOG.debug(ex.getStackTrace().toString());
        }
    }

    public static void exportFragments(BufferedImage pageViewport, File target, List<VipsRectangle> vipsRectangles) {
        File targetFolder = target.getParentFile();
        if (targetFolder.isDirectory()) {
            File fragFolder = new File(targetFolder, FilenameUtils.getBaseName((String)target.getName()));
            fragFolder.mkdir();
            for (VipsRectangle rect : vipsRectangles) {
                File subImageTarget = new File(fragFolder, "" + rect.getId());
                VipsUtils.exportFragment(pageViewport, subImageTarget, rect.getRect());
            }
        }
    }

    public static void saveToImage(BufferedImage image, File target) {
        try {
            ImageIO.write((RenderedImage)image, "PNG", target);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void setFontWeight(Node vipsBlock, int i) {
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(FONTWEIGHT);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(FONTWEIGHT).setNodeValue(Integer.toString(i));
    }

    public static String getFontWeight(Node vipsBlock, WebDriver driver) {
        return VipsUtils.getCssProperty(vipsBlock, FONTWEIGHT, driver);
    }

    public static String getBgColor(Node vipsBlock, WebDriver driver) {
        return VipsUtils.getCssProperty(vipsBlock, BGCOLOR, driver);
    }

    public static String getBackgroundColor(Node vipsBlock, WebDriver driver) {
        return VipsUtils.getCssProperty(vipsBlock, BACKGROUNDCOLOR, driver);
    }

    public static List<String> getXpathList(Node node) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (node.getNodeName().startsWith("#")) {
            return returnList;
        }
        returnList.add(XPathHelper.getXPathExpression(node));
        ArrayList<Node> children = VipsUtils.getChildren(node);
        for (Node child : children) {
            if (child.getNodeName().startsWith("#")) continue;
            returnList.addAll(VipsUtils.getXpathList(child));
        }
        return returnList;
    }

    public static boolean isPopulated(Document dom) {
        if (dom == null || dom.getDocumentElement() == null) {
            return false;
        }
        return dom.getDocumentElement().hasAttribute(POPULATED);
    }

    public static void setPopulated(Document dom) {
        if (dom == null) {
            return;
        }
        Element vipsBlock = dom.getDocumentElement();
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(POPULATED);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
    }

    public static void populateStyle(Document dom, WebDriver driver, boolean USE_CDP) {
        String executeScript;
        String xpathString;
        Gson gson;
        if (!useScript || VipsUtils.isPopulated(dom)) {
            LOG.info("SKipping populate dom because already populated {}", (Object)VipsUtils.isPopulated(dom));
            return;
        }
        String script = null;
        script = USE_CDP ? Scripts.CDP_SCRIPT : Scripts.VIPS_SCIRPT;
        List<String> xpaths = VipsUtils.getXpathList(dom.getElementsByTagName("body").item(0));
        LOG.info("Sending {} xpaths", (Object)xpaths.size());
        LOG.debug("{}", xpaths);
        Object attributeString = null;
        if (USE_CDP) {
            gson = new Gson();
            xpathString = gson.toJson(xpaths);
            executeScript = script + String.format(CDP_COMPUTEDSTYLESHEET_ALL, xpathString);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("expression", executeScript);
            parameters.put("includeCommandLineAPI", Boolean.TRUE);
            parameters.put("returnByValue", Boolean.TRUE);
            attributeString = ((ChromeDriver)driver).executeCdpCommand("Runtime.evaluate", parameters);
            if (attributeString instanceof Map && (attributeString = ((Map)attributeString).get("result")) instanceof Map) {
                attributeString = ((Map)attributeString).get("value");
            }
            LOG.debug("{}", attributeString);
        } else {
            gson = new Gson();
            xpathString = gson.toJson(xpaths);
            executeScript = script + String.format(COMPUTEDSTYLESHEET_ALL, xpathString);
            attributeString = ((JavascriptExecutor)driver).executeScript(executeScript, new Object[0]);
            LOG.debug(attributeString.toString());
        }
        HashMap<String, VipsBrowserAttributes> attributeMap = new HashMap<String, VipsBrowserAttributes>();
        if (attributeString instanceof Collection) {
            LOG.info("Found {} attribute objects", (Object)((Collection)attributeString).size());
            for (String elementSheet : (Collection)attributeString) {
                if (elementSheet instanceof Map) {
                    String xpath = (String)((Map)((Object)elementSheet)).get("xpath");
                    LOG.debug(xpath);
                    Object attributes = ((Map)((Object)elementSheet)).get("attributes");
                    LOG.debug("attributes{}", attributes);
                    if (attributes instanceof Map) {
                        if (((Map)attributes).isEmpty()) {
                            LOG.debug("Empty attributes found for {}", (Object)xpath);
                            continue;
                        }
                        Object rectangle = ((Map)attributes).get(RECTANGLE);
                        java.awt.Rectangle rect = null;
                        if (rectangle instanceof Map) {
                            rect = new java.awt.Rectangle((int)((Long)((Map)rectangle).get("x")).longValue(), (int)((Long)((Map)rectangle).get("y")).longValue(), (int)((Long)((Map)rectangle).get("width")).longValue(), (int)((Long)((Map)rectangle).get("height")).longValue());
                            LOG.debug(rect.toString());
                        } else {
                            rect = new java.awt.Rectangle(-1, -1, -1, -1);
                        }
                        int fontSize = (int)((Long)((Map)attributes).get(FONTSIZE)).longValue();
                        int fontWeight = (int)((Long)((Map)attributes).get(FONTWEIGHT)).longValue();
                        String bgColor = (String)((Map)attributes).get(BGCOLOR);
                        boolean isDisplayed = (Boolean)((Map)attributes).get(ISDISPLAYED);
                        String eventListeners = (String)((Map)attributes).get("eventListeners");
                        LOG.debug("rectangle {}", rectangle);
                        LOG.debug("font size {}", (Object)fontSize);
                        LOG.debug("font weight {}", (Object)fontWeight);
                        LOG.debug("bg color {}", (Object)bgColor);
                        attributeMap.put(xpath, new VipsBrowserAttributes(rect, fontSize, fontWeight, bgColor, isDisplayed, eventListeners));
                    }
                }
                LOG.debug(elementSheet.toString());
            }
        }
        for (String xpath : xpaths) {
            try {
                NodeList nodes = XPathHelper.evaluateXpathExpression(dom, xpath);
                if (nodes.getLength() != 1) continue;
                Node vipsBlock = nodes.item(0);
                if (!attributeMap.containsKey(xpath)) continue;
                VipsUtils.setBrowserAttributes(vipsBlock, (VipsBrowserAttributes)attributeMap.get(xpath));
            }
            catch (XPathExpressionException e) {
                LOG.error("Error while setting browser attribtues to document");
                LOG.error(e.getMessage());
            }
        }
        VipsUtils.setPopulated(dom);
    }

    private static void setBrowserAttributes(Node vipsBlock, VipsBrowserAttributes browserAttributes) {
        VipsUtils.setFontSize(vipsBlock, browserAttributes.getFontsize());
        VipsUtils.setFontWeight(vipsBlock, browserAttributes.getFontweight());
        VipsUtils.setCssProperty(vipsBlock, BGCOLOR, browserAttributes.getBgcolor());
        VipsUtils.setCssProperty(vipsBlock, BACKGROUNDCOLOR, browserAttributes.bgcolor);
        boolean isDisplayed = browserAttributes.isDisplayed() && browserAttributes.rectangle != null && browserAttributes.rectangle.height > 0 && browserAttributes.rectangle.width > 0;
        VipsUtils.setIsDisplayed(vipsBlock, isDisplayed ? "true" : "false");
        VipsUtils.setRectangle(vipsBlock, browserAttributes.rectangle);
        VipsUtils.setEventListeners(vipsBlock, browserAttributes.eventListeners);
    }

    public static void setEventListenerAttributes(Node vipsBlock, boolean hasEvent, String event) {
        if (!hasEvent) {
            Attr newAttr = vipsBlock.getOwnerDocument().createAttribute(EVLIST);
            newAttr.setNodeValue("false");
            vipsBlock.getAttributes().setNamedItem(newAttr);
            return;
        }
        Attr newAttr = vipsBlock.getOwnerDocument().createAttribute(EVLIST);
        newAttr.setNodeValue("true");
        vipsBlock.getAttributes().setNamedItem(newAttr);
        newAttr = vipsBlock.getOwnerDocument().createAttribute(EVLISTVAL);
        if (event != null) {
            event = event.replace("\n", "");
            event = event.replace("\r", "");
            event = event.replace("\"", "'");
        }
        newAttr.setNodeValue(event);
        vipsBlock.getAttributes().setNamedItem(newAttr);
    }

    public static boolean hasEventListener(Node vipsBlock) {
        String evList = VipsUtils.getVipsAttributeValue(vipsBlock, EVLIST);
        return evList.equalsIgnoreCase("true");
    }

    public static String getEventListenerVal(Node vipsBlock) {
        return VipsUtils.getVipsAttributeValue(vipsBlock, EVLISTVAL);
    }

    public static void setEventListeners(Node vipsBlock, String eventListeners) {
        if (eventListeners == null || eventListeners.trim().isEmpty()) {
            VipsUtils.setEventListenerAttributes(vipsBlock, false, null);
        } else {
            VipsUtils.setEventListenerAttributes(vipsBlock, true, eventListeners);
        }
    }

    public static boolean setFragParent(Node vipsBlock, int fragId) {
        if (vipsBlock == null || !vipsBlock.hasAttributes()) {
            return false;
        }
        if (vipsBlock.getAttributes().getNamedItem(FRAGPARENT) != null) {
            LOG.warn("Trying to reset the parent node for fragment {}", (Object)fragId);
            return false;
        }
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(FRAGPARENT);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(FRAGPARENT).setNodeValue(Integer.toString(fragId));
        return true;
    }

    public static int getFragParent(Node vipsBlock) {
        if (vipsBlock == null || !vipsBlock.hasAttributes() || vipsBlock.getAttributes().getNamedItem(FRAGPARENT) == null) {
            return -1;
        }
        if (vipsBlock.getAttributes().getNamedItem(FRAGPARENT) != null) {
            String propertyValue = vipsBlock.getAttributes().getNamedItem(FRAGPARENT).getNodeValue();
            return Integer.parseInt(propertyValue);
        }
        return -1;
    }

    public static boolean setDynamic(Node vipsBlock) {
        if (vipsBlock == null) {
            return false;
        }
        if (!vipsBlock.hasAttributes() && vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.setDynamic(vipsBlock.getParentNode());
        }
        if (vipsBlock.getAttributes().getNamedItem(DYNAMIC_FRAGMENT) != null) {
            return true;
        }
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(DYNAMIC_FRAGMENT);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        return true;
    }

    public static boolean isDynamic(Node vipsBlock) {
        return vipsBlock.getAttributes().getNamedItem(DYNAMIC_FRAGMENT) != null;
    }

    public static void removeVipsAttributes(Node node) {
        if (node != null && node.hasAttributes() && node.getAttributes() != null) {
            for (String attribute : VipsUtils.getVipsAttributes()) {
                try {
                    node.getAttributes().removeNamedItem(attribute);
                }
                catch (Exception ex) {
                    LOG.debug("No such attribute {}", (Object)attribute);
                }
            }
        }
        if (node != null && node.getChildNodes().getLength() > 0) {
            for (Node child : VipsUtils.getChildren(node)) {
                VipsUtils.removeVipsAttributes(child);
            }
        }
    }

    public static String removeVipsAttributes(String dom) throws IOException {
        Document doc = null;
        try {
            doc = DomUtils.asDocument(dom);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (doc == null) {
            return null;
        }
        VipsUtils.removeVipsAttributes(doc.getDocumentElement());
        return DomUtils.getDocumentToString(doc);
    }

    public static void setCoverage(Node vipsBlock, AccessType access, Coverage coverage) {
        switch (access) {
            case direct: {
                VipsUtils.setCoverage(vipsBlock, coverage, DIRACCESS);
                break;
            }
            case equivalent: {
                VipsUtils.setCoverage(vipsBlock, coverage, INDIRACCESS);
            }
            case any: {
                VipsUtils.setCoverage(vipsBlock, coverage, ANYACCESS);
                break;
            }
            case js: {
                VipsUtils.setCoverage(vipsBlock, coverage, JSOBSERVER);
                break;
            }
            case none: {
                break;
            }
        }
    }

    public static AccessType getAccessType(Node vipsBlock) {
        if (VipsUtils.getCoverage(vipsBlock, DIRACCESS) == Coverage.none) {
            if (VipsUtils.getCoverage(vipsBlock, INDIRACCESS) == Coverage.none) {
                if (VipsUtils.getCoverage(vipsBlock, JSOBSERVER) == Coverage.none) {
                    return AccessType.none;
                }
                return AccessType.js;
            }
            return AccessType.equivalent;
        }
        return AccessType.direct;
    }

    public static Coverage getCoverage(Node vipsBlock, AccessType access) {
        switch (access) {
            case direct: {
                return VipsUtils.getCoverage(vipsBlock, DIRACCESS);
            }
            case equivalent: {
                return VipsUtils.getCoverage(vipsBlock, INDIRACCESS);
            }
            case js: {
                return VipsUtils.getCoverage(vipsBlock, JSOBSERVER);
            }
            case any: {
                if (VipsUtils.getCoverage(vipsBlock, DIRACCESS) == Coverage.none) {
                    if (VipsUtils.getCoverage(vipsBlock, INDIRACCESS) == Coverage.none) {
                        return VipsUtils.getCoverage(vipsBlock, JSOBSERVER);
                    }
                    return VipsUtils.getCoverage(vipsBlock, INDIRACCESS);
                }
                return VipsUtils.getCoverage(vipsBlock, DIRACCESS);
            }
        }
        return Coverage.none;
    }

    private static void setCoverage(Node vipsBlock, Coverage coverage, String access) {
        if (VipsUtils.hasVipsAttribute(vipsBlock, access)) {
            switch (VipsUtils.getCoverage(vipsBlock, access)) {
                case action: {
                    return;
                }
            }
        }
        Attr newAttribute = vipsBlock.getOwnerDocument().createAttribute(access);
        vipsBlock.getAttributes().setNamedItem(newAttribute);
        vipsBlock.getAttributes().getNamedItem(access).setNodeValue(coverage.name());
    }

    private static Coverage getCoverage(Node vipsBlock, String access) {
        if (!VipsUtils.hasVipsAttribute(vipsBlock, access)) {
            VipsUtils.setCoverage(vipsBlock, Coverage.none, access);
            return Coverage.none;
        }
        String vipsAttr = VipsUtils.getVipsAttributeValue(vipsBlock, access);
        return VipsUtils.getCoverageTypeFromString(vipsAttr);
    }

    public static Coverage getCoverageTypeFromString(String vipsAttr) {
        if (vipsAttr == null) {
            return Coverage.none;
        }
        switch (vipsAttr) {
            case "action": {
                return Coverage.action;
            }
            case "assertion": {
                return Coverage.assertion;
            }
            case "find": {
                return Coverage.find;
            }
            case "implicit": {
                return Coverage.implicit;
            }
            case "characterData": {
                return Coverage.characterData;
            }
            case "subtree": {
                return Coverage.subtree;
            }
            case "childList": {
                return Coverage.childList;
            }
            case "attributes": {
                return Coverage.attributes;
            }
        }
        return Coverage.none;
    }

    public static boolean hasVipsAttribute(Node vipsBlock, String attr) {
        if (vipsBlock == null) {
            return false;
        }
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.hasVipsAttribute(vipsBlock.getParentNode(), attr);
        }
        if (vipsBlock.getAttributes() != null) {
            return vipsBlock.getAttributes().getNamedItem(attr) != null;
        }
        return false;
    }

    public static String getVipsAttributeValue(Node vipsBlock, String attr) {
        if (vipsBlock == null) {
            return null;
        }
        if (vipsBlock.getNodeName().equalsIgnoreCase("#text")) {
            return VipsUtils.getVipsAttributeValue(vipsBlock.getParentNode(), attr);
        }
        if (vipsBlock.getAttributes() != null && vipsBlock.getAttributes().getNamedItem(attr) != null) {
            return vipsBlock.getAttributes().getNamedItem(attr).getNodeValue();
        }
        return null;
    }

    public static enum AccessType {
        direct,
        equivalent,
        none,
        any,
        js;

    }

    public static enum Coverage {
        action,
        assertion,
        find,
        implicit,
        none,
        characterData,
        attributes,
        subtree,
        childList;

    }
}

