/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.Separator;
import com.crawljax.vips_selenium.VipsUtils;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.w3c.dom.Node;

public class VisualStructure {
    private List<Node> _nestedBlocks = null;
    private List<VisualStructure> _childrenVisualStructures = null;
    private List<Separator> _horizontalSeparators = null;
    private List<Separator> _verticalSeparators = null;
    private int _width = 0;
    private int _height = 0;
    private int _x = 0;
    private int _y = 0;
    private int _doC = 12;
    private int _containImg = -1;
    private int _containP = -1;
    private int _textLength = -1;
    private int _linkTextLength = -1;
    private int _order;
    private boolean _containTable = false;
    private String _id = null;
    private int _tmpSrcIndex = 0;
    private int _srcIndex = 0;
    private int _minimalDoC = 0;
    private WebDriver driver = null;

    public VisualStructure(WebDriver driver) {
        this.driver = driver;
        this._nestedBlocks = new ArrayList<Node>();
        this._childrenVisualStructures = new ArrayList<VisualStructure>();
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
    }

    public List<Node> getNestedBlocks() {
        return this._nestedBlocks;
    }

    public void setNestedBlocks(List<Node> vipsBlocks) {
        this._nestedBlocks = vipsBlocks;
    }

    public void addNestedBlock(Node nestedBlock) {
        this._nestedBlocks.add(nestedBlock);
    }

    public void addNestedBlocks(List<Node> nestedBlocks) {
        this._nestedBlocks.addAll(nestedBlocks);
    }

    public void clearNestedBlocks() {
        this._nestedBlocks.clear();
    }

    public void removeNestedBlockAt(int index) {
        this._nestedBlocks.remove(index);
    }

    public void removeChild(VisualStructure visualStructure) {
        this._childrenVisualStructures.remove(visualStructure);
    }

    public void addChild(VisualStructure visualStructure) {
        this._childrenVisualStructures.add(visualStructure);
    }

    public void addChildAt(VisualStructure visualStructure, int index) {
        this._childrenVisualStructures.add(index, visualStructure);
    }

    public List<VisualStructure> getChildrenVisualStructures() {
        return this._childrenVisualStructures;
    }

    public void setChildrenVisualStructures(List<VisualStructure> childrenVisualStructures) {
        this._childrenVisualStructures = childrenVisualStructures;
    }

    public List<Separator> getHorizontalSeparators() {
        return this._horizontalSeparators;
    }

    public void setHorizontalSeparators(List<Separator> horizontalSeparators) {
        this._horizontalSeparators = horizontalSeparators;
    }

    public void addHorizontalSeparator(Separator horizontalSeparator) {
        this._horizontalSeparators.add(horizontalSeparator);
    }

    public void addHorizontalSeparators(List<Separator> horizontalSeparators) {
        this._horizontalSeparators.addAll(horizontalSeparators);
    }

    public int getX() {
        return this._x;
    }

    public void setX(int x) {
        this._x = x;
    }

    public int getY() {
        return this._y;
    }

    public void setY(int y) {
        this._y = y;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public List<Separator> getVerticalSeparators() {
        return this._verticalSeparators;
    }

    public void setVerticalSeparators(List<Separator> _verticalSeparators) {
        this._verticalSeparators = _verticalSeparators;
    }

    public void addVerticalSeparator(Separator verticalSeparator) {
        this._verticalSeparators.add(verticalSeparator);
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public int getDoC() {
        return this._doC;
    }

    public void setDoC(int doC) {
        this._doC = doC;
    }

    private void findMinimalDoC(VisualStructure visualStructure) {
        if (!visualStructure.getId().equals("1") && visualStructure.getDoC() < this._minimalDoC) {
            this._minimalDoC = visualStructure.getDoC();
        }
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.findMinimalDoC(child);
        }
    }

    public void updateToNormalizedDoC() {
        this._doC = 12;
        for (Separator separator : this._horizontalSeparators) {
            if (separator.normalizedWeight >= this._doC) continue;
            this._doC = separator.normalizedWeight;
        }
        for (Separator separator : this._verticalSeparators) {
            if (separator.normalizedWeight >= this._doC) continue;
            this._doC = separator.normalizedWeight;
        }
        if (this._doC == 12) {
            for (Node nestedBlock : this._nestedBlocks) {
                if (VipsUtils.getDoC(nestedBlock) >= this._doC) continue;
                this._doC = VipsUtils.getDoC(nestedBlock);
            }
        }
        this._minimalDoC = 12;
        this.findMinimalDoC(this);
        if (this._minimalDoC < this._doC) {
            this._doC = this._minimalDoC;
        }
    }

    public int containImg() {
        if (this._containImg != -1) {
            return this._containImg;
        }
        this._containImg = 0;
        for (Node vipsBlock : this._nestedBlocks) {
            this._containImg += VipsUtils.getImageCount(vipsBlock);
        }
        return this._containImg;
    }

    public int containP() {
        if (this._containP != -1) {
            return this._containP;
        }
        this._containP = 0;
        for (Node vipsBlock : this._nestedBlocks) {
            this._containP += VipsUtils.getPCount(vipsBlock);
        }
        return this._containP;
    }

    public boolean containTable() {
        if (this._containTable) {
            return this._containTable;
        }
        for (Node vipsBlock : this._nestedBlocks) {
            if (!VipsUtils.containsTable(vipsBlock)) continue;
            this._containTable = true;
            break;
        }
        return this._containTable;
    }

    public boolean isImg() {
        if (this._nestedBlocks.size() != 1) {
            return false;
        }
        return VipsUtils.checkIsImg(this._nestedBlocks.get(0));
    }

    public int getTextLength() {
        if (this._textLength != -1) {
            return this._textLength;
        }
        this._textLength = 0;
        for (Node vipsBlock : this._nestedBlocks) {
            this._textLength += VipsUtils.getTextLength(vipsBlock);
        }
        return this._textLength;
    }

    public int getLinkTextLength() {
        if (this._linkTextLength != -1) {
            return this._linkTextLength;
        }
        this._linkTextLength = 0;
        for (Node vipsBlock : this._nestedBlocks) {
            this._linkTextLength += VipsUtils.getLinkTextLength(vipsBlock);
        }
        return this._linkTextLength;
    }

    public int getFontSize() {
        if (this._nestedBlocks.size() > 0) {
            return VipsUtils.getFontSize(this._nestedBlocks.get(0), this.driver);
        }
        return -1;
    }

    public String getFontWeight() {
        return "undef";
    }

    public String getBgColor() {
        return "undef";
    }

    public int getFrameSourceIndex() {
        if (this._nestedBlocks.size() > 0) {
            return -1;
        }
        return -1;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public void addVerticalSeparators(List<Separator> verticalSeparators) {
        this._verticalSeparators.addAll(verticalSeparators);
    }
}

