/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.Separator;
import com.crawljax.vips_selenium.VipsSeparatorDetector;
import com.crawljax.vips_selenium.VipsSeparatorGraphicsDetector;
import com.crawljax.vips_selenium.VipsSeparatorNonGraphicsDetector;
import com.crawljax.vips_selenium.VipsUtils;
import com.crawljax.vips_selenium.VisualStructure;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualStructureConstructor {
    private static int _maxDoC = 11;
    private Node _vipsBlocks = null;
    private List<Node> _visualBlocks = null;
    private VisualStructure _visualStructure = null;
    private List<Separator> _horizontalSeparators = null;
    private List<Separator> _verticalSeparators = null;
    private int _pageWidth = 0;
    private int _pageHeight = 0;
    private int _srcOrder = 1;
    private int _iteration = 0;
    private int _pDoC = 5;
    private int _minDoC = 11;
    private BufferedImage screenshot = null;
    private boolean _graphicsOutput = true;
    private WebDriver driver;

    public VisualStructureConstructor(WebDriver driver) {
        this.driver = driver;
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
    }

    public VisualStructureConstructor(int pDoC, BufferedImage screenshot, WebDriver driver) {
        this.screenshot = screenshot;
        this.driver = driver;
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
        this.setPDoC(pDoC);
    }

    public VisualStructureConstructor(Node vipsBlocks, WebDriver driver) {
        this.driver = driver;
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
        this._vipsBlocks = vipsBlocks;
    }

    public VisualStructureConstructor(Node vipsBlocks, int pDoC, WebDriver driver) {
        this.driver = driver;
        this._horizontalSeparators = new ArrayList<Separator>();
        this._verticalSeparators = new ArrayList<Separator>();
        this._vipsBlocks = vipsBlocks;
        this.setPDoC(pDoC);
    }

    public void setPDoC(int pDoC) {
        if (pDoC <= 0 || pDoC > 11) {
            System.err.println("pDoC value must be between 1 and 11! Not " + pDoC + "!");
            return;
        }
        this._pDoC = pDoC;
    }

    public void setGraphicsOutput(boolean enabled) {
        this._graphicsOutput = enabled;
    }

    public void constructVisualStructure() {
        ++this._iteration;
        if (this._iteration < 4) {
            this.constructVerticalVisualStructure();
            this.constructHorizontalVisualStructure();
            this.constructVerticalVisualStructure();
            this.constructHorizontalVisualStructure();
        } else {
            this.constructHorizontalVisualStructure();
            this.constructVerticalVisualStructure();
        }
        if (this._iteration != 1) {
            this.updateSeparators();
        }
        this._srcOrder = 1;
        this.setOrder(this._visualStructure);
        if (this._graphicsOutput) {
            this.exportSeparators();
        }
    }

    private void constructHorizontalVisualStructure() {
        if (this._visualStructure == null) {
            VipsSeparatorDetector detector = null;
            detector = this._graphicsOutput ? new VipsSeparatorGraphicsDetector(this.screenshot, this.driver) : new VipsSeparatorNonGraphicsDetector(this._pageWidth, this._pageHeight, this.driver);
            detector.setCleanUpSeparators(3);
            detector.setVipsBlock(this._vipsBlocks);
            detector.setVisualBlocks(this._visualBlocks);
            detector.detectHorizontalSeparators();
            this._horizontalSeparators = detector.getHorizontalSeparators();
            Collections.sort(this._horizontalSeparators);
            this._visualStructure = new VisualStructure(this.driver);
            this._visualStructure.setId("1");
            this._visualStructure.setNestedBlocks(this._visualBlocks);
            this._visualStructure.setWidth(this._pageWidth);
            this._visualStructure.setHeight(this._pageHeight);
            for (Separator separator : this._horizontalSeparators) {
                separator.setLeftUp(this._visualStructure.getX(), separator.startPoint);
                separator.setRightDown(this._visualStructure.getX() + this._visualStructure.getWidth(), separator.endPoint);
            }
            this.constructWithHorizontalSeparators(this._visualStructure);
        } else {
            ArrayList<VisualStructure> listStructures = new ArrayList<VisualStructure>();
            this.findListVisualStructures(this._visualStructure, listStructures);
            for (VisualStructure childVisualStructure : listStructures) {
                VipsSeparatorDetector detector = null;
                detector = this._graphicsOutput ? new VipsSeparatorGraphicsDetector(this.screenshot, this.driver) : new VipsSeparatorNonGraphicsDetector(this._pageWidth, this._pageHeight, this.driver);
                detector.setCleanUpSeparators(4);
                detector.setVipsBlock(this._vipsBlocks);
                detector.setVisualBlocks(childVisualStructure.getNestedBlocks());
                detector.detectHorizontalSeparators();
                this._horizontalSeparators = detector.getHorizontalSeparators();
                for (Separator separator : this._horizontalSeparators) {
                    separator.setLeftUp(childVisualStructure.getX(), separator.startPoint);
                    separator.setRightDown(childVisualStructure.getX() + childVisualStructure.getWidth(), separator.endPoint);
                }
                this.constructWithHorizontalSeparators(childVisualStructure);
            }
        }
    }

    private void constructVerticalVisualStructure() {
        if (this._visualStructure == null) {
            VipsSeparatorDetector detector = null;
            detector = this._graphicsOutput ? new VipsSeparatorGraphicsDetector(this.screenshot, this.driver) : new VipsSeparatorNonGraphicsDetector(this._pageWidth, this._pageHeight, this.driver);
            detector.setCleanUpSeparators(3);
            detector.setVipsBlock(this._vipsBlocks);
            detector.setVisualBlocks(this._visualBlocks);
            detector.detectVerticalSeparators();
            this._verticalSeparators = detector.getVerticalSeparators();
            Collections.sort(this._verticalSeparators);
            this._visualStructure = new VisualStructure(this.driver);
            this._visualStructure.setId("1");
            this._visualStructure.setNestedBlocks(this._visualBlocks);
            this._visualStructure.setWidth(this._pageWidth);
            this._visualStructure.setHeight(this._pageHeight);
            for (Separator separator : this._verticalSeparators) {
                separator.setLeftUp(separator.startPoint, this._visualStructure.getY());
                separator.setRightDown(separator.endPoint, this._visualStructure.getY() + this._visualStructure.getHeight());
            }
            this.constructWithVerticalSeparators(this._visualStructure);
        } else {
            ArrayList<VisualStructure> listStructures = new ArrayList<VisualStructure>();
            this.findListVisualStructures(this._visualStructure, listStructures);
            for (VisualStructure childVisualStructure : listStructures) {
                VipsSeparatorDetector detector = null;
                detector = this._graphicsOutput ? new VipsSeparatorGraphicsDetector(this.screenshot, this.driver) : new VipsSeparatorNonGraphicsDetector(this._pageWidth, this._pageHeight, this.driver);
                detector.setCleanUpSeparators(4);
                detector.setVipsBlock(this._vipsBlocks);
                detector.setVisualBlocks(childVisualStructure.getNestedBlocks());
                detector.detectVerticalSeparators();
                this._verticalSeparators = detector.getVerticalSeparators();
                for (Separator separator : this._verticalSeparators) {
                    separator.setLeftUp(separator.startPoint, childVisualStructure.getY());
                    separator.setRightDown(separator.endPoint, childVisualStructure.getY() + childVisualStructure.getHeight());
                }
                this.constructWithVerticalSeparators(childVisualStructure);
            }
        }
    }

    private void constructWithHorizontalSeparators(VisualStructure actualStructure) {
        if (actualStructure.getNestedBlocks().size() == 0 || this._horizontalSeparators.size() == 0) {
            return;
        }
        VisualStructure topVisualStructure = null;
        VisualStructure bottomVisualStructure = null;
        List<Node> nestedBlocks = null;
        for (Separator separator : this._horizontalSeparators) {
            if (actualStructure.getChildrenVisualStructures().size() == 0) {
                topVisualStructure = new VisualStructure(this.driver);
                topVisualStructure.setX(actualStructure.getX());
                topVisualStructure.setY(actualStructure.getY());
                topVisualStructure.setHeight(separator.startPoint - 1 - actualStructure.getY());
                topVisualStructure.setWidth(actualStructure.getWidth());
                actualStructure.addChild(topVisualStructure);
                bottomVisualStructure = new VisualStructure(this.driver);
                bottomVisualStructure.setX(actualStructure.getX());
                bottomVisualStructure.setY(separator.endPoint + 1);
                bottomVisualStructure.setHeight(actualStructure.getHeight() + actualStructure.getY() - separator.endPoint - 1);
                bottomVisualStructure.setWidth(actualStructure.getWidth());
                actualStructure.addChild(bottomVisualStructure);
                nestedBlocks = actualStructure.getNestedBlocks();
            } else {
                Object oldStructure = null;
                for (VisualStructure childVisualStructure : actualStructure.getChildrenVisualStructures()) {
                    if (separator.startPoint < childVisualStructure.getY() || separator.endPoint > childVisualStructure.getY() + childVisualStructure.getHeight()) continue;
                    topVisualStructure = new VisualStructure(this.driver);
                    topVisualStructure.setX(childVisualStructure.getX());
                    topVisualStructure.setY(childVisualStructure.getY());
                    topVisualStructure.setHeight(separator.startPoint - 1 - childVisualStructure.getY());
                    topVisualStructure.setWidth(childVisualStructure.getWidth());
                    int index = actualStructure.getChildrenVisualStructures().indexOf(childVisualStructure);
                    actualStructure.addChildAt(topVisualStructure, index);
                    bottomVisualStructure = new VisualStructure(this.driver);
                    bottomVisualStructure.setX(childVisualStructure.getX());
                    bottomVisualStructure.setY(separator.endPoint + 1);
                    int height = childVisualStructure.getHeight() + childVisualStructure.getY() - separator.endPoint - 1;
                    bottomVisualStructure.setHeight(height);
                    bottomVisualStructure.setWidth(childVisualStructure.getWidth());
                    actualStructure.addChildAt(bottomVisualStructure, index + 1);
                    oldStructure = childVisualStructure;
                    break;
                }
                if (oldStructure != null) {
                    nestedBlocks = ((VisualStructure)oldStructure).getNestedBlocks();
                    actualStructure.getChildrenVisualStructures().remove(oldStructure);
                }
            }
            if (topVisualStructure == null || bottomVisualStructure == null) {
                return;
            }
            for (Node vipsBlock : nestedBlocks) {
                Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
                if (rect.y <= separator.startPoint) {
                    topVisualStructure.addNestedBlock(vipsBlock);
                    continue;
                }
                bottomVisualStructure.addNestedBlock(vipsBlock);
            }
            topVisualStructure = null;
            bottomVisualStructure = null;
        }
        int iterator = 1;
        for (VisualStructure visualStructure : actualStructure.getChildrenVisualStructures()) {
            visualStructure.setId(actualStructure.getId() + "-" + iterator);
            ++iterator;
        }
        ArrayList<Separator> arrayList = new ArrayList<Separator>();
        arrayList.addAll(this._horizontalSeparators);
        for (VisualStructure vs : actualStructure.getChildrenVisualStructures()) {
            vs.getHorizontalSeparators().clear();
        }
        actualStructure.addHorizontalSeparators(this._horizontalSeparators);
    }

    private void constructWithVerticalSeparators(VisualStructure actualStructure) {
        if (actualStructure.getNestedBlocks().size() == 0 || this._verticalSeparators.size() == 0) {
            return;
        }
        VisualStructure leftVisualStructure = null;
        VisualStructure rightVisualStructure = null;
        List<Node> nestedBlocks = null;
        for (Separator separator : this._verticalSeparators) {
            if (actualStructure.getChildrenVisualStructures().size() == 0) {
                leftVisualStructure = new VisualStructure(this.driver);
                leftVisualStructure.setX(actualStructure.getX());
                leftVisualStructure.setY(actualStructure.getY());
                leftVisualStructure.setHeight(actualStructure.getHeight());
                leftVisualStructure.setWidth(separator.startPoint - 1 - actualStructure.getX());
                actualStructure.addChild(leftVisualStructure);
                rightVisualStructure = new VisualStructure(this.driver);
                rightVisualStructure.setX(separator.endPoint + 1);
                rightVisualStructure.setY(actualStructure.getY());
                rightVisualStructure.setHeight(actualStructure.getHeight());
                rightVisualStructure.setWidth(actualStructure.getWidth() + actualStructure.getX() - separator.endPoint - 1);
                actualStructure.addChild(rightVisualStructure);
                nestedBlocks = actualStructure.getNestedBlocks();
            } else {
                Object oldStructure = null;
                for (VisualStructure childVisualStructure : actualStructure.getChildrenVisualStructures()) {
                    if (separator.startPoint < childVisualStructure.getX() || separator.endPoint > childVisualStructure.getX() + childVisualStructure.getWidth()) continue;
                    leftVisualStructure = new VisualStructure(this.driver);
                    leftVisualStructure.setX(childVisualStructure.getX());
                    leftVisualStructure.setY(childVisualStructure.getY());
                    leftVisualStructure.setHeight(childVisualStructure.getHeight());
                    leftVisualStructure.setWidth(separator.startPoint - 1 - childVisualStructure.getX());
                    int index = actualStructure.getChildrenVisualStructures().indexOf(childVisualStructure);
                    actualStructure.addChildAt(leftVisualStructure, index);
                    rightVisualStructure = new VisualStructure(this.driver);
                    rightVisualStructure.setX(separator.endPoint + 1);
                    rightVisualStructure.setY(childVisualStructure.getY());
                    rightVisualStructure.setHeight(childVisualStructure.getHeight());
                    int width = childVisualStructure.getWidth() + childVisualStructure.getX() - separator.endPoint - 1;
                    rightVisualStructure.setWidth(width);
                    actualStructure.addChildAt(rightVisualStructure, index + 1);
                    oldStructure = childVisualStructure;
                    break;
                }
                if (oldStructure != null) {
                    nestedBlocks = ((VisualStructure)oldStructure).getNestedBlocks();
                    actualStructure.getChildrenVisualStructures().remove(oldStructure);
                }
            }
            if (leftVisualStructure == null || rightVisualStructure == null) {
                return;
            }
            for (Node vipsBlock : nestedBlocks) {
                Rectangle rect = VipsUtils.getRectangle(vipsBlock, this.driver);
                if (rect.x <= separator.startPoint) {
                    leftVisualStructure.addNestedBlock(vipsBlock);
                    continue;
                }
                rightVisualStructure.addNestedBlock(vipsBlock);
            }
            leftVisualStructure = null;
            rightVisualStructure = null;
        }
        int iterator = 1;
        for (VisualStructure visualStructure : actualStructure.getChildrenVisualStructures()) {
            visualStructure.setId(actualStructure.getId() + "-" + iterator);
            ++iterator;
        }
        ArrayList<Separator> arrayList = new ArrayList<Separator>();
        arrayList.addAll(this._verticalSeparators);
        for (VisualStructure vs : actualStructure.getChildrenVisualStructures()) {
            vs.getVerticalSeparators().clear();
        }
        actualStructure.addVerticalSeparators(this._verticalSeparators);
    }

    private void exportSeparators() {
        VipsSeparatorGraphicsDetector detector = new VipsSeparatorGraphicsDetector(this.screenshot, this.driver);
        ArrayList<Separator> allSeparators = new ArrayList<Separator>();
        this.getAllHorizontalSeparators(this._visualStructure, allSeparators);
        Collections.sort(allSeparators);
        detector.setHorizontalSeparators(allSeparators);
        detector.exportHorizontalSeparatorsToImage(this._iteration);
        allSeparators.clear();
        this.getAllVerticalSeparators(this._visualStructure, allSeparators);
        Collections.sort(allSeparators);
        detector.setVerticalSeparators(allSeparators);
        detector.exportVerticalSeparatorsToImage(this._iteration);
        detector.setVisualBlocks(this._visualBlocks);
        detector.exportAllToImage(this._iteration);
    }

    public void setPageSize(int width, int height) {
        this._pageHeight = height;
        this._pageWidth = width;
    }

    public Node getVipsBlocks() {
        return this._vipsBlocks;
    }

    public void setVipsBlocks(Node vipsBlocks) {
        this._vipsBlocks = vipsBlocks;
        this._visualBlocks = new ArrayList<Node>();
        this.findVisualBlocks(vipsBlocks, this._visualBlocks);
    }

    public VisualStructure getVisualStructure() {
        return this._visualStructure;
    }

    private void findVisualBlocks(Node vipsBlock, List<Node> results) {
        if (VipsUtils.isVisualBlock(vipsBlock)) {
            results.add(vipsBlock);
        }
        NodeList children = vipsBlock.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.findVisualBlocks(child, results);
        }
    }

    public List<Node> getVisualBlocks() {
        return this._visualBlocks;
    }

    public List<Separator> getHorizontalSeparators() {
        return this._horizontalSeparators;
    }

    public void setHorizontalSeparator(List<Separator> horizontalSeparators) {
        this._horizontalSeparators = horizontalSeparators;
    }

    public List<Separator> getVerticalSeparators() {
        return this._verticalSeparators;
    }

    public void setVerticalSeparator(List<Separator> verticalSeparators) {
        this._verticalSeparators = verticalSeparators;
    }

    public void setSeparators(List<Separator> horizontalSeparators, List<Separator> verticalSeparators) {
        this._verticalSeparators = verticalSeparators;
        this._horizontalSeparators = horizontalSeparators;
    }

    private void findListVisualStructures(VisualStructure visualStructure, List<VisualStructure> results) {
        if (visualStructure.getChildrenVisualStructures().size() == 0) {
            results.add(visualStructure);
        }
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.findListVisualStructures(child, results);
        }
    }

    private void replaceBlocksInPredecessors(List<Node> oldBlocks, List<Node> newBlocks, VisualStructure actualStructure, List<String> pathStructures) {
        for (VisualStructure child : actualStructure.getChildrenVisualStructures()) {
            this.replaceBlocksInPredecessors(oldBlocks, newBlocks, child, pathStructures);
        }
        for (String structureId : pathStructures) {
            if (!actualStructure.getId().equals(structureId)) continue;
            ArrayList<Node> tempBlocks = new ArrayList<Node>();
            tempBlocks.addAll(actualStructure.getNestedBlocks());
            for (Node block : tempBlocks) {
                for (Node oldBlock : oldBlocks) {
                    if (!block.equals(oldBlock)) continue;
                    actualStructure.getNestedBlocks().remove(block);
                }
            }
            actualStructure.addNestedBlocks(newBlocks);
        }
    }

    private List<String> generatePathStructures(String path) {
        ArrayList<String> pathStructures = new ArrayList<String>();
        String[] aaa = path.split("-");
        Object tmp = "";
        for (int i = 0; i < aaa.length - 1; ++i) {
            tmp = (String)tmp + aaa[i];
            pathStructures.add((String)tmp);
            tmp = (String)tmp + "-";
        }
        return pathStructures;
    }

    public void updateVipsBlocks(Node vipsBlocks) {
        this.setVipsBlocks(vipsBlocks);
        ArrayList<VisualStructure> listsVisualStructures = new ArrayList<VisualStructure>();
        ArrayList<Node> oldNestedBlocks = new ArrayList<Node>();
        this.findListVisualStructures(this._visualStructure, listsVisualStructures);
        for (VisualStructure visualStructure : listsVisualStructures) {
            oldNestedBlocks.addAll(visualStructure.getNestedBlocks());
            visualStructure.clearNestedBlocks();
            for (Node visualBlock : this._visualBlocks) {
                Rectangle rect = VipsUtils.getRectangle(visualBlock, this.driver);
                if (rect.x < visualStructure.getX() || rect.x > visualStructure.getX() + visualStructure.getWidth() || rect.y < visualStructure.getY() || rect.y > visualStructure.getY() + visualStructure.getHeight() || rect.height == 0 || rect.width == 0) continue;
                visualStructure.addNestedBlock(visualBlock);
            }
            if (visualStructure.getNestedBlocks().size() == 0) {
                visualStructure.addNestedBlocks(oldNestedBlocks);
                this._visualBlocks.addAll(oldNestedBlocks);
            }
            String path = visualStructure.getId();
            List<String> pathStructures = this.generatePathStructures(path);
            this.replaceBlocksInPredecessors(oldNestedBlocks, visualStructure.getNestedBlocks(), this._visualStructure, pathStructures);
            oldNestedBlocks.clear();
        }
    }

    private void setOrder(VisualStructure visualStructure) {
        visualStructure.setOrder(this._srcOrder);
        ++this._srcOrder;
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.setOrder(child);
        }
    }

    private void getAllSeparators(VisualStructure visualStructure, List<Separator> result) {
        this.findAllHorizontalSeparators(visualStructure, result);
        this.findAllVerticalSeparators(visualStructure, result);
        this.removeDuplicates(result);
    }

    private void getAllHorizontalSeparators(VisualStructure visualStructure, List<Separator> result) {
        this.findAllHorizontalSeparators(visualStructure, result);
        this.removeDuplicates(result);
    }

    private void getAllVerticalSeparators(VisualStructure visualStructure, List<Separator> result) {
        this.findAllVerticalSeparators(visualStructure, result);
        this.removeDuplicates(result);
    }

    private void findAllHorizontalSeparators(VisualStructure visualStructure, List<Separator> result) {
        result.addAll(visualStructure.getHorizontalSeparators());
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.findAllHorizontalSeparators(child, result);
        }
    }

    private void findAllVerticalSeparators(VisualStructure visualStructure, List<Separator> result) {
        result.addAll(visualStructure.getVerticalSeparators());
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.findAllVerticalSeparators(child, result);
        }
    }

    private void updateSeparatorsInStructure(VisualStructure visualStructure) {
        ArrayList<Node> adjacentBlocks = new ArrayList<Node>();
        ArrayList<Separator> allSeparators = new ArrayList<Separator>();
        allSeparators.addAll(visualStructure.getHorizontalSeparators());
        block0: for (Separator separator : allSeparators) {
            int aboveBottom = 0;
            int belowTop = this._pageHeight;
            Object above = null;
            Node below = null;
            adjacentBlocks.clear();
            for (Node block : visualStructure.getNestedBlocks()) {
                Rectangle rect = VipsUtils.getRectangle(block, this.driver);
                int top = rect.y;
                int bottom = rect.y + rect.height;
                if (bottom <= separator.startPoint && bottom > aboveBottom) {
                    aboveBottom = bottom;
                    above = block;
                }
                if (top < separator.endPoint || top >= belowTop) continue;
                belowTop = top;
                below = block;
                adjacentBlocks.add(block);
            }
            if (above == null || below == null) continue;
            adjacentBlocks.add((Node)above);
            adjacentBlocks.add(below);
            if (aboveBottom == separator.startPoint - 1 && belowTop == separator.endPoint + 1 || adjacentBlocks.size() < 2) continue;
            VipsSeparatorDetector detector = null;
            detector = this._graphicsOutput ? new VipsSeparatorGraphicsDetector(this.screenshot, this.driver) : new VipsSeparatorNonGraphicsDetector(this._pageWidth, this._pageHeight, this.driver);
            detector.setCleanUpSeparators(3);
            if (this._iteration > 3) {
                detector.setCleanUpSeparators(6);
            }
            detector.setVisualBlocks(adjacentBlocks);
            detector.detectHorizontalSeparators();
            ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
            tempSeparators.addAll(visualStructure.getHorizontalSeparators());
            if (detector.getHorizontalSeparators().size() == 0) continue;
            Separator newSeparator = detector.getHorizontalSeparators().get(0);
            newSeparator.setLeftUp(visualStructure.getX(), newSeparator.startPoint);
            newSeparator.setRightDown(visualStructure.getX() + visualStructure.getWidth(), newSeparator.endPoint);
            for (Separator other : tempSeparators) {
                if (!other.equals(separator)) continue;
                visualStructure.getHorizontalSeparators().add(visualStructure.getHorizontalSeparators().indexOf(other) + 1, newSeparator);
                visualStructure.getHorizontalSeparators().remove(other);
                continue block0;
            }
        }
        block3: for (Separator separator : allSeparators) {
            int blockTop = this._pageHeight;
            int blockDown = 0;
            adjacentBlocks.clear();
            for (Node block : visualStructure.getNestedBlocks()) {
                Rectangle rect = VipsUtils.getRectangle(block, this.driver);
                int top = rect.y;
                int bottom = rect.y + rect.height;
                if (top <= separator.startPoint || bottom >= separator.endPoint) continue;
                adjacentBlocks.add(block);
                if (top < blockTop) {
                    blockTop = top;
                }
                if (bottom <= blockDown) continue;
                blockDown = bottom;
            }
            if (adjacentBlocks.size() == 0) continue;
            VipsSeparatorDetector detector = null;
            detector = this._graphicsOutput ? new VipsSeparatorGraphicsDetector(this.screenshot, this.driver) : new VipsSeparatorNonGraphicsDetector(this._pageWidth, this._pageHeight, this.driver);
            detector.setCleanUpSeparators(3);
            if (this._iteration > 3) {
                detector.setCleanUpSeparators(6);
            }
            detector.setVisualBlocks(adjacentBlocks);
            detector.detectHorizontalSeparators();
            ArrayList<Separator> tempSeparators = new ArrayList<Separator>();
            tempSeparators.addAll(visualStructure.getHorizontalSeparators());
            ArrayList<Separator> newSeparators = new ArrayList<Separator>();
            Separator newSeparatorTop = new Separator(separator.startPoint, blockTop - 1, separator.weight);
            newSeparatorTop.setLeftUp(visualStructure.getX(), newSeparatorTop.startPoint);
            newSeparatorTop.setRightDown(visualStructure.getX() + visualStructure.getWidth(), newSeparatorTop.endPoint);
            newSeparators.add(newSeparatorTop);
            Separator newSeparatorBottom = new Separator(blockDown + 1, separator.endPoint, separator.weight);
            newSeparatorBottom.setLeftUp(visualStructure.getX(), newSeparatorBottom.startPoint);
            newSeparatorBottom.setRightDown(visualStructure.getX() + visualStructure.getWidth(), newSeparatorBottom.endPoint);
            if (detector.getHorizontalSeparators().size() != 0) {
                newSeparators.addAll(detector.getHorizontalSeparators());
            }
            newSeparators.add(newSeparatorBottom);
            for (Separator other : tempSeparators) {
                if (!other.equals(separator)) continue;
                visualStructure.getHorizontalSeparators().addAll(visualStructure.getHorizontalSeparators().indexOf(other) + 1, newSeparators);
                visualStructure.getHorizontalSeparators().remove(other);
                continue block3;
            }
        }
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.updateSeparatorsInStructure(child);
        }
    }

    private void updateSeparators() {
        this.updateSeparatorsInStructure(this._visualStructure);
    }

    private void removeDuplicates(List<Separator> separators) {
        HashSet<Separator> hashSet = new HashSet<Separator>(separators);
        separators.clear();
        separators.addAll(hashSet);
    }

    private int getDoCValue(int value) {
        if (value == 0) {
            return _maxDoC;
        }
        return _maxDoC + 1 - value;
    }

    public void normalizeSeparatorsSoftMax() {
        ArrayList<Separator> separators = new ArrayList<Separator>();
        this.getAllSeparators(this._visualStructure, separators);
        Collections.sort(separators);
        double stdev = this.getStdDeviation(separators);
        double meanValue = 0.0;
        double lambda = 3.0;
        double alpha = 1.0;
        for (Separator separator : separators) {
            meanValue += (double)separator.weight;
        }
        meanValue /= (double)separators.size();
        for (Separator separator : separators) {
            double normalizedValue = ((double)separator.weight - meanValue) / (lambda * (stdev / (Math.PI * 2)));
            normalizedValue = 1.0 / (1.0 + Math.exp(-alpha * normalizedValue) + 1.0);
            normalizedValue = normalizedValue * 10.0 + 1.0;
            separator.normalizedWeight = this.getDoCValue((int)Math.round(normalizedValue));
            if (separator.weight != 3) continue;
            separator.normalizedWeight = 11;
        }
        this.updateDoC(this._visualStructure);
        this._visualStructure.setDoC(1);
    }

    public void normalizeSeparatorsMinMax() {
        ArrayList<Separator> separators = new ArrayList<Separator>();
        this.getAllSeparators(this._visualStructure, separators);
        Separator maxSep = new Separator(0, this._pageHeight);
        separators.add(maxSep);
        maxSep.weight = 40;
        Collections.sort(separators);
        double minWeight = ((Separator)separators.get((int)0)).weight;
        double maxWeight = ((Separator)separators.get((int)(separators.size() - 1))).weight;
        for (Separator separator : separators) {
            double normalizedValue = ((double)separator.weight - minWeight) / (maxWeight - minWeight) * 10.0 + 1.0;
            separator.normalizedWeight = this.getDoCValue((int)Math.ceil(normalizedValue));
        }
        this.updateDoC(this._visualStructure);
        this._visualStructure.setDoC(1);
    }

    private void updateDoC(VisualStructure visualStructure) {
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.updateDoC(child);
        }
        visualStructure.updateToNormalizedDoC();
    }

    private void findMinimalDoC(VisualStructure visualStructure) {
        if (!visualStructure.getId().equals("1") && visualStructure.getDoC() < this._minDoC) {
            this._minDoC = visualStructure.getDoC();
        }
        for (VisualStructure child : visualStructure.getChildrenVisualStructures()) {
            this.findMinimalDoC(child);
        }
    }

    public int getMinimalDoC() {
        this._minDoC = 11;
        this.findMinimalDoC(this._visualStructure);
        return this._minDoC;
    }

    public boolean continueInSegmentation() {
        this.getMinimalDoC();
        return this._pDoC >= this._minDoC;
    }

    private double getStdDeviation(List<Separator> separators) {
        double meanValue = 0.0;
        double stddev = 0.0;
        ArrayList<Double> deviations = new ArrayList<Double>();
        ArrayList<Double> squaredDeviations = new ArrayList<Double>();
        double sum = 0.0;
        for (Separator separator : separators) {
            meanValue += (double)separator.weight;
        }
        meanValue /= (double)separators.size();
        for (Separator separator : separators) {
            deviations.add((double)separator.weight - meanValue);
        }
        for (Double deviation : deviations) {
            squaredDeviations.add(deviation * deviation);
        }
        for (Double squaredDeviation : squaredDeviations) {
            sum += squaredDeviation.doubleValue();
        }
        stddev = Math.sqrt(sum / (double)squaredDeviations.size());
        return stddev;
    }
}

