/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.vips_selenium;

import com.crawljax.vips_selenium.DomUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathHelper {
    private static final String SKEL_XPATH_CACHE = "SKEL_XPATH_CACHE";

    public static String getXPathExpression(Node node) {
        return XPathHelper.getSkeletonXpath(node);
    }

    public static String getSkeletonXpath(Node node) {
        if (node == null) {
            return null;
        }
        Object xpathCache = node.getUserData(SKEL_XPATH_CACHE);
        if (xpathCache != null) {
            return xpathCache.toString();
        }
        Node parent = node.getParentNode();
        if (parent == null || parent.getNodeName().contains("#document")) {
            String xPath = "/" + node.getNodeName() + "[1]";
            node.setUserData(SKEL_XPATH_CACHE, xPath, null);
            return xPath;
        }
        StringBuilder buffer = new StringBuilder();
        if (parent != node) {
            buffer.append(XPathHelper.getSkeletonXpath(parent));
            buffer.append("/");
        }
        buffer.append(node.getNodeName());
        List<Node> mySiblings = XPathHelper.getSiblings(parent, node);
        for (int i = 0; i < mySiblings.size(); ++i) {
            Node el = mySiblings.get(i);
            if (!el.equals(node)) continue;
            buffer.append('[').append(Integer.toString(i + 1)).append(']');
            break;
        }
        String xPath = buffer.toString();
        node.setUserData(SKEL_XPATH_CACHE, xPath, null);
        return xPath;
    }

    public static List<Node> getSiblings(Node parent, Node element) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node el = list.item(i);
            if (!el.getNodeName().equals(element.getNodeName())) continue;
            result.add(el);
        }
        return result;
    }

    public static NodeList evaluateXpathExpression(String domStr, String xpathExpr) throws XPathExpressionException, IOException {
        Document dom = DomUtils.asDocument(domStr);
        return XPathHelper.evaluateXpathExpression(dom, xpathExpr);
    }

    public static NodeList evaluateXpathExpression(Document dom, String xpathExpr) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpr);
        Object result = expr.evaluate(dom, XPathConstants.NODESET);
        return (NodeList)result;
    }
}

