/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.cli;

import ch.qos.logback.classic.Level;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.cli.LogUtil;
import com.crawljax.cli.ParameterInterpeter;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.CrawljaxRunner;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.plugins.crawloverview.CrawlOverview;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.ParseException;

public class JarRunner {
    static final String MISSING_ARGUMENT_MESSAGE = "Missing required argument URL and/or output folder.";
    private final ParameterInterpeter options;
    private final CrawljaxConfiguration config;

    @VisibleForTesting
    JarRunner(String[] args) {
        try {
            this.options = new ParameterInterpeter(args);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (this.options.requestsVersion()) {
            System.out.println(this.getCrawljaxVersion());
            this.config = null;
        } else if (this.options.necessaryArgsProvided()) {
            String url = this.options.getUrl();
            String outputDir = this.options.getOutputDir();
            this.configureLogging();
            this.config = this.readConfig(url, outputDir);
        } else {
            if (!this.options.requestsHelp()) {
                System.out.println(MISSING_ARGUMENT_MESSAGE);
            }
            this.options.printHelp();
            this.config = null;
        }
    }

    public static void main(String[] args) {
        try {
            JarRunner runner = new JarRunner(args);
            runner.runIfConfigured();
        }
        catch (NumberFormatException e) {
            System.err.println("Could not parse number " + e.getMessage());
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private String getCrawljaxVersion() {
        try {
            return Resources.toString(JarRunner.class.getResource("/project.version"), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new CrawljaxException(e.getMessage(), e);
        }
    }

    private void configureLogging() {
        if (this.options.requestsVerbosity()) {
            LogUtil.setCrawljaxLogLevel(Level.INFO);
        }
        if (this.options.specifiesLogFile()) {
            File f = new File(this.options.getSpecifiedLogFile());
            try {
                if (!f.exists()) {
                    Files.createParentDirs(f);
                    Files.touch(f);
                }
            }
            catch (IOException e) {
                throw new CrawljaxException("Could not create log file: " + e.getMessage(), e);
            }
            Preconditions.checkArgument(f.canWrite());
            LogUtil.logToFile(f.getPath());
        }
    }

    private CrawljaxConfiguration readConfig(String urlValue, String outputDir) {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor(urlValue);
        builder.setOutputDirectory(new File(outputDir));
        EmbeddedBrowser.BrowserType browser = EmbeddedBrowser.BrowserType.CHROME;
        if (this.options.specifiesBrowser()) {
            browser = this.options.getSpecifiedBrowser();
        }
        int browsers = 1;
        if (this.options.specifiesParallelBrowsers()) {
            browsers = this.options.getSpecifiedNumberOfBrowsers();
        }
        if (browser == EmbeddedBrowser.BrowserType.REMOTE) {
            String remoteUrl = this.options.getSpecifiedRemoteBrowser();
            builder.setBrowserConfig(BrowserConfiguration.remoteConfig(browsers, remoteUrl));
        } else {
            builder.setBrowserConfig(new BrowserConfiguration(browser, browsers));
        }
        if (this.options.specifiesDepth()) {
            builder.setMaximumDepth(this.options.getSpecifiedDepth());
        }
        if (this.options.specifiesMaxStates()) {
            builder.setMaximumStates(this.options.getMaxStates());
        }
        if (this.options.requestsCrawlHiddenAnchors()) {
            builder.crawlRules().crawlHiddenAnchors(true);
        }
        this.configureTimers(builder);
        builder.addPlugin(new CrawlOverview());
        if (this.options.specifiesClickElements()) {
            builder.crawlRules().click(this.options.getSpecifiedClickElements());
        } else {
            builder.crawlRules().clickDefaultElements();
        }
        return builder.build();
    }

    private void configureTimers(CrawljaxConfiguration.CrawljaxConfigurationBuilder builder) {
        if (this.options.specifiesTimeOut()) {
            builder.setMaximumRunTime(this.options.getSpecifiedTimeOut(), TimeUnit.MINUTES);
        }
        if (this.options.specifiesWaitAfterEvent()) {
            builder.crawlRules().waitAfterEvent(this.options.getSpecifiedWaitAfterEvent(), TimeUnit.MILLISECONDS);
        }
        if (this.options.specifiesWaitAfterReload()) {
            builder.crawlRules().waitAfterReloadUrl(this.options.getSpecifiedWaitAfterReload(), TimeUnit.MILLISECONDS);
        }
    }

    private void runIfConfigured() {
        if (this.config != null) {
            CrawljaxRunner runner = new CrawljaxRunner(this.config);
            runner.call();
        }
    }

    @VisibleForTesting
    CrawljaxConfiguration getConfig() {
        return this.config;
    }
}

