/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.cli;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.CrawljaxException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.validator.routines.UrlValidator;

class ParameterInterpeter {
    static final String HELP_MESSAGE = "java -jar crawljax-cli-version.jar theUrl theOutputDir";
    static final String BROWSER_REMOTE_URL = "browserRemoteUrl";
    static final String WAIT_AFTER_RELOAD = "waitAfterReload";
    static final String WAIT_AFTER_EVENT = "waitAfterEvent";
    private static final int SPACES_AFTER_OPTION = 3;
    private static final int SPACES_BEFORE_OPTION = 5;
    private static final int ROW_WIDTH = 80;
    private static final String VERSION = "version";
    private static final String VERBOSE = "verbose";
    private static final String HELP = "help";
    private static final String MAXSTATES = "maxstates";
    private static final String DEPTH = "depth";
    private static final String BROWSER = "browser";
    private static final String PARALLEL = "parallel";
    private static final String OVERRIDE = "override";
    private static final String CRAWL_HIDDEN_ANCHORS = "crawlHiddenAnchors";
    private static final String TIME_OUT = "timeout";
    private static final String LOG_FILE = "log";
    private static final String CLICK = "click";
    private final Options options = this.getOptions();
    private final CommandLine parameters;

    ParameterInterpeter(String[] args) throws ParseException {
        this.parameters = new GnuParser().parse(this.options, args);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("h", HELP, false, "print this message");
        options.addOption(VERSION, false, "print the version information and exit");
        options.addOption("b", BROWSER, true, "browser type: " + this.availableBrowsers() + ". Default is Firefox");
        options.addOption(BROWSER_REMOTE_URL, true, "The remote url if you have configured a remote browser");
        options.addOption("d", DEPTH, true, "crawl depth level. Default is 2");
        options.addOption("s", MAXSTATES, true, "max number of states to crawl. Default is 0 (unlimited)");
        options.addOption("p", PARALLEL, true, "Number of browsers to use for crawling. Default is 1");
        options.addOption("o", OVERRIDE, false, "Override the output directory if non-empty");
        options.addOption("a", CRAWL_HIDDEN_ANCHORS, false, "Crawl anchors even if they are not visible in the browser.");
        options.addOption("t", TIME_OUT, true, "Specify the maximum crawl time in minutes");
        options.addOption(CLICK, true, "a comma separated list of HTML tags that should be clicked. Default is A and BUTTON");
        options.addOption(WAIT_AFTER_EVENT, true, "the time to wait after an event has been fired in milliseconds. Default is 200");
        options.addOption(WAIT_AFTER_RELOAD, true, "the time to wait after an URL has been loaded in milliseconds. Default is 200");
        options.addOption("v", VERBOSE, false, "Be extra verbose");
        options.addOption(LOG_FILE, true, "Log to this file instead of the console");
        return options;
    }

    private String availableBrowsers() {
        return Joiner.on(", ").join((Object[])EmbeddedBrowser.BrowserType.values());
    }

    boolean requestsVersion() {
        return this.parameters.hasOption(VERSION);
    }

    boolean necessaryArgsProvided() {
        if (this.parameters.getArgs().length == 2) {
            this.checkUrlValidity(this.getUrl());
            this.checkOutDir(this.getOutputDir());
            this.whenRemoteBrowserNeedsUrl();
            return true;
        }
        return false;
    }

    private void whenRemoteBrowserNeedsUrl() {
        if (this.specifiesBrowser() && this.getSpecifiedBrowser() == EmbeddedBrowser.BrowserType.REMOTE) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.getSpecifiedRemoteBrowser()), "When using remote browser the URL cannot be null");
        }
    }

    private void checkUrlValidity(String urlValue) {
        String[] schemes = new String[]{"http", "https"};
        if (urlValue == null || !new UrlValidator(schemes).isValid(urlValue)) {
            throw new IllegalArgumentException("provide a valid URL like http://example.com");
        }
    }

    String getUrl() {
        return this.parameters.getArgs()[0];
    }

    String getOutputDir() {
        return this.parameters.getArgs()[1];
    }

    private void checkOutDir(String outputDir) {
        File out = new File(outputDir);
        if (out.exists() && out.list().length > 0) {
            if (this.parameters.hasOption(OVERRIDE)) {
                System.out.println("Overriding output directory...");
                try {
                    FileUtils.deleteDirectory(out);
                }
                catch (IOException e) {
                    throw new CrawljaxException(e.getMessage(), e);
                }
            } else {
                throw new IllegalStateException("Output directory is not empty. If you want to override, use the -override option");
            }
        }
    }

    boolean requestsHelp() {
        return this.parameters.hasOption(HELP);
    }

    boolean requestsVerbosity() {
        return this.parameters.hasOption(VERBOSE);
    }

    boolean specifiesLogFile() {
        return this.parameters.hasOption(LOG_FILE);
    }

    String getSpecifiedLogFile() {
        return this.parameters.getOptionValue(LOG_FILE);
    }

    boolean specifiesBrowser() {
        return this.parameters.hasOption(BROWSER);
    }

    EmbeddedBrowser.BrowserType getSpecifiedBrowser() {
        String browser = this.parameters.getOptionValue(BROWSER);
        for (EmbeddedBrowser.BrowserType b : EmbeddedBrowser.BrowserType.values()) {
            if (!b.name().equalsIgnoreCase(browser)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unrecognized browser: '" + browser + "'. Available browsers are: " + this.availableBrowsers());
    }

    boolean specifiesParallelBrowsers() {
        return this.parameters.hasOption(PARALLEL);
    }

    int getSpecifiedNumberOfBrowsers() {
        return Integer.parseInt(this.parameters.getOptionValue(PARALLEL));
    }

    boolean specifiesDepth() {
        return this.parameters.hasOption(DEPTH);
    }

    int getSpecifiedDepth() {
        return Integer.parseInt(this.parameters.getOptionValue(DEPTH));
    }

    boolean specifiesMaxStates() {
        return this.parameters.hasOption(MAXSTATES);
    }

    int getMaxStates() {
        return Integer.parseInt(this.parameters.getOptionValue(MAXSTATES));
    }

    boolean requestsCrawlHiddenAnchors() {
        return this.parameters.hasOption(CRAWL_HIDDEN_ANCHORS);
    }

    boolean specifiesClickElements() {
        return this.parameters.hasOption(CLICK);
    }

    String[] getSpecifiedClickElements() {
        return this.parameters.getOptionValue(CLICK).split(",");
    }

    void printHelp() {
        PrintWriter writer = new PrintWriter(System.out);
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(writer, 80, HELP_MESSAGE, "", this.options, 3, 5, "");
        writer.flush();
    }

    boolean specifiesTimeOut() {
        return this.parameters.hasOption(TIME_OUT);
    }

    long getSpecifiedTimeOut() {
        return Long.parseLong(this.parameters.getOptionValue(TIME_OUT));
    }

    boolean specifiesWaitAfterEvent() {
        return this.parameters.hasOption(WAIT_AFTER_EVENT);
    }

    long getSpecifiedWaitAfterEvent() {
        return Long.parseLong(this.parameters.getOptionValue(WAIT_AFTER_EVENT));
    }

    boolean specifiesWaitAfterReload() {
        return this.parameters.hasOption(WAIT_AFTER_RELOAD);
    }

    long getSpecifiedWaitAfterReload() {
        return Long.parseLong(this.parameters.getOptionValue(WAIT_AFTER_RELOAD));
    }

    public String getSpecifiedRemoteBrowser() {
        return this.parameters.getOptionValue(BROWSER_REMOTE_URL);
    }
}

