/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.coordinates.CoordsPreparationStrategy;
import ru.yandex.qatools.ashot.coordinates.CoordsProvider;
import ru.yandex.qatools.ashot.coordinates.JqueryCoordsProvider;
import ru.yandex.qatools.ashot.cropper.DefaultCropper;
import ru.yandex.qatools.ashot.cropper.ImageCropper;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;
import ru.yandex.qatools.ashot.shooting.SimpleShootingStrategy;

public class AShot
implements Serializable {
    private CoordsProvider coordsProvider = new JqueryCoordsProvider();
    private ImageCropper cropper = new DefaultCropper();
    private Set<By> ignoredLocators = new HashSet<By>();
    private Set<Coords> ignoredAreas = new HashSet<Coords>();
    private ShootingStrategy shootingStrategy = new SimpleShootingStrategy();

    public AShot coordsProvider(CoordsProvider coordsProvider) {
        this.coordsProvider = coordsProvider;
        return this;
    }

    public AShot imageCropper(ImageCropper cropper) {
        this.cropper = cropper;
        return this;
    }

    public synchronized AShot ignoredElements(Set<By> ignoredElements) {
        this.ignoredLocators = ignoredElements;
        return this;
    }

    public synchronized AShot addIgnoredElement(By selector) {
        this.ignoredLocators.add(selector);
        return this;
    }

    public synchronized AShot ignoredAreas(Set<Coords> ignoredAreas) {
        this.ignoredAreas = ignoredAreas;
        return this;
    }

    public synchronized AShot addIgnoredArea(Coords area) {
        this.ignoredAreas.add(area);
        return this;
    }

    public AShot shootingStrategy(ShootingStrategy strategy) {
        this.shootingStrategy = strategy;
        return this;
    }

    public Screenshot takeScreenshot(WebDriver driver, Collection<WebElement> elements) {
        Set<Coords> elementCoords = this.coordsProvider.ofElements(driver, elements);
        BufferedImage shot = this.shootingStrategy.getScreenshot(driver, elementCoords);
        Screenshot screenshot = this.cropper.crop(shot, this.shootingStrategy.prepareCoords(elementCoords));
        Set<Coords> ignoredAreas = this.compileIgnoredAreas(driver, CoordsPreparationStrategy.intersectingWith(screenshot));
        screenshot.setIgnoredAreas(this.shootingStrategy.prepareCoords(ignoredAreas));
        return screenshot;
    }

    public Screenshot takeScreenshot(WebDriver driver, WebElement element) {
        return this.takeScreenshot(driver, Collections.singletonList(element));
    }

    public Screenshot takeScreenshot(WebDriver driver) {
        Screenshot screenshot = new Screenshot(this.shootingStrategy.getScreenshot(driver));
        screenshot.setIgnoredAreas(this.compileIgnoredAreas(driver, CoordsPreparationStrategy.simple()));
        return screenshot;
    }

    protected synchronized Set<Coords> compileIgnoredAreas(WebDriver driver, CoordsPreparationStrategy preparationStrategy) {
        HashSet<Coords> ignoredCoords = new HashSet<Coords>();
        for (By ignoredLocator : this.ignoredLocators) {
            List ignoredElements = driver.findElements(ignoredLocator);
            if (ignoredElements.isEmpty()) continue;
            ignoredCoords.addAll(preparationStrategy.prepare(this.coordsProvider.ofElements(driver, ignoredElements)));
        }
        for (Coords ignoredArea : this.ignoredAreas) {
            ignoredCoords.addAll(preparationStrategy.prepare(Collections.singletonList(ignoredArea)));
        }
        return ignoredCoords;
    }

    public synchronized Set<By> getIgnoredLocators() {
        return this.ignoredLocators;
    }
}

