/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.comparison;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import ru.yandex.qatools.ashot.comparison.DiffMarkupPolicy;

public class PointsMarkupPolicy
extends DiffMarkupPolicy {
    private Set<Point> diffPoints = new LinkedHashSet<Point>();
    private Set<Point> deposedPoints = new LinkedHashSet<Point>();
    private BufferedImage transparentMarkedImage = null;

    @Override
    public BufferedImage getMarkedImage() {
        if (!this.marked) {
            this.markDiffPoints(this.diffImage);
            this.marked = true;
        }
        return this.diffImage;
    }

    @Override
    public BufferedImage getTransparentMarkedImage() {
        if (this.transparentMarkedImage == null) {
            this.transparentMarkedImage = this.getTransparentDiffImage(this.diffImage);
            this.markDiffPoints(this.transparentMarkedImage);
        }
        return this.transparentMarkedImage;
    }

    @Override
    public void addDiffPoint(int x, int y) {
        this.diffPoints.add(new Point(x, y));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PointsMarkupPolicy) {
            PointsMarkupPolicy item = (PointsMarkupPolicy)obj;
            if (this.diffPoints.size() != item.diffPoints.size()) {
                return false;
            }
            Set<Point> referencedPoints = this.getDeposedPoints();
            Set<Point> itemReferencedPoints = item.getDeposedPoints();
            for (Point point : referencedPoints) {
                if (itemReferencedPoints.contains(point)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDeposedPoints().hashCode();
    }

    @Override
    public boolean hasDiff() {
        return this.diffPoints.size() > this.diffSizeTrigger;
    }

    @Override
    public int getDiffSize() {
        return this.diffPoints.size();
    }

    protected void markDiffPoints(BufferedImage image) {
        int rgb = this.diffColor.getRGB();
        for (Point dot : this.diffPoints) {
            image.setRGB(dot.x, dot.y, rgb);
        }
    }

    private Set<Point> getDeposedPoints() {
        if (this.deposedPoints.isEmpty()) {
            this.deposedPoints = this.deposeReference();
        }
        return this.deposedPoints;
    }

    private Point getReferenceCorner() {
        Iterator<Point> iterator = this.diffPoints.iterator();
        Point diffPoint = iterator.next();
        double x = diffPoint.getX();
        double y = diffPoint.getY();
        while (iterator.hasNext()) {
            diffPoint = iterator.next();
            x = Math.min(x, diffPoint.getX());
            y = Math.min(y, diffPoint.getY());
        }
        return new Point((int)x, (int)y);
    }

    private Set<Point> deposeReference() {
        Point reference = this.getReferenceCorner();
        HashSet<Point> referenced = new HashSet<Point>();
        for (Point point : this.diffPoints) {
            referenced.add(new Point(point.x - reference.x, point.y - reference.y));
        }
        return referenced;
    }
}

