/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.cropper.indent;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.cropper.DefaultCropper;
import ru.yandex.qatools.ashot.cropper.indent.IndentFilter;
import ru.yandex.qatools.ashot.util.ImageTool;

public class IndentCropper
extends DefaultCropper {
    public static final int DEFAULT_INDENT = 50;
    private int indent = 50;
    protected List<IndentFilter> filters = new LinkedList<IndentFilter>();

    public IndentCropper(int indent) {
        this.indent = indent;
    }

    public IndentCropper() {
        this(50);
    }

    @Override
    public Screenshot cropScreenshot(BufferedImage image, Set<Coords> coordsToCompare) {
        Coords cropArea = this.createCropArea(coordsToCompare);
        Coords indentMask = this.createIndentMask(cropArea, image);
        Coords coordsWithIndent = this.applyIndentMask(cropArea, indentMask);
        Screenshot croppedShot = super.cropScreenshot(image, Collections.singleton(coordsWithIndent));
        croppedShot.setOriginShift(coordsWithIndent);
        croppedShot.setCoordsToCompare(Coords.setReferenceCoords(coordsWithIndent, coordsToCompare));
        List<NoFilteringArea> noFilteringAreas = this.createNotFilteringAreas(croppedShot);
        croppedShot.setImage(this.applyFilters(croppedShot.getImage()));
        this.pasteAreasToCompare(croppedShot.getImage(), noFilteringAreas);
        return croppedShot;
    }

    protected Coords applyIndentMask(Coords origin, Coords mask) {
        Coords spreadCoords = new Coords(0, 0);
        spreadCoords.x = origin.x - mask.x;
        spreadCoords.y = origin.y - mask.y;
        spreadCoords.height = mask.y + origin.height + mask.height;
        spreadCoords.width = mask.x + origin.width + mask.width;
        return spreadCoords;
    }

    protected Coords createIndentMask(Coords originCoords, BufferedImage image) {
        Coords indentMask = new Coords(originCoords);
        indentMask.x = Math.min(this.indent, originCoords.x);
        indentMask.y = Math.min(this.indent, originCoords.y);
        indentMask.width = Math.min(this.indent, image.getWidth() - originCoords.x - originCoords.width);
        indentMask.height = Math.min(this.indent, image.getHeight() - originCoords.y - originCoords.height);
        return indentMask;
    }

    protected List<NoFilteringArea> createNotFilteringAreas(Screenshot screenshot) {
        ArrayList<NoFilteringArea> noFilteringAreas = new ArrayList<NoFilteringArea>();
        for (Coords noFilteringCoords : screenshot.getCoordsToCompare()) {
            if (!noFilteringCoords.intersects(Coords.ofImage(screenshot.getImage()))) continue;
            noFilteringAreas.add(new NoFilteringArea(screenshot.getImage(), noFilteringCoords));
        }
        return noFilteringAreas;
    }

    protected void pasteAreasToCompare(BufferedImage filtered, List<NoFilteringArea> noFilteringAreas) {
        Graphics graphics = filtered.getGraphics();
        for (NoFilteringArea noFilteringArea : noFilteringAreas) {
            graphics.drawImage(noFilteringArea.getSubimage(), noFilteringArea.getCoords().x, noFilteringArea.getCoords().y, null);
        }
        graphics.dispose();
    }

    public IndentCropper addIndentFilter(IndentFilter filter) {
        this.filters.add(filter);
        return this;
    }

    protected BufferedImage applyFilters(BufferedImage image) {
        for (IndentFilter filter : this.filters) {
            image = filter.apply(image);
        }
        return image;
    }

    private static class NoFilteringArea {
        private BufferedImage subimage;
        private Coords coords;

        private NoFilteringArea(BufferedImage origin, Coords noFilterCoords) {
            this.subimage = ImageTool.subImage(origin, noFilterCoords);
            this.coords = noFilterCoords;
        }

        public BufferedImage getSubimage() {
            return this.subimage;
        }

        public Coords getCoords() {
            return this.coords;
        }
    }
}

