/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting;

import java.awt.image.BufferedImage;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.shooting.ShootingDecorator;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;
import ru.yandex.qatools.ashot.shooting.cutter.CutStrategy;
import ru.yandex.qatools.ashot.shooting.cutter.FixedCutStrategy;

public class CuttingDecorator
extends ShootingDecorator {
    private CutStrategy cutStrategy;

    public CuttingDecorator(ShootingStrategy strategy) {
        super(strategy);
    }

    public CuttingDecorator withCut(int headerToCut, int footerToCut) {
        return this.withCutStrategy(new FixedCutStrategy(headerToCut, footerToCut));
    }

    public CuttingDecorator withCutStrategy(CutStrategy cutStrategy) {
        this.cutStrategy = cutStrategy;
        return this;
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd) {
        BufferedImage baseImage = this.getShootingStrategy().getScreenshot(wd);
        int h = baseImage.getHeight();
        int w = baseImage.getWidth();
        int headerToCut = this.getHeaderToCut(wd);
        int footerToCut = this.getFooterToCut(wd);
        return baseImage.getSubimage(0, headerToCut, w, h - headerToCut - footerToCut);
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd, Set<Coords> coords) {
        return this.getScreenshot(wd);
    }

    protected int getHeaderToCut(WebDriver wd) {
        return this.cutStrategy.getHeaderHeight(wd);
    }

    protected int getFooterToCut(WebDriver wd) {
        return this.cutStrategy.getFooterHeight(wd);
    }
}

