/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.shooting.ImageReadException;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;

public class SimpleShootingStrategy
implements ShootingStrategy {
    @Override
    public BufferedImage getScreenshot(WebDriver wd) {
        BufferedImage ignored2;
        TakesScreenshot takesScreenshot;
        ByteArrayInputStream imageArrayStream = null;
        try {
            takesScreenshot = (TakesScreenshot)wd;
        }
        catch (ClassCastException ignored2) {
            takesScreenshot = (TakesScreenshot)new Augmenter().augment(wd);
        }
        try {
            imageArrayStream = new ByteArrayInputStream((byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES));
            ignored2 = ImageIO.read(imageArrayStream);
        }
        catch (IOException e) {
            try {
                throw new ImageReadException("Can not parse screenshot data", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(imageArrayStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)imageArrayStream);
        return ignored2;
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd, Set<Coords> coords) {
        return this.getScreenshot(wd);
    }

    @Override
    public Set<Coords> prepareCoords(Set<Coords> coordsSet) {
        return coordsSet;
    }
}

