/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.buckets;

import com.idealista.tlsh.buckets.ProcessedBuckets;
import com.idealista.tlsh.buckets.Quartiles;
import com.idealista.tlsh.buckets.SlideWindow;

public class BucketProcessor {
    private static final int ARRAY_BUCKET_SIZE = 256;

    public ProcessedBuckets process(String data) {
        int[] checksum = null;
        int[] bucketArray = new int[256];
        SlideWindow slideWindow = new SlideWindow();
        int length = data.length();
        int i = 0;
        while (i < length) {
            int startWindow = slideWindow.getPivot();
            slideWindow.put(data.charAt(i));
            checksum = slideWindow.getChecksum(startWindow, checksum);
            for (Integer tripletHash : slideWindow.getTripletHashes(startWindow)) {
                int n = tripletHash;
                bucketArray[n] = bucketArray[n] + 1;
            }
            ++i;
        }
        return this.buildProcessedBuckets(length, bucketArray, checksum);
    }

    private ProcessedBuckets buildProcessedBuckets(int dataLength, int[] bucketArray, int[] checksum) {
        Quartiles quartiles = new Quartiles(bucketArray);
        return new ProcessedBuckets(checksum, bucketArray, dataLength, quartiles);
    }
}

