/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.buckets;

import com.idealista.tlsh.buckets.DigestBuilder;
import com.idealista.tlsh.buckets.Quartiles;
import com.idealista.tlsh.digests.Digest;

public class ProcessedBuckets {
    public static final int CODE_SIZE = 32;
    private static final int MINIMUM_HASH_INPUT_LENGTH = 512;
    private int[] checksum;
    private int[] bucketArray;
    private int processedDataLength;
    private Quartiles quartiles;

    public ProcessedBuckets(int[] checksum, int[] bucketArray, int processedDataLength, Quartiles quartiles) {
        this.checksum = checksum;
        this.bucketArray = bucketArray;
        this.processedDataLength = processedDataLength;
        this.quartiles = quartiles;
    }

    public boolean isProcessedDataTooSimple() {
        return !this.hasMinimumAmountOfDataProcessed() || !this.hasMinimumNonZeroBuckets();
    }

    public Digest buildDigest() {
        int[] bodyData = this.calculateBody();
        return new DigestBuilder().withChecksum(this.checksum).withLength(this.processedDataLength).withQuartiles(this.quartiles).withBody(bodyData).build();
    }

    private int[] calculateBody() {
        int[] body = new int[32];
        int i = 0;
        while (i < 32) {
            int h = 0;
            int j = 0;
            while (j < 4) {
                int k1 = this.bucketArray[4 * i + j];
                if (this.quartiles.getThird() < k1) {
                    h += 3 << j * 2;
                } else if (this.quartiles.getSecond() < k1) {
                    h += 2 << j * 2;
                } else if (this.quartiles.getFirst() < k1) {
                    h += 1 << j * 2;
                }
                ++j;
            }
            body[i] = h;
            ++i;
        }
        return body;
    }

    private boolean hasMinimumAmountOfDataProcessed() {
        return this.processedDataLength >= 512;
    }

    private boolean hasMinimumNonZeroBuckets() {
        int nonZeroBuckets = 0;
        int index = 0;
        while (index < 128) {
            if (this.isPositiveBucket(index)) {
                ++nonZeroBuckets;
            }
            ++index;
        }
        return nonZeroBuckets > 64;
    }

    private boolean isPositiveBucket(int index) {
        return this.bucketArray[index] > 0;
    }
}

