/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.buckets;

import java.util.Arrays;

public class Quartiles {
    private static final int ARRAY_SAMPLE_SIZE = 128;
    private static final int Q_RATIO_MODULE = 16;
    private int[] sampleArray;

    public Quartiles(int[] data) {
        if (data.length < 128) {
            throw new IllegalArgumentException("cannot calculate quartiles for arrays with less than 128 numbers");
        }
        this.sampleArray = this.getSortedSampleArray(data);
    }

    public int getFirst() {
        return this.sampleArray[31];
    }

    public int getSecond() {
        return this.sampleArray[63];
    }

    public int getThird() {
        return this.sampleArray[95];
    }

    public int getQ1Ratio() {
        return this.getFirst() * 100 / this.getThird() % 16;
    }

    public int getQ2Ratio() {
        return this.getSecond() * 100 / this.getThird() % 16;
    }

    private int[] getSortedSampleArray(int[] data) {
        int[] sampleArray = new int[128];
        System.arraycopy(data, 0, sampleArray, 0, 128);
        Arrays.sort(sampleArray);
        return sampleArray;
    }
}

