/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.buckets;

import com.idealista.tlsh.buckets.Triplet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class SlideWindow {
    private static final int CHECKSUM_LENGTH = 1;
    private static final int SLIDING_WINDOW_SIZE = 5;
    private final int[] storage = new int[5];
    private int counter = 0;

    public void put(int value) {
        this.storage[this.getPivot()] = value & 0xFF;
        ++this.counter;
    }

    public List<Integer> getTripletHashes(int fromStartWindow) {
        if (!this.isComplete()) {
            return new ArrayList<Integer>();
        }
        int startWindow = fromStartWindow;
        int j2 = (startWindow + 1) % 5;
        int j3 = (startWindow + 2) % 5;
        int j4 = (startWindow + 3) % 5;
        int endWindow = (startWindow + 4) % 5;
        return Arrays.asList(this.getHash(this.storage[startWindow], this.storage[endWindow], this.storage[j4], 2), this.getHash(this.storage[startWindow], this.storage[endWindow], this.storage[j3], 3), this.getHash(this.storage[startWindow], this.storage[j4], this.storage[j3], 5), this.getHash(this.storage[startWindow], this.storage[j4], this.storage[j2], 7), this.getHash(this.storage[startWindow], this.storage[endWindow], this.storage[j2], 11), this.getHash(this.storage[startWindow], this.storage[j3], this.storage[j2], 13));
    }

    public int[] getChecksum(int fromStartWindow, int[] lastChecksum) {
        if (!this.isComplete()) {
            return null;
        }
        int endWindow = (fromStartWindow + 4) % 5;
        int[] checksum = new int[1];
        int i = 0;
        while (i < 1) {
            int c1 = this.getValue(fromStartWindow);
            int c2 = this.getValue(endWindow);
            int c3 = 0;
            int salt = 0;
            if (lastChecksum != null) {
                c3 = lastChecksum[i];
            }
            if (i != 0) {
                salt = checksum[i - 1];
            }
            checksum[i] = this.getHash(c1, c2, c3, salt);
            ++i;
        }
        return checksum;
    }

    public int getPivot() {
        return this.counter % 5;
    }

    private boolean isComplete() {
        return this.counter >= 5;
    }

    private int getHash(int c1, int c2, int c3, int salt) {
        return new Triplet(c1, c2, c3, salt).getHash();
    }

    private int getValue(int index) {
        return this.storage[index];
    }
}

