/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.digests;

class BitPairsTable {
    private static final int BIT_PAIRS_DIFF_TABLE_SIZE = 256;
    private static final int[][] BIT_PAIRS_DIFF_TABLE = BitPairsTable.generateDefaultBitPairsDiffTable();

    BitPairsTable() {
    }

    private static int[][] generateDefaultBitPairsDiffTable() {
        int[][] result = new int[256][256];
        int i = 0;
        while (i < 256) {
            int j = 0;
            while (j < 256) {
                int x = i;
                int y = j;
                int diff = 0;
                int z = 0;
                while (z < 4) {
                    int d = Math.abs(x % 4 - y % 4);
                    diff = d == 3 ? (diff += d * 2) : (diff += d);
                    if (z < 3) {
                        x /= 4;
                        y /= 4;
                    }
                    ++z;
                }
                result[i][j] = diff;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int getValue(int row, int column) {
        return BIT_PAIRS_DIFF_TABLE[row][column];
    }
}

