/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.digests;

import com.idealista.tlsh.digests.Body;
import com.idealista.tlsh.digests.ByteSwapper;
import com.idealista.tlsh.digests.Checksum;
import com.idealista.tlsh.digests.Digest;
import com.idealista.tlsh.digests.LValue;
import com.idealista.tlsh.digests.Q;

public class DigestBuilder {
    private Checksum checksum;
    private LValue lValue;
    private Q q;
    private Body body;

    public DigestBuilder withHash(String hash) {
        int[] digestData = DigestBuilder.fromHex(hash);
        int i = 0;
        this.withChecksumData(digestData[i++]);
        this.withLValueData(digestData[i++]);
        this.withQData(digestData[i++]);
        this.withBodyData(DigestBuilder.getBodyData(digestData, i));
        return this;
    }

    public Digest build() {
        return new Digest(this.checksum, this.lValue, this.q, this.body);
    }

    private static int[] fromHex(String s) {
        int[] result = new int[s.length() / 2];
        int i = 0;
        while (i < s.length()) {
            result[i / 2] = Integer.parseInt(s.substring(i, i + 2), 16);
            i += 2;
        }
        return result;
    }

    private void withChecksumData(int data) {
        this.checksum = new Checksum(new int[]{this.swap(data)});
    }

    private void withLValueData(int data) {
        this.lValue = new LValue(this.swap(data));
    }

    private void withQData(int data) {
        this.q = new Q(this.swap(data));
    }

    private void withBodyData(int[] data) {
        int[] bodyData = new int[data.length];
        int j = 0;
        while (j < data.length) {
            bodyData[j] = data[data.length - 1 - j];
            ++j;
        }
        this.body = new Body(bodyData);
    }

    private static int[] getBodyData(int[] digestData, int from) {
        int[] bodyData = new int[32];
        System.arraycopy(digestData, from, bodyData, 0, bodyData.length);
        return bodyData;
    }

    private int swap(int data) {
        return ByteSwapper.swap(data);
    }
}

