/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.digests;

import com.idealista.tlsh.digests.Body;
import com.idealista.tlsh.digests.ByteSwapper;
import com.idealista.tlsh.digests.Checksum;
import com.idealista.tlsh.digests.LValue;
import com.idealista.tlsh.digests.Q;

class DigestStringBuilder {
    private StringBuilder value = new StringBuilder();

    public DigestStringBuilder append(Checksum checksum) {
        int[] swappedChecksum = new int[checksum.getValue().length];
        int k = 0;
        while (k < swappedChecksum.length) {
            swappedChecksum[k] = this.swap(checksum.getValue()[k]);
            ++k;
        }
        this.value.append(this.toHex(swappedChecksum));
        return this;
    }

    public DigestStringBuilder append(LValue lValue) {
        this.value.append(this.toHex(this.swap(lValue.getValue())));
        return this;
    }

    public DigestStringBuilder append(Q q) {
        this.value.append(this.toHex(this.swap(q.getValue())));
        return this;
    }

    public DigestStringBuilder append(Body body) {
        int[] swappedBody = new int[body.getBody().length];
        int i = 0;
        while (i < swappedBody.length) {
            swappedBody[i] = body.getBody()[swappedBody.length - 1 - i];
            ++i;
        }
        this.value.append(this.toHex(swappedBody));
        return this;
    }

    public String build() {
        return this.value.toString();
    }

    private String toHex(int value) {
        return String.format("%02X", 0xFF & value);
    }

    private String toHex(int[] values) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            result.append(this.toHex(values[i]));
            ++i;
        }
        return result.toString().toUpperCase();
    }

    private int swap(int data) {
        return ByteSwapper.swap(data);
    }
}

