/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.tlsh.digests;

import com.idealista.tlsh.digests.ModularDifferenceCalculator;

public class Q {
    private static final int RANGE_QRATIO = 16;
    private int value;

    public Q(int value) {
        this.value = value;
    }

    public Q(int QLo, int QHi) {
        this(Q.calculateValue(QLo, QHi));
    }

    public int calculateDifference(Q other) {
        int diff = 0;
        int q1diff = ModularDifferenceCalculator.calculate(this.getQLo(), other.getQLo(), 16);
        diff = q1diff <= 1 ? (diff += q1diff) : (diff += (q1diff - 1) * 12);
        int q2diff = ModularDifferenceCalculator.calculate(this.getQHi(), other.getQHi(), 16);
        diff = q2diff <= 1 ? (diff += q2diff) : (diff += (q2diff - 1) * 12);
        return diff;
    }

    public int getValue() {
        return this.value;
    }

    private int getQLo() {
        return this.value & 0xF;
    }

    private int getQHi() {
        return (this.value & 0xF0) >> 4;
    }

    private static int calculateValue(int QLo, int QHi) {
        return QLo & 0xF & 0xF | (QHi & 0xF) << 4;
    }
}

