/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.browser.WebDriverBrowserBuilder;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.plugin.Plugin;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.plugins.crawloverview.model.Serializer;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeanToReadableMap {
    private static final String CAMEL_REGEX = String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])");
    private static final Logger LOG = LoggerFactory.getLogger(BeanToReadableMap.class);

    private BeanToReadableMap() {
    }

    public static ImmutableMap<String, String> toMap(Object o) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : o.getClass().getMethods()) {
            if (!BeanToReadableMap.isGetter(method)) continue;
            builder.put(BeanToReadableMap.addMethodToMap(o, method));
        }
        return builder.build();
    }

    private static boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !"getClass".equals(method.getName());
    }

    private static Map.Entry<String, String> addMethodToMap(Object o, Method method) {
        try {
            Object[] noArgs = null;
            Object result = method.invoke(o, noArgs);
            String name = BeanToReadableMap.asName(method);
            return ImmutablePair.of((Object)name, (Object)BeanToReadableMap.toString(name, result));
        }
        catch (Exception e) {
            LOG.error("Could not parse bean {} because {}", new Object[]{o, e.getMessage(), e});
            return ImmutablePair.of((Object)BeanToReadableMap.asName(method), (Object)"Unreadable entry");
        }
    }

    private static String toString(String name, Object result) {
        if (result == null) {
            return "null";
        }
        if (result instanceof Collection) {
            return BeanToReadableMap.asHtmlList((Collection)result);
        }
        if (result instanceof Plugin) {
            return StringEscapeUtils.escapeHtml4((String)result.getClass().getSimpleName());
        }
        if (result instanceof CrawlRules) {
            return "<pre><code>" + StringEscapeUtils.escapeHtml4((String)Serializer.toPrettyJson(result)) + "</code></pre>";
        }
        if (result instanceof BrowserConfiguration) {
            BrowserConfiguration config = (BrowserConfiguration)result;
            StringBuilder configAsString = new StringBuilder().append(config.getNumberOfBrowsers()).append(" browsers of type ").append(config.getBrowserType());
            if (!(config.getBrowserBuilder() instanceof WebDriverBrowserBuilder)) {
                configAsString.append(" using builder ").append(config.getBrowserBuilder());
            }
            return configAsString.toString();
        }
        if (result instanceof Plugins) {
            return BeanToReadableMap.toString(name, ((Plugins)result).pluginNames());
        }
        if (name != null && name.toLowerCase().contains("runtime")) {
            return StringEscapeUtils.escapeHtml4((String)DurationFormatUtils.formatDurationWords((long)((Long)result), (boolean)true, (boolean)true));
        }
        if (result instanceof Number && ((Number)result).intValue() == 0) {
            return "&infin;";
        }
        return StringEscapeUtils.escapeHtml4((String)result.toString());
    }

    private static String asName(Method method) {
        int getPrefix = "get".length();
        String name = method.getName().substring(getPrefix);
        return BeanToReadableMap.splitCamelCase(name);
    }

    private static String asHtmlList(Collection<?> result) {
        if (result.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<ul>");
        for (Object object : result) {
            sb.append("<li>").append(BeanToReadableMap.toString(null, object)).append("</li>");
        }
        return sb.append("</ul>").toString();
    }

    private static String splitCamelCase(String s) {
        return s.replaceAll(CAMEL_REGEX, " ");
    }
}

