/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.HostInterface;
import com.crawljax.core.plugin.HostInterfaceImpl;
import com.crawljax.core.plugin.OnFireEventFailedPlugin;
import com.crawljax.core.plugin.OnNewStatePlugin;
import com.crawljax.core.plugin.PostCrawlingPlugin;
import com.crawljax.core.plugin.PreCrawlingPlugin;
import com.crawljax.core.plugin.PreStateCrawlingPlugin;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.plugins.crawloverview.ImageWriter;
import com.crawljax.plugins.crawloverview.OutPutModelCache;
import com.crawljax.plugins.crawloverview.OutputBuilder;
import com.crawljax.plugins.crawloverview.StateBuilder;
import com.crawljax.plugins.crawloverview.StateWriter;
import com.crawljax.plugins.crawloverview.model.CandidateElementPosition;
import com.crawljax.plugins.crawloverview.model.OutPutModel;
import com.crawljax.plugins.crawloverview.model.State;
import com.crawljax.stateabstractions.hybrid.HybridStateVertexImpl;
import com.crawljax.stateabstractions.visual.ColorHistogramStateVertexImpl;
import com.crawljax.stateabstractions.visual.imagehashes.DHashStateVertexImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlOverview
implements OnNewStatePlugin,
PreStateCrawlingPlugin,
PostCrawlingPlugin,
OnFireEventFailedPlugin,
PreCrawlingPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlOverview.class);
    private final ConcurrentMap<String, StateVertex> visitedStates;
    private final OutPutModelCache outModelCache = new OutPutModelCache();
    private OutputBuilder outputBuilder;
    private boolean warnedForElementsInIframe = false;
    private boolean firstState = true;
    private boolean shouldTakeScreenshots = false;
    private OutPutModel result;
    private HostInterface hostInterface;

    public CrawlOverview() {
        this.visitedStates = Maps.newConcurrentMap();
        LOG.info("Initialized the Crawl overview plugin");
        this.hostInterface = null;
    }

    public CrawlOverview(HostInterface hostInterface) {
        this.visitedStates = Maps.newConcurrentMap();
        LOG.info("Initialized the Crawl overview plugin");
        this.hostInterface = hostInterface;
    }

    public void preCrawling(CrawljaxConfiguration config) throws RuntimeException {
        if (this.hostInterface == null) {
            this.hostInterface = new HostInterfaceImpl(config.getOutputDir(), null);
        }
        File outputFolder = this.hostInterface.getOutputDirectory();
        Preconditions.checkNotNull((Object)outputFolder, (Object)"Output folder cannot be null");
        this.outputBuilder = new OutputBuilder(outputFolder);
    }

    public void onNewState(CrawlerContext context, StateVertex vertex) {
        LOG.debug("onNewState");
        StateBuilder state = this.outModelCache.addStateIfAbsent(vertex);
        this.visitedStates.putIfAbsent(state.getName(), vertex);
        this.saveScreenshot(context.getBrowser(), state.getName(), vertex);
        this.outputBuilder.persistDom(state.getName(), context.getBrowser().getUnStrippedDom());
    }

    private void saveScreenshot(EmbeddedBrowser browser, String name, StateVertex vertex) {
        if (this.firstState) {
            this.firstState = false;
            File screenshotsFolder = this.outputBuilder.getScreenshotsFolder();
            if (!screenshotsFolder.exists()) {
                LOG.debug("Screenshot folder does not exist yet, creating...");
                this.shouldTakeScreenshots = true;
                boolean created = screenshotsFolder.mkdir();
                Preconditions.checkArgument((boolean)created, (Object)"Could not create screenshotsFolder dir");
            }
        }
        if (this.shouldTakeScreenshots || vertex instanceof HybridStateVertexImpl) {
            LOG.debug("Saving screenshot for state {}", (Object)name);
            File jpg = this.outputBuilder.newScreenShotFile(name);
            File thumb = this.outputBuilder.newThumbNail(name);
            try {
                BufferedImage screenshot = browser.getScreenShotAsBufferedImage(500);
                ImageWriter.writeScreenShotAndThumbnail(screenshot, jpg, thumb);
            }
            catch (CrawljaxException | WebDriverException e) {
                LOG.warn("Screenshots are not supported or not functioning for {}. Exception message: {}", (Object)browser, (Object)e.getMessage());
                LOG.debug("Screenshot not made because {}", (Object)e.getMessage(), (Object)e);
            }
            LOG.trace("Screenshot saved");
        }
    }

    public void preStateCrawling(CrawlerContext context, ImmutableList<CandidateElement> candidateElements, StateVertex state) {
        LOG.debug("preStateCrawling");
        LinkedList newElements = Lists.newLinkedList();
        LOG.info("Prestate found new state {} with {} candidates", (Object)state.getName(), (Object)candidateElements.size());
        for (CandidateElement element : candidateElements) {
            try {
                WebElement webElement = this.getWebElement(context.getBrowser(), element);
                if (webElement == null) continue;
                newElements.add(this.findElement(webElement, element));
            }
            catch (WebDriverException e) {
                LOG.info("Could not get position for {}", (Object)element, (Object)e);
            }
        }
        StateBuilder stateOut = this.outModelCache.addStateIfAbsent(state);
        stateOut.addCandidates(newElements);
        LOG.trace("preState finished, elements added to state");
    }

    private WebElement getWebElement(EmbeddedBrowser browser, CandidateElement element) {
        try {
            if (!Strings.isNullOrEmpty((String)element.getRelatedFrame())) {
                this.warnUserForInvisibleElements();
                return null;
            }
            return browser.getWebElement(element.getIdentification());
        }
        catch (WebDriverException e) {
            LOG.info("Could not locate element for positioning {}", (Object)element);
            return null;
        }
    }

    private void warnUserForInvisibleElements() {
        if (!this.warnedForElementsInIframe) {
            LOG.warn("Some elemnts are in an iFrame. We cannot display it in the Crawl overview");
            this.warnedForElementsInIframe = true;
        }
    }

    private CandidateElementPosition findElement(WebElement webElement, CandidateElement element) {
        Point location = webElement.getLocation();
        Dimension size = webElement.getSize();
        CandidateElementPosition renderedCandidateElement = new CandidateElementPosition(element.getIdentification().getValue(), location, size);
        if (location.getY() < 0) {
            LOG.warn("Weird positioning {} for {}", (Object)webElement.getLocation(), (Object)renderedCandidateElement.getXpath());
        }
        return renderedCandidateElement;
    }

    public void postCrawling(CrawlSession session, ExitNotifier.ExitStatus exitStatus) {
        LOG.debug("postCrawling");
        StateFlowGraph sfg = session.getStateFlowGraph();
        this.checkSFG(sfg);
        this.result = this.outModelCache.close(session, exitStatus);
        this.outputBuilder.write(this.result, session.getConfig());
        StateWriter writer = new StateWriter(this.outputBuilder, sfg, (Map<String, StateVertex>)ImmutableMap.copyOf(this.visitedStates));
        for (State state : this.result.getStates().values()) {
            try {
                writer.writeHtmlForState(state);
            }
            catch (Exception Ex) {
                LOG.info("couldn't write state :" + state.getName());
            }
        }
        LOG.info("Crawl overview plugin has finished");
    }

    private void checkSFG(StateFlowGraph sfg) {
        TreeSet<String> hashes = new TreeSet<String>();
        for (StateVertex sv : sfg.getAllStates()) {
            ColorHistogramStateVertexImpl svv;
            if (sv instanceof ColorHistogramStateVertexImpl) {
                svv = (ColorHistogramStateVertexImpl)sv;
                System.out.println("State: " + svv.getName() + " hash: " + svv.getColorHistogram());
                hashes.add(svv.getColorHistogram().dump());
                continue;
            }
            if (!(sv instanceof DHashStateVertexImpl)) continue;
            svv = (DHashStateVertexImpl)sv;
            System.out.println("State: " + svv.getName() + " hash: " + svv.getDHashVisual());
            hashes.add(svv.getDHashVisual());
        }
    }

    public OutPutModel getResult() {
        return this.result;
    }

    public String toString() {
        return "Crawl overview plugin";
    }

    public void onFireEventFailed(CrawlerContext context, Eventable eventable, List<Eventable> pathToFailure) {
        this.outModelCache.registerFailEvent(context.getCurrentState(), eventable);
    }
}

