/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.core.CrawljaxException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageWriter {
    private static final int THUMBNAIL_WIDTH = 200;
    private static final int THUMBNAIL_HEIGHT = 200;

    private ImageWriter() {
    }

    static void writeScreenShotAndThumbnail(BufferedImage img, File fullFile, File thumnail) {
        try {
            ImageWriter.writeFullSizeJpeg(fullFile, img);
            ImageWriter.writeThumbNail(thumnail, img);
        }
        catch (IOException e) {
            throw new CrawljaxException("Could not write screenshots to disk", (Throwable)e);
        }
    }

    private static void writeFullSizeJpeg(File target, BufferedImage image) throws IOException {
        ImageIO.write((RenderedImage)image, "PNG", target);
    }

    private static void writeThumbNail(File target, BufferedImage screenshot) throws IOException {
        BufferedImage resizedImage = new BufferedImage(200, 200, 1);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(screenshot, 0, 0, 200, 200, Color.WHITE, null);
        g.dispose();
        ImageIO.write((RenderedImage)resizedImage, "JPEG", target);
    }
}

