/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.core.CrawlSession;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateVertex;
import com.crawljax.plugins.crawloverview.StateBuilder;
import com.crawljax.plugins.crawloverview.model.Edge;
import com.crawljax.plugins.crawloverview.model.OutPutModel;
import com.crawljax.plugins.crawloverview.model.State;
import com.crawljax.plugins.crawloverview.model.StateStatistics;
import com.crawljax.plugins.crawloverview.model.Statistics;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OutPutModelCache {
    private static final Logger LOG = LoggerFactory.getLogger(OutPutModelCache.class);
    private final ConcurrentMap<String, StateBuilder> states = Maps.newConcurrentMap();
    private final AtomicInteger failedEvents = new AtomicInteger();
    private final Date startDate = new Date();

    OutPutModelCache() {
    }

    StateBuilder addStateIfAbsent(StateVertex state) {
        StateBuilder newState = new StateBuilder(state);
        StateBuilder found = this.states.putIfAbsent(state.getName(), newState);
        if (found == null) {
            return newState;
        }
        return found;
    }

    public OutPutModel close(CrawlSession session, ExitNotifier.ExitStatus exitStatus) {
        ImmutableList<Edge> edgesCopy = this.asEdges((Set<Eventable>)session.getStateFlowGraph().getAllEdges());
        this.checkEdgesAndCountFans(edgesCopy);
        ImmutableMap<String, State> statesCopy = this.buildStates();
        if (statesCopy.size() != session.getStateFlowGraph().getAllStates().size()) {
            LOG.error("Not all states from the session are in the result. This means there's a bug somewhere");
            LOG.info("Printing state difference. \nSession states: {} \nResult states: {}", statesCopy, (Object)session.getStateFlowGraph().getAllStates());
        }
        StateStatistics stateStats = new StateStatistics((Collection<State>)statesCopy.values());
        return new OutPutModel(statesCopy, edgesCopy, new Statistics(session, stateStats, this.startDate, this.failedEvents.get()), exitStatus);
    }

    private ImmutableList<Edge> asEdges(Set<Eventable> allEdges) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Eventable eventable : allEdges) {
            builder.add((Object)new Edge(eventable));
        }
        return builder.build();
    }

    private void checkEdgesAndCountFans(ImmutableList<Edge> edges) {
        for (Edge e : edges) {
            StateBuilder from = (StateBuilder)this.states.get(e.getFrom());
            StateBuilder to = (StateBuilder)this.states.get(e.getTo());
            try {
                Preconditions.checkNotNull((Object)from, (String)"From state %s is unkown", (Object)e.getFrom());
                from.incrementFanOut();
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage());
            }
            try {
                Preconditions.checkNotNull((Object)to, (String)"To state %s is unkown", (Object)e.getTo());
                to.incrementFanIn();
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage());
            }
        }
    }

    private ImmutableMap<String, State> buildStates() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (StateBuilder state : this.states.values()) {
            builder.put((Object)state.getName(), (Object)state.build());
        }
        return builder.build();
    }

    public void registerFailEvent(StateVertex currentState, Eventable eventable) {
        StateBuilder builder;
        this.failedEvents.incrementAndGet();
        if (currentState != null && (builder = (StateBuilder)this.states.get(currentState.getName())) != null) {
            builder.eventFailed(eventable);
        }
    }
}

