/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.core.CrawljaxException;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.plugins.crawloverview.BeanToReadableMap;
import com.crawljax.plugins.crawloverview.CrawlOverviewException;
import com.crawljax.plugins.crawloverview.model.AlchemyEdge;
import com.crawljax.plugins.crawloverview.model.AlchemyGraphModel;
import com.crawljax.plugins.crawloverview.model.Edge;
import com.crawljax.plugins.crawloverview.model.OutPutModel;
import com.crawljax.plugins.crawloverview.model.Serializer;
import com.crawljax.plugins.crawloverview.model.State;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OutputBuilder {
    static final String SCREENSHOT_FOLDER_NAME = "screenshots";
    static final String STATES_FOLDER_NAME = "states";
    static final String JSON_OUTPUT_NAME = "result.json";
    static final String DOMS_OUTPUT_NAME = "doms";
    private static final Logger LOG = LoggerFactory.getLogger(OutputBuilder.class);
    private final File outputDir;
    private final File states;
    private final File screenshotsFolder;
    private final File indexFile;
    private final File doms;
    private final VelocityEngine ve;

    OutputBuilder(File outputDir) {
        this.outputDir = outputDir;
        this.checkPermissions();
        this.copySkeleton();
        this.states = new File(outputDir, STATES_FOLDER_NAME);
        boolean created = this.states.mkdir();
        Preconditions.checkArgument((boolean)created, (Object)"Could not create states dir");
        this.screenshotsFolder = new File(outputDir, SCREENSHOT_FOLDER_NAME);
        this.doms = new File(outputDir, DOMS_OUTPUT_NAME);
        created = this.doms.mkdir();
        Preconditions.checkArgument((boolean)created, (Object)"Could not create doms dir");
        this.indexFile = new File(outputDir, "index.html");
        this.ve = new VelocityEngine();
        this.configureVelocity();
    }

    public File getScreenshotsFolder() {
        return this.screenshotsFolder;
    }

    private void configureVelocity() {
        this.ve.setProperty("resource.loader", (Object)"classpath");
        this.ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
    }

    private void checkPermissions() {
        if (this.outputDir.exists()) {
            Preconditions.checkArgument((boolean)this.outputDir.isDirectory(), (Object)(this.outputDir + " is not a directory"));
            Preconditions.checkArgument((this.outputDir.list().length == 0 ? 1 : 0) != 0, (Object)"Directory must be empty");
            Preconditions.checkArgument((boolean)this.outputDir.canWrite(), (Object)"Output dir not writable");
        } else {
            boolean created = this.outputDir.mkdirs();
            Preconditions.checkArgument((boolean)created, (Object)("Could not create directory " + this.outputDir));
        }
    }

    private void copySkeleton() {
        URL skeleton = OutputBuilder.class.getResource("/skeleton");
        if (skeleton.toExternalForm().contains("jar!")) {
            this.copySkeletonFromJar(skeleton);
        } else {
            LOG.debug("Loading skeleton as file");
            try {
                FileUtils.copyDirectory((File)new File(skeleton.toURI()), (File)this.outputDir);
            }
            catch (IOException | URISyntaxException e) {
                throw new CrawljaxException("Could not copy required resources: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void copySkeletonFromJar(URL skeleton) {
        LOG.debug("Loading skeleton as JAR entry {}", (Object)skeleton);
        File jar = this.getJar(skeleton);
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(jar));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().startsWith("skeleton") || entry.isDirectory()) continue;
                String filename = entry.getName().substring("skeleton/".length());
                File newFile = new File(this.outputDir, filename);
                File parent = new File(newFile.getParent());
                if (!parent.exists()) {
                    boolean created = parent.mkdirs();
                    Preconditions.checkArgument((boolean)created, (Object)("Could not create folder " + newFile.getParent()));
                }
                FileOutputStream out = new FileOutputStream(newFile);
                ByteStreams.copy((InputStream)zis, (OutputStream)out);
                out.close();
            }
        }
        catch (IOException e1) {
            throw new CrawljaxException("Could not copy required resources: " + e1.getMessage(), (Throwable)e1);
        }
    }

    private File getJar(URL skeleton) {
        String path;
        try {
            path = URLDecoder.decode(skeleton.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CrawljaxException("Could not process the path of the Overview skeleton " + skeleton, (Throwable)e);
        }
        String jarpath = path.substring("file:".length(), path.indexOf("jar!") + "jar".length());
        File jar = new File(jarpath);
        LOG.debug("Jar file {} from path {}", (Object)jar, (Object)path);
        return jar;
    }

    File newScreenShotFile(String name) {
        return new File(this.screenshotsFolder, name + ".png");
    }

    public File newThumbNail(String name) {
        return new File(this.screenshotsFolder, name + "_small.jpg");
    }

    public void write(OutPutModel result, CrawljaxConfiguration config) {
        try {
            this.writeIndexFile(result, config);
            this.writeJsonToOutDir(Serializer.toPrettyJson(config), "config.json");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        LOG.info("Overview report generated");
    }

    private AlchemyGraphModel getAlchemyJson(OutPutModel model) {
        State[] nodes = new State[model.getStates().size()];
        AlchemyEdge[] edges = new AlchemyEdge[model.getEdges().size()];
        int i = 0;
        for (String stateName : model.getStates().keySet()) {
            nodes[i] = (State)model.getStates().get((Object)stateName);
            ++i;
        }
        i = 0;
        for (Edge edge : model.getEdges()) {
            int from = ((State)model.getStates().get((Object)edge.getFrom())).getId();
            int to = ((State)model.getStates().get((Object)edge.getTo())).getId();
            edges[i] = new AlchemyEdge(from, to, edge.hashCode(), edge.getText(), edge.getElement(), edge.getEventType());
            ++i;
        }
        AlchemyGraphModel graphModel = new AlchemyGraphModel(nodes, edges);
        this.writeJsonToOutDir(Serializer.toPrettyJson(graphModel), "alchemyGraph.json");
        return graphModel;
    }

    private void writeIndexFile(OutPutModel model, CrawljaxConfiguration config) {
        LOG.debug("Writing index file");
        VelocityContext context = new VelocityContext();
        this.writeJsonToOutDir(Serializer.toPrettyJson(model), JSON_OUTPUT_NAME);
        context.put(STATES_FOLDER_NAME, (Object)Serializer.toPrettyJson(model.getStates()));
        context.put("edges", (Object)Serializer.toPrettyJson(model.getEdges()));
        context.put("config", BeanToReadableMap.toMap(config));
        context.put("crawledUrl", (Object)config.getUrl());
        context.put("stats", (Object)model.getStatistics());
        context.put("exitStatus", (Object)model.getExitStatus());
        LOG.debug("Writing urls report");
        context.put("urls", model.getStatistics().getStateStats().getUrls());
        this.writeFile(context, this.indexFile, "index.html");
    }

    private void writeJsonToOutDir(String outModelJson, String filename) {
        try {
            Files.write((CharSequence)outModelJson, (File)new File(this.outputDir, filename), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.warn("Could not write JSON model to output dir. " + e.getMessage());
        }
    }

    private void writeFile(VelocityContext context, File outFile, String template) {
        try {
            Template templatee = this.ve.getTemplate(template);
            FileWriter writer = new FileWriter(outFile);
            templatee.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new CrawlOverviewException("Could not write output state", e);
        }
    }

    void writeState(VelocityContext context, String stateName) {
        File file = new File(this.states, stateName + ".html");
        this.writeFile(context, file, "state.html");
    }

    void persistDom(String name, @Nullable String dom) {
        try {
            Files.write((CharSequence)Strings.nullToEmpty((String)dom), (File)new File(this.doms, name + ".html"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.warn("Could not save dom state for {}", (Object)name);
            LOG.debug("Could not save dom state", (Throwable)e);
        }
    }

    String getDom(String name) {
        try {
            return Files.toString((File)new File(this.doms, name + ".html"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return "Could not load DOM: " + e.getLocalizedMessage();
        }
    }
}

