/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateVertex;
import com.crawljax.plugins.crawloverview.model.CandidateElementPosition;
import com.crawljax.plugins.crawloverview.model.State;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class StateBuilder {
    private final BlockingQueue<CandidateElementPosition> candidates = Queues.newLinkedBlockingQueue();
    private final StateVertex state;
    private final AtomicInteger fanIn = new AtomicInteger();
    private final AtomicInteger fanOut = new AtomicInteger();
    private final ImmutableList.Builder<String> failedEvents = new ImmutableList.Builder();
    private final long timeAdded;

    public StateBuilder(StateVertex state) {
        this.state = state;
        this.timeAdded = System.currentTimeMillis();
    }

    public String getName() {
        return this.state.getName();
    }

    public boolean addCandidates(Collection<CandidateElementPosition> candidates) {
        return this.candidates.addAll(candidates);
    }

    public ImmutableList<CandidateElementPosition> getCandidates() {
        ArrayList buffer = Lists.newArrayListWithCapacity((int)this.candidates.size());
        this.candidates.drainTo(buffer);
        return ImmutableList.copyOf((Collection)buffer);
    }

    public int incrementFanOut() {
        return this.fanOut.incrementAndGet();
    }

    public int incrementFanIn() {
        return this.fanIn.incrementAndGet();
    }

    public State build() {
        return new State(this.state, this.fanIn.get(), this.fanOut.get(), this.getCandidates(), (ImmutableList<String>)this.failedEvents.build(), this.state.hasNearDuplicate(), this.getNearestState(), this.state.getDistToNearestState(), this.timeAdded);
    }

    private String getNearestState() {
        if (this.state.getNearestState() == -1) {
            return "null";
        }
        if (this.state.getNearestState() == 0) {
            return "index";
        }
        return "state" + this.state.getNearestState();
    }

    public void eventFailed(Eventable eventable) {
        this.failedEvents.add((Object)eventable.getIdentification().toString());
    }
}

