/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview;

import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import com.crawljax.plugins.crawloverview.OutputBuilder;
import com.crawljax.plugins.crawloverview.model.CandidateElementPosition;
import com.crawljax.plugins.crawloverview.model.State;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateWriter {
    private static final Logger LOG = LoggerFactory.getLogger(StateWriter.class);
    private static final String COLOR_NEW_STATE = "green";
    private static final String COLOR_A_PREVIOUS_STATE = "#00FFFF";
    private static final String COLOR_NO_STATE_CHANGE = "orange";
    private final OutputBuilder outBuilder;
    private final StateFlowGraph sfg;
    private final Map<String, StateVertex> visitedStates;

    public StateWriter(OutputBuilder outBuilder, StateFlowGraph sfg, Map<String, StateVertex> visitedStates) {
        this.outBuilder = outBuilder;
        this.sfg = sfg;
        this.visitedStates = visitedStates;
    }

    void writeHtmlForState(State state) {
        LOG.debug("Writing state file for state {}", (Object)state.getName());
        VelocityContext context = new VelocityContext();
        context.put("name", (Object)state.getName());
        context.put("screenshot", (Object)(state.getName() + ".png"));
        context.put("elements", this.getElements(this.sfg, state));
        context.put("fanIn", (Object)state.getFanIn());
        context.put("fanOut", (Object)state.getFanOut());
        context.put("url", (Object)state.getUrl());
        context.put("cluster", (Object)state.getCluster());
        String failedEvents = "-";
        if (!state.getFailedEvents().isEmpty()) {
            failedEvents = Joiner.on((String)", ").join(state.getFailedEvents());
        }
        context.put("failedEvents", (Object)failedEvents);
        String dom = this.outBuilder.getDom(state.getName());
        dom = StringEscapeUtils.escapeHtml4((String)dom);
        context.put("dom", (Object)dom);
        context.put("hasNearDuplicate", (Object)state.isHasNearDuplicate());
        context.put("nearestState", (Object)state.getNearestState());
        context.put("distToNearestState", (Object)state.getDistToNearestState());
        String name = state.getName();
        this.outBuilder.writeState(context, name);
    }

    private List<Map<String, String>> getElements(StateFlowGraph sfg, State state) {
        ImmutableList<CandidateElementPosition> candidateElements = state.getCandidateElements();
        ArrayList elements = Lists.newArrayListWithCapacity((int)candidateElements.size());
        for (CandidateElementPosition element : candidateElements) {
            Eventable eventable = this.getEventableByCandidateElementInState(state, element);
            StateVertex toState = null;
            HashMap<String, Object> elementMap = new HashMap<String, Object>();
            elementMap.put("xpath", element.getXpath());
            elementMap.put("left", "" + (element.getLeft() - 3));
            elementMap.put("top", "" + (element.getTop() - 3));
            elementMap.put("width", "" + (element.getWidth() + 2));
            elementMap.put("height", "" + (element.getHeight() + 2));
            if (eventable != null) {
                toState = eventable.getTargetStateVertex();
            }
            if (toState != null) {
                elementMap.put("targetname", toState.getName());
                if (this.getStateNumber(toState.getName()) < this.getStateNumber(state.getName())) {
                    elementMap.put("color", COLOR_A_PREVIOUS_STATE);
                } else {
                    elementMap.put("color", COLOR_NEW_STATE);
                }
                elementMap.put("zindex", "20");
                elementMap.put("cursor", "pointer");
            } else {
                elementMap.put("targetname", "");
                elementMap.put("color", COLOR_NO_STATE_CHANGE);
                elementMap.put("cursor", "normal");
                elementMap.put("zindex", "10");
            }
            elements.add(elementMap);
        }
        return elements;
    }

    private Eventable getEventableByCandidateElementInState(State state, CandidateElementPosition element) {
        StateVertex vertex = this.visitedStates.get(state.getName());
        for (Eventable eventable : this.sfg.getOutgoingClickables(vertex)) {
            if (!eventable.getIdentification().getValue().equals(element.getXpath())) continue;
            return eventable;
        }
        return null;
    }

    private int getStateNumber(String name) {
        if ("index".equals(name)) {
            return 0;
        }
        return Integer.parseInt(name.replace("state", ""));
    }
}

