/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview.model;

import com.crawljax.core.CrawljaxException;
import com.crawljax.core.state.Element;
import com.crawljax.core.state.Eventable;
import com.crawljax.plugins.crawloverview.CrawlOverviewException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Edge {
    private final String from;
    private final String to;
    private final int hash;
    private final String text;
    private final String id;
    private final String element;
    private final String eventType;

    public Edge(Eventable eventable) {
        try {
            this.from = eventable.getSourceStateVertex().getName();
            this.to = eventable.getTargetStateVertex().getName();
        }
        catch (CrawljaxException e) {
            throw new CrawlOverviewException("Could not get state vertex", e);
        }
        this.hash = this.buildHash();
        this.id = eventable.getIdentification().toString();
        Element el = eventable.getElement();
        if (el == null) {
            this.element = "unkown";
            this.text = eventable.getIdentification().getValue();
        } else {
            this.element = el.toString();
            this.text = el.getText();
        }
        this.eventType = eventable.getEventType().toString();
    }

    @JsonCreator
    public Edge(@JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="hash") int hash, @JsonProperty(value="text") String text, @JsonProperty(value="id") String id, @JsonProperty(value="element") String element, @JsonProperty(value="eventType") String eventType) {
        this.from = from;
        this.to = to;
        this.hash = hash;
        this.text = text;
        this.id = id;
        this.element = element;
        this.eventType = eventType;
    }

    private final int buildHash() {
        return Objects.hashCode((Object[])new Object[]{this.from, this.to, this.text, this.id, this.element, this.eventType});
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "Edge [from=" + this.from + ", to=" + this.to + ", text=" + this.text + "]";
    }

    public String getId() {
        return this.id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Edge) {
            Edge that = (Edge)object;
            return Objects.equal((Object)this.from, (Object)that.from) && Objects.equal((Object)this.to, (Object)that.to) && Objects.equal((Object)this.text, (Object)that.text) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.element, (Object)that.element) && Objects.equal((Object)this.eventType, (Object)that.eventType);
        }
        return false;
    }
}

