/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview.model;

import com.crawljax.core.state.StateVertex;
import com.crawljax.plugins.crawloverview.model.CandidateElementPosition;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class State {
    private final String name;
    private final String url;
    private final ImmutableList<CandidateElementPosition> candidateElements;
    private final int fanIn;
    private final int fanOut;
    private final int id;
    private final ImmutableList<String> failedEvents;
    private final boolean hasNearDuplicate;
    private final String nearestState;
    private final double distToNearestState;
    private final int cluster;
    private long timeAdded;
    private final boolean onURL;

    public boolean isOnURL() {
        return this.onURL;
    }

    public State(StateVertex state, int fanIn, int fanOut, ImmutableList<CandidateElementPosition> candidates, ImmutableList<String> failedEvents, boolean hasNearDuplicate, String nearestState, double distToNearestState) {
        this.fanIn = fanIn;
        this.fanOut = fanOut;
        this.candidateElements = candidates;
        this.failedEvents = failedEvents;
        this.name = state.getName();
        this.url = state.getUrl();
        this.id = state.getId();
        this.hasNearDuplicate = hasNearDuplicate;
        this.nearestState = nearestState;
        this.distToNearestState = distToNearestState;
        this.cluster = state.getCluster();
        this.onURL = state.isOnURL();
    }

    @JsonCreator
    public State(@JsonProperty(value="name") String name, @JsonProperty(value="url") String url, @JsonProperty(value="candidateElements") ImmutableList<CandidateElementPosition> candidateElements, @JsonProperty(value="fanIn") int fanIn, @JsonProperty(value="fanOut") int fanOut, @JsonProperty(value="id") int id, @JsonProperty(value="failedEvents") ImmutableList<String> failedEvents, @JsonProperty(value="hasNearDuplicate") boolean hasNearDuplicate, @JsonProperty(value="nearDuplicate") String nearestState, @JsonProperty(value="distToNearestState") double distToNearestState, @JsonProperty(value="cluster") int cluster, @JsonProperty(value="timeAdded") long timeAdded, @JsonProperty(value="onURL") boolean onURL) {
        this.name = name;
        this.url = url;
        this.candidateElements = candidateElements;
        this.fanIn = fanIn;
        this.fanOut = fanOut;
        this.id = id;
        this.failedEvents = failedEvents;
        this.hasNearDuplicate = hasNearDuplicate;
        this.nearestState = nearestState;
        this.distToNearestState = distToNearestState;
        this.cluster = cluster;
        this.timeAdded = timeAdded;
        this.onURL = onURL;
    }

    public State(StateVertex state, int fanIn, int fanOut, ImmutableList<CandidateElementPosition> candidates, ImmutableList<String> failedEvents, boolean hasNearDuplicate, String nearestState, double distToNearestState, long timeAdded) {
        this.fanIn = fanIn;
        this.fanOut = fanOut;
        this.candidateElements = candidates;
        this.failedEvents = failedEvents;
        this.name = state.getName();
        this.url = state.getUrl();
        this.id = state.getId();
        this.hasNearDuplicate = hasNearDuplicate;
        this.nearestState = nearestState;
        this.distToNearestState = distToNearestState;
        this.timeAdded = timeAdded;
        this.cluster = state.getCluster();
        this.onURL = state.isOnURL();
    }

    public int getCluster() {
        return this.cluster;
    }

    public double getDistToNearestState() {
        return this.distToNearestState;
    }

    public long getTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(long timeAdded) {
        this.timeAdded = timeAdded;
    }

    public boolean isHasNearDuplicate() {
        return this.hasNearDuplicate;
    }

    public String getNearestState() {
        return this.nearestState;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public ImmutableList<CandidateElementPosition> getCandidateElements() {
        return this.candidateElements;
    }

    public int getFanIn() {
        return this.fanIn;
    }

    public int getFanOut() {
        return this.fanOut;
    }

    public int getId() {
        return this.id;
    }

    public ImmutableList<String> getFailedEvents() {
        return this.failedEvents;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.url, this.candidateElements, this.fanIn, this.fanOut, this.id, this.failedEvents});
    }

    public boolean equals(Object object) {
        if (object instanceof State) {
            State that = (State)object;
            return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.url, (Object)that.url) && Objects.equal(this.candidateElements, that.candidateElements) && Objects.equal((Object)this.fanIn, (Object)that.fanIn) && Objects.equal((Object)this.fanOut, (Object)that.fanOut) && Objects.equal(this.failedEvents, that.failedEvents);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("id", this.id).add("url", (Object)this.url).add("candidateElements", this.candidateElements).add("fanIn", this.fanIn).add("fanOut", this.fanOut).add("failedEvents", this.failedEvents).add("hasNearDuplicate", this.hasNearDuplicate).add("nearestState", (Object)this.nearestState).add("distToNearestState", this.distToNearestState).add("timeAdded", this.timeAdded).toString();
    }
}

