/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview.model;

import com.crawljax.plugins.crawloverview.model.State;
import com.crawljax.plugins.crawloverview.model.StateCounter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StateStatistics {
    private final StateCounter leastFanOut;
    private final StateCounter leastFanIn;
    private final StateCounter mostFanOut;
    private final StateCounter mostFanIn;
    private final int totalNumberOfStates;
    private final ImmutableSetMultimap<String, String> urls;

    public StateStatistics(Collection<State> states) {
        State randomState;
        this.totalNumberOfStates = states.size();
        State tmpLeastFanOut = randomState = states.iterator().next();
        State tmpMostFanOut = randomState;
        State tmpLeastFanIn = randomState;
        State tmpMostFanIn = randomState;
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (State state : states) {
            if (state.getFanIn() > tmpMostFanIn.getFanIn()) {
                tmpMostFanIn = state;
            } else if (state.getFanIn() < tmpLeastFanIn.getFanIn()) {
                tmpLeastFanIn = state;
            }
            if (state.getFanOut() > tmpMostFanOut.getFanOut()) {
                tmpMostFanOut = state;
            } else if (state.getFanOut() < tmpLeastFanOut.getFanOut()) {
                tmpLeastFanOut = state;
            }
            builder.put((Object)state.getUrl(), (Object)state.getName());
        }
        this.urls = builder.build();
        this.leastFanOut = new StateCounter(tmpLeastFanOut.getName(), tmpLeastFanOut.getFanOut());
        this.leastFanIn = new StateCounter(tmpLeastFanIn.getName(), tmpLeastFanIn.getFanIn());
        this.mostFanOut = new StateCounter(tmpMostFanOut.getName(), tmpMostFanOut.getFanOut());
        this.mostFanIn = new StateCounter(tmpMostFanIn.getName(), tmpMostFanIn.getFanIn());
    }

    @JsonCreator
    public StateStatistics(@JsonProperty(value="leastFanOut") StateCounter leastFanOut, @JsonProperty(value="leastFanIn") StateCounter leastFanIn, @JsonProperty(value="mostFanOut") StateCounter mostFanOut, @JsonProperty(value="mostFanIn") StateCounter mostFanIn, @JsonProperty(value="totalNumberOfStates") int totalNumberOfStates, @JsonProperty(value="urls") ImmutableSetMultimap<String, String> urls) {
        this.leastFanOut = leastFanOut;
        this.leastFanIn = leastFanIn;
        this.mostFanOut = mostFanOut;
        this.mostFanIn = mostFanIn;
        this.totalNumberOfStates = totalNumberOfStates;
        this.urls = urls;
    }

    public StateCounter getLeastFanIn() {
        return this.leastFanIn;
    }

    public StateCounter getLeastFanOut() {
        return this.leastFanOut;
    }

    public StateCounter getMostFanIn() {
        return this.mostFanIn;
    }

    public StateCounter getMostFanOut() {
        return this.mostFanOut;
    }

    public int getTotalNumberOfStates() {
        return this.totalNumberOfStates;
    }

    public ImmutableSetMultimap<String, String> getUrls() {
        return this.urls;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.leastFanOut, this.leastFanIn, this.mostFanOut, this.mostFanIn, this.totalNumberOfStates, this.urls});
    }

    public boolean equals(Object object) {
        if (object instanceof StateStatistics) {
            StateStatistics that = (StateStatistics)object;
            return Objects.equal((Object)this.leastFanOut, (Object)that.leastFanOut) && Objects.equal((Object)this.leastFanIn, (Object)that.leastFanIn) && Objects.equal((Object)this.mostFanOut, (Object)that.mostFanOut) && Objects.equal((Object)this.mostFanIn, (Object)that.mostFanIn) && Objects.equal((Object)this.totalNumberOfStates, (Object)that.totalNumberOfStates) && Objects.equal(this.urls, that.urls);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("leastFanOut", (Object)this.leastFanOut).add("leastFanIn", (Object)this.leastFanIn).add("mostFanOut", (Object)this.mostFanOut).add("mostFanIn", (Object)this.mostFanIn).add("totalNumberOfStates", this.totalNumberOfStates).add("urls", this.urls).toString();
    }
}

