/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.crawloverview.model;

import com.crawljax.core.CrawlSession;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.plugins.crawloverview.model.StateStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.text.DecimalFormat;
import java.util.Date;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.time.DurationFormatUtils;

@Immutable
public class Statistics {
    private final String duration;
    private final int crawlPaths;
    private final String averageDomSize;
    private final int edges;
    private final Date startDate;
    private final StateStatistics stateStats;
    private final int failedEvents;

    public Statistics(CrawlSession session, StateStatistics stateStats, Date startDate, int failedEvents) {
        this.stateStats = stateStats;
        this.failedEvents = failedEvents;
        this.startDate = new Date(startDate.getTime());
        StateFlowGraph stateFlowGraph = session.getStateFlowGraph();
        this.duration = this.calculateDuration(session);
        this.edges = stateFlowGraph.getAllEdges().size();
        this.crawlPaths = session.getCrawlPaths().size();
        double bytes = stateFlowGraph.getMeanStateStringSize();
        this.averageDomSize = new DecimalFormat().format(bytes / 1000.0) + " kB";
    }

    @JsonCreator
    public Statistics(@JsonProperty(value="duration") String duration, @JsonProperty(value="crawlPaths") int crawlPaths, @JsonProperty(value="averageDomSize") String averageDomSize, @JsonProperty(value="edges") int edges, @JsonProperty(value="startDate") Date startDate, @JsonProperty(value="stateStats") StateStatistics stateStats, @JsonProperty(value="failedEvents") int failedEvents) {
        this.duration = duration;
        this.crawlPaths = crawlPaths;
        this.averageDomSize = averageDomSize;
        this.edges = edges;
        this.startDate = startDate;
        this.stateStats = stateStats;
        this.failedEvents = failedEvents;
    }

    private String calculateDuration(CrawlSession session) {
        long start = session.getStartTime();
        long stop = System.currentTimeMillis();
        return DurationFormatUtils.formatDurationWords((long)(stop - start), (boolean)true, (boolean)true);
    }

    public String getAverageDomSize() {
        return this.averageDomSize;
    }

    public String getDuration() {
        return this.duration;
    }

    public int getCrawlPaths() {
        return this.crawlPaths;
    }

    public int getEdges() {
        return this.edges;
    }

    public StateStatistics getStateStats() {
        return this.stateStats;
    }

    public Date getStartDate() {
        return new Date(this.startDate.getTime());
    }

    public int getFailedEvents() {
        return this.failedEvents;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.duration, this.crawlPaths, this.averageDomSize, this.edges, this.stateStats, this.failedEvents});
    }

    public boolean equals(Object object) {
        if (object instanceof Statistics) {
            Statistics that = (Statistics)object;
            return Objects.equal((Object)this.duration, (Object)that.duration) && Objects.equal((Object)this.crawlPaths, (Object)that.crawlPaths) && Objects.equal((Object)this.averageDomSize, (Object)that.averageDomSize) && Objects.equal((Object)this.edges, (Object)that.edges) && Objects.equal((Object)this.stateStats, (Object)that.stateStats) && Objects.equal((Object)this.failedEvents, (Object)that.failedEvents);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("duration", (Object)this.duration).add("failedEvents", this.failedEvents).add("crawlPaths", this.crawlPaths).add("averageDomSize", (Object)this.averageDomSize).add("edges", this.edges).add("startDate", (Object)this.startDate).add("stateStats", (Object)this.stateStats).toString();
    }
}

