/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.browser;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.WebDriverBackedEmbeddedBrowser;
import com.google.common.base.Strings;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserProvider
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(BrowserProvider.class);
    private List<RemoteWebDriver> usedBrowsers;

    public static EmbeddedBrowser.BrowserType getBrowserType() {
        String browser = System.getProperty("test.browser");
        if (!Strings.isNullOrEmpty((String)browser)) {
            return EmbeddedBrowser.BrowserType.valueOf((String)browser);
        }
        return EmbeddedBrowser.BrowserType.CHROME_HEADLESS;
    }

    protected void before() {
        this.usedBrowsers = new LinkedList<RemoteWebDriver>();
    }

    public EmbeddedBrowser newEmbeddedBrowser() {
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)this.newBrowser());
    }

    public RemoteWebDriver newBrowser() {
        RemoteWebDriver driver;
        switch (BrowserProvider.getBrowserType()) {
            case CHROME: {
                WebDriverManager wdm = WebDriverManager.chromedriver();
                driver = (RemoteWebDriver)wdm.create();
                break;
            }
            case CHROME_HEADLESS: {
                ChromeOptions optionsChrome = new ChromeOptions();
                optionsChrome.addArguments(new String[]{"--headless"});
                WebDriverManager wdm = WebDriverManager.chromedriver();
                wdm.capabilities((Capabilities)optionsChrome);
                driver = (RemoteWebDriver)wdm.create();
                break;
            }
            case FIREFOX: {
                WebDriverManager wdm = WebDriverManager.firefoxdriver();
                driver = (RemoteWebDriver)wdm.create();
                break;
            }
            case FIREFOX_HEADLESS: {
                FirefoxOptions firefoxOptions = new FirefoxOptions();
                firefoxOptions.setCapability("marionette", true);
                firefoxOptions.setHeadless(true);
                WebDriverManager wdm = WebDriverManager.firefoxdriver();
                wdm.capabilities((Capabilities)firefoxOptions);
                driver = (RemoteWebDriver)wdm.create();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported browser type " + BrowserProvider.getBrowserType());
            }
        }
        this.usedBrowsers.add(driver);
        driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS).pageLoadTimeout(30L, TimeUnit.SECONDS).setScriptTimeout(30L, TimeUnit.SECONDS);
        driver.manage().deleteAllCookies();
        return driver;
    }

    protected void after() {
        for (RemoteWebDriver browser : this.usedBrowsers) {
            try {
                if (browser.toString().contains("(null)")) continue;
                WebDriverManager.getInstance().quit();
            }
            catch (RuntimeException e) {
                LOG.warn("Could not close the browser: {}", (Object)e.getMessage());
            }
        }
    }
}

