/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.browser;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.WebDriverBackedEmbeddedBrowser;
import com.crawljax.browser.WebDriverBackedEmbeddedBrowserTest;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.forms.FormInput;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;

@Category(value={BrowserTest.class})
public class WebDriverBackedEmbeddedBrowserNoCrashTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("site");
    @Rule
    public final BrowserProvider provider = new BrowserProvider();
    private EmbeddedBrowser browser;

    @Before
    public void setUp() {
        this.browser = WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)this.provider.newBrowser());
    }

    @Test
    public final void testClose() {
        this.browser.close();
    }

    @Test
    public final void testCloseOtherWindows() {
        this.browser.closeOtherWindows();
    }

    @Test
    @Ignore
    public final void testExecuteJavaScript() throws CrawljaxException {
        try {
            this.browser.executeJavaScript("alert('testing');");
        }
        catch (CrawljaxException e) {
            Assert.fail((String)"A WebDriverException needed to be thrown");
        }
    }

    @Test
    public final void testFireEvent() throws Exception {
        this.browser.goToUrl(SERVER.getSiteUrl().resolve("simple.html"));
        this.browser.fireEventAndWait(new Eventable(new Identification(Identification.How.xpath, "//H1"), Eventable.EventType.click));
    }

    @Test
    public final void testGetCurrentUrl() {
        this.browser.getCurrentUrl();
    }

    @Test
    public final void testGetDom() throws CrawljaxException, URISyntaxException {
        URL index = WebDriverBackedEmbeddedBrowserTest.class.getResource("/site/simple.html");
        this.browser.goToUrl(index.toURI());
        this.browser.getStrippedDom();
    }

    @Test
    public final void testGetDomWithoutIframeContent() throws CrawljaxException {
        this.browser.getStrippedDomWithoutIframeContent();
    }

    @Test
    public final void testGoBack() {
        this.browser.goBack();
    }

    @Test
    public final void testGoToUrl() throws CrawljaxException {
        this.browser.goToUrl(URI.create("http://non.exsisting.domain"));
    }

    @Test
    public final void testInput() throws CrawljaxException {
        Assert.assertFalse((String)"Wrong Xpath so false because of error", (boolean)this.browser.input(new Identification(Identification.How.xpath, "/RUBISH"), "some"));
    }

    @Test
    public final void testIsVisible() {
        Assert.assertFalse((String)"Wrong Xpath so not visible", (boolean)this.browser.isVisible(new Identification(Identification.How.xpath, "/RUBISH")));
    }

    @Test
    public final void testGetInputWithRandomValue() {
        Assert.assertNull((String)"Wrong Xpath so null as result of InputWithRandomValue", (Object)this.browser.getInputWithRandomValue(new FormInput(FormInput.InputType.TEXT, new Identification(Identification.How.xpath, "/RUBISH"), "abc")));
    }

    @Test
    public final void testGetFrameDom() {
        Assert.assertTrue((String)"Wrong FrameID so empty", (boolean)this.browser.getFrameDom("123").equals(""));
    }

    @Test
    public final void testElementExists() {
        Assert.assertFalse((String)"Wrong Xpath so element does not exist", (boolean)this.browser.elementExists(new Identification(Identification.How.xpath, "/RUBISH")));
    }

    @Test
    public final void testGetWebElement() {
        try {
            this.browser.getWebElement(new Identification(Identification.How.xpath, "/RUBISH"));
        }
        catch (NoSuchElementException e) {
            return;
        }
        Assert.fail((String)"NoSuchElementException should have been thrown");
    }
}

