/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.browser;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.WebDriverBackedEmbeddedBrowser;
import com.crawljax.core.CrawljaxException;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import com.crawljax.util.DomUtils;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.WebDriver;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Category(value={BrowserTest.class})
public class WebDriverBackedEmbeddedBrowserTest {
    @ClassRule
    public static final RunWithWebServer SERVER = new RunWithWebServer("/site/iframe");
    @Rule
    public final BrowserProvider provider = new BrowserProvider();

    @Test
    public void testGetDocument() throws Exception {
        WebDriverBackedEmbeddedBrowser browser = WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)this.provider.newBrowser(), (ImmutableSortedSet)ImmutableSortedSet.of(), (long)100L, (long)100L);
        browser.goToUrl(SERVER.getSiteUrl());
        Document doc = DomUtils.asDocument((String)browser.getStrippedDom());
        NodeList frameNodes = doc.getElementsByTagName("IFRAME");
        Assert.assertEquals((long)2L, (long)frameNodes.getLength());
        doc = DomUtils.asDocument((String)browser.getStrippedDomWithoutIframeContent());
        frameNodes = doc.getElementsByTagName("IFRAME");
        Assert.assertEquals((long)2L, (long)frameNodes.getLength());
    }

    @Test
    public void saveScreenShot() throws CrawljaxException, IOException {
        WebDriverBackedEmbeddedBrowser browser = WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)this.provider.newBrowser(), (ImmutableSortedSet)ImmutableSortedSet.of(), (long)500L, (long)500L);
        File f = File.createTempFile("test-screenshot", ".png");
        f.deleteOnExit();
        browser.goToUrl(SERVER.getSiteUrl());
        browser.saveScreenShot(f);
        Assert.assertNotEquals((long)Files.size(f.toPath()), (long)0L);
    }
}

