/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.browser.matchers;

import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mockito.Mockito;

public class StateFlowGraphMatchers {
    @Factory
    public static FeatureMatcher<StateFlowGraph, Integer> hasEdges(int edges) {
        return new FeatureMatcher<StateFlowGraph, Integer>(IsEqual.equalTo((Object)edges), "State-Flow Graph with number of edges", "number of edges"){

            protected Integer featureValueOf(StateFlowGraph actual) {
                return actual.getAllEdges().size();
            }
        };
    }

    @Factory
    public static FeatureMatcher<StateFlowGraph, Integer> hasStates(int states) {
        return new FeatureMatcher<StateFlowGraph, Integer>(IsEqual.equalTo((Object)states), "State-Flow Graph with number of states", "number of states"){

            protected Integer featureValueOf(StateFlowGraph actual) {
                return actual.getAllStates().size();
            }
        };
    }

    @Factory
    public static FeatureMatcher<StateVertex, String> stateWithDomSubstring(String substring) {
        return new FeatureMatcher<StateVertex, String>(Matchers.containsString((String)substring), "StateVertex with in the DOM", "substring"){

            protected String featureValueOf(StateVertex actual) {
                return actual.getDom();
            }
        };
    }

    @Test
    public void testStateWithDomSubstring() {
        StateVertex vertex = (StateVertex)Mockito.mock(StateVertex.class);
        Mockito.when((Object)vertex.getDom()).thenReturn((Object)"paap");
        MatcherAssert.assertThat((Object)vertex, (Matcher)Is.is(StateFlowGraphMatchers.stateWithDomSubstring("aap")));
        MatcherAssert.assertThat((Object)vertex, (Matcher)Is.is((Matcher)IsNot.not(StateFlowGraphMatchers.stateWithDomSubstring("bla"))));
    }
}

