/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition.browserwaiter;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.browserwaiter.ExpectedCondition;
import com.crawljax.condition.browserwaiter.WaitCondition;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WaitConditionTest {
    private static final int WAIT_TIMEOUT = 0;
    private static final int WAIT_SUCCESS = 1;
    private static final int WAIT_TIME_NONE = 0;
    private static final int WAIT_TIME_LONG = 2000;
    @Mock
    private EmbeddedBrowser browser;

    @Before
    public void before() {
        Mockito.when((Object)this.browser.getCurrentUrl()).thenReturn((Object)"tmp");
    }

    @Test
    public void testWaitConditionNoIndexOutOfBounceAfterTwoTries() {
        WaitCondition wc = new WaitCondition("tmp", 2000, new ExpectedCondition[]{new TimeoutExpectedCondition()});
        Assert.assertEquals((String)"Wait timed out", (long)0L, (long)wc.testAndWait(this.browser));
    }

    @Test
    public void testWaitConditionSuccessZeroSpecified() {
        WaitCondition wc = new WaitCondition("tmp", 2000, new ArrayList());
        Assert.assertEquals((String)"Wait success", (long)1L, (long)wc.testAndWait(this.browser));
    }

    @Test
    public void testWaitConditionSuccessZeroSpecifiedZeroTimeout() {
        WaitCondition wc = new WaitCondition("tmp", 2000, new ArrayList());
        Assert.assertEquals((String)"Wait success", (long)1L, (long)wc.testAndWait(this.browser));
    }

    @Test
    public void testWaitConditionNoIndexOutOfBounceAfterFirstTry() {
        WaitCondition wc = new WaitCondition("tmp", 2000, new ExpectedCondition[]{browser -> {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
                e.printStackTrace();
            }
            return true;
        }});
        Assert.assertEquals((String)"Wait timed out", (long)0L, (long)wc.testAndWait(this.browser));
    }

    @Test
    public void testWaitConditionNotRunBecauseUrl() {
        WaitCondition wc = new WaitCondition("tmp/foo", 2000, new ExpectedCondition[]{new TimeoutExpectedCondition()});
        Assert.assertEquals((String)"Wait not run because browser url mismatch", (long)-1L, (long)wc.testAndWait(this.browser));
    }

    @Test
    public void testWaitConditionSuccessfulRun() {
        WaitCondition wc = new WaitCondition("tmp", 2000, new ExpectedCondition[]{browser -> true});
        Assert.assertEquals((String)"Wait succeeded", (long)1L, (long)wc.testAndWait(this.browser));
    }

    @Test
    public void testWaitConditionTimeoutRun() {
        WaitCondition wc = new WaitCondition("tmp", 0, new ExpectedCondition[]{browser -> true});
        Assert.assertEquals((String)"Wait succeeded", (long)0L, (long)wc.testAndWait(this.browser));
    }

    private static class TimeoutExpectedCondition
    implements ExpectedCondition {
        private int count = 0;

        private TimeoutExpectedCondition() {
        }

        public boolean isSatisfied(EmbeddedBrowser browser) {
            ++this.count;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
                e.printStackTrace();
            }
            return this.count > 1;
        }
    }
}

