/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.BrowserProvider;
import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.WebDriverBackedEmbeddedBrowser;
import com.crawljax.clickabledetection.ClickableDetectorPlugin;
import com.crawljax.condition.ConditionTypeChecker;
import com.crawljax.condition.eventablecondition.EventableConditionChecker;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CandidateElementExtractor;
import com.crawljax.core.CandidateElementManager;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.ExtractorManager;
import com.crawljax.core.configuration.BrowserConfiguration;
import com.crawljax.core.configuration.BrowserOptions;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.state.DefaultStateVertexFactory;
import com.crawljax.core.state.StateVertex;
import com.crawljax.forms.FormHandler;
import com.crawljax.stateabstractions.dom.RTEDStateVertexFactory;
import com.crawljax.test.BrowserTest;
import com.crawljax.test.RunWithWebServer;
import com.crawljax.util.DomUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Category(value={BrowserTest.class})
@RunWith(value=MockitoJUnitRunner.class)
public class CandidateElementExtractorTest {
    @ClassRule
    public static final RunWithWebServer DEMO_SITE_SERVER = new RunWithWebServer("/demo-site");
    private static final Logger LOG = LoggerFactory.getLogger(CandidateElementExtractorTest.class);
    private static StateVertex DUMMY_STATE = new DefaultStateVertexFactory().createIndex("http://localhost", "", "", null);
    @Rule
    public final BrowserProvider provider = new BrowserProvider();
    @Mock
    private Plugins plugins;
    private EmbeddedBrowser browser;

    @Test
    public void testExtract() throws CrawljaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)DEMO_SITE_SERVER.getSiteUrl());
        builder.crawlRules().click("a");
        builder.crawlRules().clickOnce(true);
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        this.browser.goToUrl(DEMO_SITE_SERVER.getSiteUrl());
        DUMMY_STATE = new DefaultStateVertexFactory().createIndex(this.browser.getCurrentUrl(), this.browser.getStrippedDom(), this.browser.getStrippedDom(), this.browser);
        ImmutableList candidates = extractor.extract(DUMMY_STATE);
        Assert.assertNotNull((Object)candidates);
        Assert.assertEquals((long)15L, (long)candidates.size());
    }

    @Test
    public void testExtractClickables() throws CrawljaxException, URISyntaxException, IOException {
        String url = DEMO_SITE_SERVER.getSiteUrl().toString() + "clickable/";
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)url);
        builder.crawlRules().clickElementsWithClickEventHandler();
        builder.crawlRules().clickOnce(true);
        BrowserOptions options = new BrowserOptions();
        options.setUSE_CDP(true);
        BrowserConfiguration browserConfiguration = new BrowserConfiguration(EmbeddedBrowser.BrowserType.CHROME, 1, options);
        builder.setBrowserConfig(browserConfiguration);
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        ((WebDriverBackedEmbeddedBrowser)this.browser).setUSE_CDP(true);
        this.browser.goToUrl(new URI(url));
        DUMMY_STATE = new RTEDStateVertexFactory(0.0).createIndex(this.browser.getCurrentUrl(), this.browser.getStrippedDom(), this.browser.getStrippedDom(), this.browser);
        new ClickableDetectorPlugin().findClickables(this.browser, DUMMY_STATE);
        ImmutableList candidates = extractor.extract(DUMMY_STATE);
        Assert.assertNotNull((Object)candidates);
        Assert.assertEquals((long)1L, (long)candidates.size());
    }

    private CandidateElementExtractor newElementExtractor(CrawljaxConfiguration config, boolean startBrowser) {
        this.browser = startBrowser ? this.provider.newEmbeddedBrowser() : null;
        FormHandler formHandler = new FormHandler(this.browser, config.getCrawlRules());
        EventableConditionChecker eventableConditionChecker = new EventableConditionChecker(config.getCrawlRules());
        ConditionTypeChecker crawlConditionChecker = new ConditionTypeChecker(config.getCrawlRules().getPreCrawlConfig().getCrawlConditions());
        CandidateElementManager checker = new CandidateElementManager(eventableConditionChecker, crawlConditionChecker);
        return new CandidateElementExtractor((ExtractorManager)checker, this.browser, formHandler, config);
    }

    @Test
    public void testExtractExclude() {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)DEMO_SITE_SERVER.getSiteUrl());
        builder.crawlRules().click("a");
        builder.crawlRules().dontClick("div").withAttribute("id", "menubar");
        builder.crawlRules().clickOnce(true);
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        this.browser.goToUrl(DEMO_SITE_SERVER.getSiteUrl());
        DUMMY_STATE = new DefaultStateVertexFactory().createIndex(this.browser.getCurrentUrl(), this.browser.getStrippedDom(), this.browser.getStrippedDom(), this.browser);
        ImmutableList candidates = extractor.extract(DUMMY_STATE);
        Assert.assertNotNull((Object)candidates);
        MatcherAssert.assertThat((Object)candidates, (Matcher)IsCollectionWithSize.hasSize((int)11));
    }

    @Test
    public void testExtractIframeContents() throws Exception {
        RunWithWebServer server = new RunWithWebServer("/site");
        server.before();
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((URI)server.getSiteUrl().resolve("iframe/"));
        builder.setBrowserConfig(new BrowserConfiguration(EmbeddedBrowser.BrowserType.CHROME));
        builder.crawlRules().click("a");
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        this.browser.goToUrl(server.getSiteUrl().resolve("iframe/"));
        DUMMY_STATE = new DefaultStateVertexFactory().createIndex(this.browser.getCurrentUrl(), this.browser.getStrippedDom(), this.browser.getStrippedDom(), this.browser);
        ImmutableList candidates = extractor.extract(DUMMY_STATE);
        for (CandidateElement e : candidates) {
            LOG.debug("candidate: " + e.getUniqueString());
        }
        server.after();
        Assert.assertNotNull((Object)extractor);
        Assert.assertNotNull((Object)candidates);
        MatcherAssert.assertThat((Object)candidates, (Matcher)IsCollectionWithSize.hasSize((int)9));
    }

    @Test
    public void whenNoFollowExternalUrlDoNotFollow() throws URISyntaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)"http://example.com");
        builder.crawlRules().click("a");
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        String file = "/candidateElementExtractorTest/domWithOneExternalAndTwoInternal.html";
        List<CandidateElement> extract = this.extractFromTestFile(extractor, file);
        MatcherAssert.assertThat((Object)config.getCrawlRules().followExternalLinks(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat(extract, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void whenFollowExternalUrlDoFollow() throws URISyntaxException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)"http://example.com");
        builder.crawlRules().click("a");
        builder.crawlRules().followExternalLinks(true);
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        String file = "/candidateElementExtractorTest/domWithOneExternalAndTwoInternal.html";
        List<CandidateElement> extract = this.extractFromTestFile(extractor, file);
        MatcherAssert.assertThat((Object)config.getCrawlRules().followExternalLinks(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(extract, (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    private List<CandidateElement> extractFromTestFile(CandidateElementExtractor extractor, String file) throws URISyntaxException {
        StateVertex currentState = (StateVertex)Mockito.mock(StateVertex.class);
        URL dom = Resources.getResource(this.getClass(), (String)file);
        this.browser.goToUrl(dom.toURI());
        currentState = new DefaultStateVertexFactory().createIndex(this.browser.getCurrentUrl(), this.browser.getStrippedDom(), this.browser.getStrippedDom(), this.browser);
        return extractor.extract(currentState);
    }

    @Test
    public void testElementAddition() throws URISyntaxException, IOException {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)"http://example.com");
        builder.crawlRules().click("a");
        builder.crawlRules().followExternalLinks(false);
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, false);
        Document document = DomUtils.asDocument((String)"");
        Element e = document.createElement("A");
        document.getElementsByTagName("body").item(0).appendChild(e);
        ArrayList results = new ArrayList();
        extractor.extractElements(document, results, "");
        Assert.assertFalse((boolean)extractor.hrefShouldBeIgnored(e));
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testExtractShouldIgnoreDownloadFiles() throws Exception {
        CrawljaxConfiguration.CrawljaxConfigurationBuilder builder = CrawljaxConfiguration.builderFor((String)"http://example.com");
        builder.crawlRules().click("a");
        CrawljaxConfiguration config = builder.build();
        CandidateElementExtractor extractor = this.newElementExtractor(config, true);
        String file = "/candidateElementExtractorTest/domWithFourTypeDownloadLink.html";
        List<CandidateElement> candidates = this.extractFromTestFile(extractor, file);
        for (CandidateElement e : candidates) {
            LOG.debug("candidate: " + e.getUniqueString());
        }
        Assert.assertNotNull(candidates);
        Assert.assertEquals((long)12L, (long)candidates.size());
    }
}

