/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.core.CandidateElement;
import com.crawljax.core.CandidateElementManager;
import com.crawljax.forms.FormInput;
import com.crawljax.util.DomUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CandidateElementManagerTest {
    private static Document document;
    private final List<FormInput> noFormInput = ImmutableList.of();

    @BeforeClass
    public static void setup() throws IOException {
        document = DomUtils.asDocument((String)"");
    }

    @Test
    public void testContainsElement() {
        CandidateElementManager manager = new CandidateElementManager(null, null);
        Element e = document.createElement("test");
        e.setAttribute("id", "abc");
        CandidateElement c = new CandidateElement(e, "", this.noFormInput);
        Assert.assertFalse((String)"CandidateElement.GeneralString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c.getGeneralString()));
        Assert.assertFalse((String)"CandidateElement.UniqueString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c.getUniqueString()));
        Assert.assertTrue((String)"CandidateElement correctly added", (boolean)manager.markChecked(c));
        Assert.assertTrue((String)"CandidateElement.GeneralString checked in CandidateElementManager", (boolean)manager.isChecked(c.getGeneralString()));
        Assert.assertTrue((String)"CandidateElement.UniqueString checked in CandidateElementManager", (boolean)manager.isChecked(c.getUniqueString()));
        e.setAttribute("id", "def");
        CandidateElement c2 = new CandidateElement(e, "", this.noFormInput);
        Assert.assertFalse((String)"CandidateElement.GeneralString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c2.getGeneralString()));
        Assert.assertFalse((String)"CandidateElement.UniqueString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c2.getUniqueString()));
        Assert.assertTrue((String)"CandidateElement correctly added", (boolean)manager.markChecked(c2));
        Assert.assertTrue((String)"CandidateElement.GeneralString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getGeneralString()));
        Assert.assertTrue((String)"CandidateElement.UniqueString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getUniqueString()));
        Assert.assertFalse((String)"CandidateElement already added", (boolean)manager.markChecked(c2));
        Assert.assertTrue((String)"CandidateElement.GeneralString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getGeneralString()));
        Assert.assertTrue((String)"CandidateElement.UniqueString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getUniqueString()));
    }

    @Test
    public void testContainsElementAtusa() {
        CandidateElementManager manager = new CandidateElementManager(null, null);
        Element e = document.createElement("test");
        e.setAttribute("id", "abc");
        e.setAttribute("atusa", "def");
        CandidateElement c = new CandidateElement(e, "", this.noFormInput);
        Assert.assertFalse((String)"CandidateElement.GeneralString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c.getGeneralString()));
        Assert.assertFalse((String)"CandidateElement.UniqueString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c.getUniqueString()));
        Assert.assertTrue((String)"CandidateElement correctly added", (boolean)manager.markChecked(c));
        Assert.assertTrue((String)"CandidateElement.GeneralString checked in CandidateElementManager", (boolean)manager.isChecked(c.getGeneralString()));
        Assert.assertTrue((String)"CandidateElement.UniqueString checked in CandidateElementManager", (boolean)manager.isChecked(c.getUniqueString()));
        e.setAttribute("atusa", "ghi");
        CandidateElement c2 = new CandidateElement(e, "", this.noFormInput);
        Assert.assertTrue((String)"CandidateElement.GeneralString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getGeneralString()));
        Assert.assertFalse((String)"CandidateElement.UniqueString not yet checked in CandidateElementManager", (boolean)manager.isChecked(c2.getUniqueString()));
        Assert.assertTrue((String)"CandidateElement correctly added", (boolean)manager.markChecked(c2));
        Assert.assertTrue((String)"CandidateElement.GeneralString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getGeneralString()));
        Assert.assertTrue((String)"CandidateElement.UniqueString checked in CandidateElementManager", (boolean)manager.isChecked(c2.getUniqueString()));
    }

    @Test
    public void testConcurrentIncrement() throws InterruptedException {
        CandidateElementManager manager = new CandidateElementManager(null, null);
        for (int i = 0; i < 10; ++i) {
            new Thread(() -> {
                for (int j = 0; j < 10; ++j) {
                    manager.increaseElementsCounter();
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        Thread.sleep(1000L);
        Assert.assertEquals((String)"100 Elements should be checked", (long)100L, (long)manager.numberOfExaminedElements());
    }
}

